/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import javax.xml.stream.XMLStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBTImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;

public class SubAppTImporter
extends FBTImporter {
    public SubAppTImporter(Palette palette) {
        super(palette);
    }

    public SubAppTImporter(XMLStreamReader reader, Palette palette) {
        super(reader, palette);
    }

    @Override
    public void setPalette(Palette palette) {
        super.setPalette(palette);
    }

    @Override
    public LibraryElement importType(IFile typeFile) throws TypeImportException {
        LibraryElement newType = super.importType(typeFile);
        return newType instanceof SubAppType ? newType : null;
    }

    @Override
    protected FBType createType() {
        SubAppType newType = LibraryElementFactory.eINSTANCE.createSubAppType();
        newType.setService(LibraryElementFactory.eINSTANCE.createService());
        return newType;
    }

    @Override
    protected SubAppType getType() {
        return (SubAppType)super.getType();
    }

    @Override
    protected String getStartElementName() {
        return "SubAppType";
    }

    @Override
    protected CommonElementImporter.IChildHandler getTypeChildrenHandler() {
        return name -> {
            switch (name) {
                case "Identification": {
                    this.parseIdentification(this.getType());
                    break;
                }
                case "VersionInfo": {
                    this.parseVersionInfo(this.getType());
                    break;
                }
                case "CompilerInfo": {
                    this.parseCompilerInfo(this.getType());
                    break;
                }
                case "SubAppInterfaceList": {
                    this.getType().setInterfaceList(this.parseInterfaceList("SubAppInterfaceList"));
                    break;
                }
                case "Service": {
                    this.parseService(this.getType());
                    break;
                }
                case "SubAppNetwork": {
                    this.getType().setFBNetwork(new SubAppNetworkImporter(this.getPalette(), this.getType().getInterfaceList(), this.getReader()).parseFBNetwork("SubAppNetwork"));
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        };
    }

    @Override
    protected String getEventOutputElement() {
        return "SubAppEventOutputs";
    }

    @Override
    protected String getEventInputElement() {
        return "SubAppEventInputs";
    }

    @Override
    protected String getEventElement() {
        return "SubAppEvent";
    }

    @Override
    protected void processWiths() {
    }
}

