/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.ui.internal.misc.StringMatcher;

public class PaletteFilter {
    private final Palette palette;

    public PaletteFilter(Palette palette) {
        this.palette = palette;
    }

    public List<PaletteEntry> findFBAndSubappTypes(String searchString) {
        Stream<Map.Entry<String, ? extends PaletteEntry>> stream = Stream.concat(this.palette.getFbTypes().entrySet().stream(), this.palette.getSubAppTypes().entrySet().stream());
        return this.findTypes(searchString, stream);
    }

    public List<PaletteEntry> findTypes(String searchString, Stream<Map.Entry<String, ? extends PaletteEntry>> stream) {
        StringMatcher matcher = this.setMatcher(searchString);
        return stream.filter(entry -> matcher.match((String)entry.getKey())).map(entry -> (PaletteEntry)entry.getValue()).collect(Collectors.toList());
    }

    private StringMatcher setMatcher(String searchString) {
        String searchPattern = searchString;
        if (!searchString.endsWith(" ")) {
            searchPattern = String.valueOf(searchPattern) + "*";
        }
        searchPattern = "*" + searchPattern;
        return new StringMatcher(searchPattern, true, false);
    }
}

