/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.commands;

import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.gef.commands.Command;

public class ResourceMoveCommand
extends Command {
    private Resource resource;
    private Device device;
    private Device targetDevice;
    private int indexNew;
    private int indexOld;

    public ResourceMoveCommand(Resource resource, Device targetDevice, int indexNew) {
        this.resource = resource;
        this.indexNew = indexNew;
        this.targetDevice = targetDevice;
    }

    public void execute() {
        this.device = this.resource.getDevice();
        this.indexOld = this.device.getResource().indexOf((Object)this.resource);
        this.redo();
    }

    public void undo() {
        if (this.device == this.targetDevice) {
            this.device.getResource().move(this.indexOld, (Object)this.resource);
        } else {
            this.targetDevice.getResource().remove((Object)this.resource);
            this.device.getResource().add(this.indexOld, (Object)this.resource);
        }
        SystemManager.INSTANCE.notifyListeners();
    }

    public void redo() {
        if (this.device == this.targetDevice) {
            if (this.indexNew >= this.device.getResource().size()) {
                this.device.getResource().move(this.device.getResource().size() - 1, (Object)this.resource);
            } else {
                this.device.getResource().move(this.indexNew, (Object)this.resource);
            }
        } else {
            this.device.getResource().remove((Object)this.resource);
            this.targetDevice.getResource().add(this.indexNew, (Object)this.resource);
        }
        SystemManager.INSTANCE.notifyListeners();
    }
}

