/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.navigator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.typemanagement.navigator.TypeLibRootElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class TypeLibRootContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    private BaseWorkbenchContentProvider workbenchContentProvider = new BaseWorkbenchContentProvider();
    private Map<AutomationSystem, TypeLibRootElement> typeLibElementStore = new HashMap<AutomationSystem, TypeLibRootElement>();
    private Viewer viewer;

    public TypeLibRootContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void dispose() {
        this.workbenchContentProvider.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof AutomationSystem) {
            Object[] retVal = new Object[]{this.getTypeLibRootElement((AutomationSystem)parentElement)};
            return retVal;
        }
        if (parentElement instanceof TypeLibRootElement) {
            return this.workbenchContentProvider.getChildren((Object)((TypeLibRootElement)parentElement).getSystem().getProject());
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof IResource && ((IResource)element).getParent() instanceof IProject) {
            return this.getTypeLibRootElement((IProject)((IResource)element).getParent());
        }
        if (element instanceof TypeLibRootElement) {
            return ((TypeLibRootElement)element).getSystem();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TypeLibRootElement) {
            return this.workbenchContentProvider.hasChildren((Object)((TypeLibRootElement)element).getSystem().getProject());
        }
        return false;
    }

    private TypeLibRootElement getTypeLibRootElement(AutomationSystem system) {
        TypeLibRootElement retVal = this.typeLibElementStore.get(system);
        if (retVal == null) {
            retVal = new TypeLibRootElement(system);
            this.typeLibElementStore.put(system, retVal);
        }
        return retVal;
    }

    private Object getTypeLibRootElement(IProject parent) {
        return this.getTypeLibRootElement(SystemManager.INSTANCE.getSystemForName(parent.getName()));
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.viewer != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TypeLibRootContentProvider.this.viewer.getControl().isDisposed()) {
                        TypeLibRootContentProvider.this.viewer.refresh();
                    }
                }
            });
        }
    }
}

