/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.linking.lazy;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class LazyURIEncoder {
    public static final String XTEXT_LINK = "|";
    public static final String SEP = "::";
    public static final String USE_INDEXED_FRAGMENTS_BINDING = "org.eclipse.xtext.linking.lazy.LazyURIEncoder.isUseIndexFragment";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.linking.lazy.LazyURIEncoder.isUseIndexFragment")
    private boolean isUseIndexFragment = false;

    public boolean isUseIndexFragment(Resource context) {
        return this.isUseIndexFragment && context instanceof LazyLinkingResource;
    }

    public String encode(EObject obj, EReference ref, INode node) {
        if (this.isUseIndexFragment(obj.eResource())) {
            return this.getIndexFragment(obj, ref, node);
        }
        StringBuilder fragment = new StringBuilder(4).append(XTEXT_LINK).append(SEP);
        this.appendShortFragment(obj, fragment);
        fragment.append(SEP);
        fragment.append(this.toShortExternalForm(obj.eClass(), ref)).append(SEP);
        this.getRelativePath(fragment, NodeModelUtils.getNode(obj), node);
        return fragment.toString();
    }

    protected String getIndexFragment(EObject obj, EReference ref, INode node) {
        Resource resource = obj.eResource();
        if (!(resource instanceof LazyLinkingResource)) {
            throw new IllegalStateException("Context object must be contained in a LazyLinkingResource : " + obj.eResource());
        }
        LazyLinkingResource lazyResource = (LazyLinkingResource)resource;
        int idx = lazyResource.addLazyProxyInformation(obj, ref, node);
        return XTEXT_LINK + idx;
    }

    public void appendShortFragment(EObject obj, StringBuilder target) {
        EReference containmentFeature = obj.eContainmentFeature();
        if (containmentFeature == null) {
            target.append(obj.eResource().getContents().indexOf((Object)obj));
        } else {
            EObject container = obj.eContainer();
            this.appendShortFragment(container, target);
            target.append('.').append(container.eClass().getFeatureID((EStructuralFeature)containmentFeature));
            if (containmentFeature.isMany()) {
                List list = (List)container.eGet((EStructuralFeature)containmentFeature);
                target.append('.').append(list.indexOf(obj));
            }
        }
    }

    public String toShortExternalForm(EClass clazz, EReference ref) {
        return Integer.toString(clazz.getFeatureID((EStructuralFeature)ref));
    }

    public Triple<EObject, EReference, INode> decode(Resource res, String uriFragment) {
        if (this.isUseIndexFragment(res)) {
            return this.getLazyProxyInformation(res, uriFragment);
        }
        List split = Strings.split((String)uriFragment, (String)SEP);
        EObject source = this.resolveShortFragment(res, (String)split.get(1));
        EReference ref = this.fromShortExternalForm(source.eClass(), (String)split.get(2));
        ICompositeNode compositeNode = NodeModelUtils.getNode(source);
        if (compositeNode == null) {
            throw new IllegalStateException("Couldn't resolve lazy link, because no node model is attached.");
        }
        INode textNode = this.getNode(compositeNode, (String)split.get(3));
        return Tuples.create((Object)source, (Object)ref, (Object)textNode);
    }

    protected Triple<EObject, EReference, INode> getLazyProxyInformation(Resource res, String uriFragment) {
        if (!(res instanceof LazyLinkingResource)) {
            throw new IllegalArgumentException("Given resource not a LazyLinkingResource");
        }
        int idx = this.getIndex(uriFragment);
        LazyLinkingResource lazyResource = (LazyLinkingResource)res;
        return lazyResource.getLazyProxyInformation(idx);
    }

    public int getIndex(String uriFragment) {
        int idx = -1;
        try {
            String string = uriFragment.substring(XTEXT_LINK.length());
            idx = Integer.parseInt(string);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Couldn't parse index from fragment '" + uriFragment + "'", e);
        }
        return idx;
    }

    public EObject resolveShortFragment(Resource res, String shortFragment) {
        List split = Strings.split((String)shortFragment, (char)'.');
        int contentsIdx = Integer.parseInt((String)split.get(0));
        EObject result = (EObject)res.getContents().get(contentsIdx);
        int splitIdx = 1;
        while (splitIdx < split.size()) {
            int featureId = Integer.parseInt((String)split.get(splitIdx++));
            EReference reference = (EReference)result.eClass().getEStructuralFeature(featureId);
            if (reference.isMany()) {
                List list = (List)result.eGet((EStructuralFeature)reference);
                int listIdx = Integer.parseInt((String)split.get(splitIdx++));
                result = (EObject)list.get(listIdx);
                continue;
            }
            result = (EObject)result.eGet((EStructuralFeature)reference);
        }
        return result;
    }

    public EReference fromShortExternalForm(EClass clazz, String shortForm) {
        int featureId = Integer.parseInt(shortForm);
        return (EReference)clazz.getEStructuralFeature(featureId);
    }

    public void getRelativePath(StringBuilder result, INode parserNode, INode node) {
        if (parserNode == node) {
            return;
        }
        if (this.isAncestor(parserNode, node)) {
            ICompositeNode parent = node.getParent();
            this.getRelativePath(result, parserNode, parent);
            int idx = 0;
            for (INode child = parent.getFirstChild(); child != node && child.hasNextSibling(); child = child.getNextSibling()) {
                ++idx;
            }
            result.append("/").append(idx);
        } else {
            result.append("/..");
            this.getRelativePath(result, parserNode.getParent(), node);
        }
    }

    protected boolean isAncestor(INode parent, INode child) {
        for (INode node = child; node != null; node = node.getParent()) {
            if (!node.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public INode getNode(EObject object, String fragment) {
        if (this.isUseIndexFragment(object.eResource())) {
            return (INode)this.decode(object.eResource(), fragment).getThird();
        }
        ICompositeNode compositeNode = NodeModelUtils.getNode(object);
        if (compositeNode == null) {
            throw new IllegalStateException("Couldn't resolve lazy link, because no node model is attached.");
        }
        List split = Strings.split((String)fragment, (String)SEP);
        INode node = this.getNode(compositeNode, (String)split.get(3));
        return node;
    }

    public INode getNode(INode node, String path) {
        List split = Strings.split((String)path, (char)'/');
        INode result = node;
        for (String string : split) {
            String trimmed = string.trim();
            if (trimmed.length() <= 0) continue;
            if ("..".equals(trimmed)) {
                if (result.getParent() == null) {
                    throw new IllegalStateException("node has no parent");
                }
                result = result.getParent();
                continue;
            }
            int index = Integer.parseInt(string);
            if (index < 0) continue;
            INode child = ((ICompositeNode)result).getFirstChild();
            while (index > 0) {
                child = child.getNextSibling();
                --index;
            }
            result = child;
        }
        return result;
    }

    public boolean isCrossLinkFragment(Resource res, String s) {
        return s != null && s.startsWith(XTEXT_LINK);
    }
}

