/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.fordiac.ide.model.commands.create.LinkConstraints;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.commands.Command;

public abstract class AbstractConnectionCreateCommand
extends Command {
    private int connDx1 = 0;
    private int connDx2 = 0;
    private int connDy = 0;
    private final FBNetwork parent;
    private Connection connection;
    private IInterfaceElement source;
    private IInterfaceElement destination;
    private boolean performMappingCheck;
    private AbstractConnectionCreateCommand mirroredConnection;

    public AbstractConnectionCreateCommand(FBNetwork parent) {
        this.parent = parent;
        this.performMappingCheck = true;
    }

    public void setArrangementConstraints(int dx1, int dx2, int dy) {
        this.connDx1 = dx1;
        this.connDx2 = dx2;
        this.connDy = dy;
    }

    public void setSource(IInterfaceElement source) {
        this.source = source;
    }

    public IInterfaceElement getSource() {
        return this.source;
    }

    public void setDestination(IInterfaceElement target) {
        this.destination = target;
    }

    public IInterfaceElement getDestination() {
        return this.destination;
    }

    protected FBNetwork getParent() {
        return this.parent;
    }

    public boolean canExecute() {
        if (this.getSource() == null || this.getDestination() == null) {
            return false;
        }
        if (this.getSource() == this.getDestination()) {
            return false;
        }
        if (!this.getInterfaceType().isInstance(this.getSource())) {
            return false;
        }
        return this.getInterfaceType().isInstance(this.getDestination());
    }

    public void execute() {
        this.checkSourceAndTarget();
        this.connection = this.createConnectionElement();
        this.connection.setSource(this.source);
        this.connection.setDestination(this.destination);
        this.connection.setDx1(this.connDx1);
        this.connection.setDx2(this.connDx2);
        this.connection.setDy(this.connDy);
        this.parent.addConnection(this.connection);
        if (this.performMappingCheck) {
            this.mirroredConnection = this.checkAndCreateMirroredConnection();
            if (this.mirroredConnection != null) {
                this.mirroredConnection.execute();
            }
        }
    }

    public void undo() {
        if (this.mirroredConnection != null) {
            this.mirroredConnection.undo();
        }
        this.connection.setSource(null);
        this.connection.setDestination(null);
        this.parent.removeConnection(this.connection);
    }

    public void redo() {
        this.connection.setSource(this.source);
        this.connection.setDestination(this.destination);
        this.parent.addConnection(this.connection);
        if (this.mirroredConnection != null) {
            this.mirroredConnection.redo();
        }
    }

    private void checkSourceAndTarget() {
        if (LinkConstraints.isSwapNeeded(this.source, this.parent)) {
            IInterfaceElement buf = this.destination;
            this.destination = this.source;
            this.source = buf;
        }
    }

    protected abstract Connection createConnectionElement();

    private AbstractConnectionCreateCommand checkAndCreateMirroredConnection() {
        if (this.source.getFBNetworkElement() != null && this.destination.getFBNetworkElement() != null) {
            FBNetworkElement opSource = this.source.getFBNetworkElement().getOpposite();
            FBNetworkElement opDestination = this.destination.getFBNetworkElement().getOpposite();
            if (opSource != null && opDestination != null && opSource.getFbNetwork() == opDestination.getFbNetwork()) {
                AbstractConnectionCreateCommand cmd = this.createMirroredConnectionCommand(opSource.getFbNetwork());
                cmd.setPerformMappingCheck(false);
                cmd.setSource(opSource.getInterfaceElement(this.source.getName()));
                cmd.setDestination(opDestination.getInterfaceElement(this.destination.getName()));
                return cmd.canExecute() ? cmd : null;
            }
        }
        return null;
    }

    protected abstract AbstractConnectionCreateCommand createMirroredConnectionCommand(FBNetwork var1);

    protected abstract Class getInterfaceType();

    private void setPerformMappingCheck(boolean performMappingCheck) {
        this.performMappingCheck = performMappingCheck;
    }
}

