/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.keys.model.BindingElement;
import org.eclipse.ui.internal.keys.model.CommonModel;
import org.eclipse.ui.internal.keys.model.ConflictModel;
import org.eclipse.ui.internal.keys.model.ContextModel;
import org.eclipse.ui.internal.keys.model.KeyController;
import org.eclipse.ui.services.IServiceLocator;

public class BindingModel
extends CommonModel {
    public static final String PROP_BINDING_ADD = "bindingAdd";
    public static final String PROP_BINDING_ELEMENT_MAP = "bindingElementMap";
    public static final String PROP_BINDING_FILTER = "bindingFilter";
    public static final String PROP_BINDING_REMOVE = "bindingRemove";
    public static final String PROP_BINDINGS = "bindings";
    public static final String PROP_CONFLICT_ELEMENT_MAP = "bindingConfictMap";
    private Collection<BindingElement> allParameterizedCommands;
    private BindingManager bindingManager;
    private HashSet<BindingElement> bindingElements;
    private Map<Binding, BindingElement> bindingToElement;
    private Map<ParameterizedCommand, BindingElement> commandToElement;

    static final boolean deletes(Binding del, Binding binding) {
        boolean deletes = true;
        deletes &= Objects.equals(del.getContextId(), binding.getContextId());
        deletes &= Objects.equals(del.getTriggerSequence(), binding.getTriggerSequence());
        if (del.getLocale() != null) {
            deletes &= Objects.equals(del.getLocale(), binding.getLocale());
        }
        if (del.getPlatform() != null) {
            deletes &= Objects.equals(del.getPlatform(), binding.getPlatform());
        }
        deletes &= binding.getType() == 0;
        return deletes &= Objects.equals(del.getParameterizedCommand(), null);
    }

    public BindingModel(KeyController kc) {
        super(kc);
    }

    public void copy() {
        BindingElement element = (BindingElement)this.getSelectedElement();
        this.copy(element);
    }

    public void copy(BindingElement element) {
        if (element == null || !(element.getModelObject() instanceof Binding)) {
            return;
        }
        BindingElement be = new BindingElement(this.controller);
        ParameterizedCommand parameterizedCommand = ((Binding)element.getModelObject()).getParameterizedCommand();
        be.init(parameterizedCommand);
        be.setParent(this);
        this.bindingElements.add(be);
        this.commandToElement.put(parameterizedCommand, be);
        this.controller.firePropertyChange(this, PROP_BINDING_ADD, null, be);
        this.setSelectedElement(be);
    }

    public HashSet<BindingElement> getBindings() {
        return this.bindingElements;
    }

    public Map<Binding, BindingElement> getBindingToElement() {
        return this.bindingToElement;
    }

    public Map<ParameterizedCommand, BindingElement> getCommandToElement() {
        return this.commandToElement;
    }

    public void init(IServiceLocator locator, BindingManager manager, ContextModel model) {
        HashSet<ParameterizedCommand> cmdsForBindings = new HashSet<ParameterizedCommand>();
        this.bindingToElement = new HashMap<Binding, BindingElement>();
        this.commandToElement = new HashMap<ParameterizedCommand, BindingElement>();
        this.bindingElements = new HashSet();
        this.bindingManager = manager;
        for (Binding b : manager.getActiveBindingsDisregardingContextFlat()) {
            BindingElement be = new BindingElement(this.controller);
            be.init(b, model);
            be.setParent(this);
            this.bindingElements.add(be);
            this.bindingToElement.put(b, be);
            cmdsForBindings.add(b.getParameterizedCommand());
        }
        ICommandService commandService = locator.getService(ICommandService.class);
        Collection commandIds = commandService.getDefinedCommandIds();
        this.allParameterizedCommands = new HashSet<BindingElement>();
        for (String string : commandIds) {
            Command currentCommand = commandService.getCommand(string);
            try {
                this.allParameterizedCommands.addAll(ParameterizedCommand.generateCombinations((Command)currentCommand));
            }
            catch (NotDefinedException notDefinedException) {}
        }
        for (ParameterizedCommand parameterizedCommand : this.allParameterizedCommands) {
            if (cmdsForBindings.contains(parameterizedCommand)) continue;
            BindingElement be = new BindingElement(this.controller);
            be.init(parameterizedCommand);
            be.setParent(this);
            this.bindingElements.add(be);
            this.commandToElement.put(parameterizedCommand, be);
        }
    }

    public void refresh(ContextModel contextModel) {
        HashSet<Object> cmdsForBindings = new HashSet<Object>();
        Collection activeManagerBindings = this.bindingManager.getActiveBindingsDisregardingContextFlat();
        for (KeyBinding keyBinding : activeManagerBindings) {
            ParameterizedCommand parameterizedCommand = keyBinding.getParameterizedCommand();
            cmdsForBindings.add(parameterizedCommand);
            if (this.bindingToElement.containsKey(keyBinding)) continue;
            BindingElement be = new BindingElement(this.controller);
            be.init((Binding)keyBinding, contextModel);
            be.setParent(this);
            this.bindingElements.add(be);
            this.bindingToElement.put((Binding)keyBinding, be);
            this.controller.firePropertyChange(this, PROP_BINDING_ADD, null, be);
            if (!this.commandToElement.containsKey(parameterizedCommand) || be.getUserDelta() != 0) continue;
            BindingElement remove = this.commandToElement.remove(parameterizedCommand);
            this.bindingElements.remove(remove);
            this.controller.firePropertyChange(this, PROP_BINDING_REMOVE, null, remove);
        }
        Iterator<Object> i = this.bindingElements.iterator();
        while (i.hasNext()) {
            BindingElement bindingElement = (BindingElement)i.next();
            Object obj = bindingElement.getModelObject();
            if (obj instanceof Binding) {
                Binding b = (Binding)obj;
                if (activeManagerBindings.contains(b)) continue;
                ParameterizedCommand cmd = b.getParameterizedCommand();
                if (cmd != null) {
                    this.commandToElement.remove(cmd);
                }
                this.bindingToElement.remove(b);
                i.remove();
                this.controller.firePropertyChange(this, PROP_BINDING_REMOVE, null, bindingElement);
                continue;
            }
            cmdsForBindings.add(obj);
        }
        for (ParameterizedCommand parameterizedCommand : this.allParameterizedCommands) {
            if (cmdsForBindings.contains(parameterizedCommand)) continue;
            BindingElement be = new BindingElement(this.controller);
            be.init(parameterizedCommand);
            be.setParent(this);
            this.bindingElements.add(be);
            this.commandToElement.put(parameterizedCommand, be);
            this.controller.firePropertyChange(this, PROP_BINDING_ADD, null, be);
        }
    }

    public void remove() {
        BindingElement element = (BindingElement)this.getSelectedElement();
        this.remove(element);
    }

    public void remove(BindingElement bindingElement) {
        if (bindingElement == null || !(bindingElement.getModelObject() instanceof Binding)) {
            return;
        }
        KeyBinding keyBinding = (KeyBinding)bindingElement.getModelObject();
        if (keyBinding.getType() == 1) {
            this.bindingManager.removeBinding((Binding)keyBinding);
        } else {
            KeySequence keySequence = keyBinding.getKeySequence();
            this.bindingManager.addBinding((Binding)new KeyBinding(keySequence, null, keyBinding.getSchemeId(), keyBinding.getContextId(), null, null, null, 1));
            ConflictModel conflictModel = this.controller.getConflictModel();
            conflictModel.updateConflictsFor(bindingElement);
            Collection<?> conflictsList = conflictModel.getConflicts();
            if (conflictsList != null) {
                Object[] conflicts;
                Object[] objectArray = conflicts = conflictsList.toArray();
                int n = conflicts.length;
                int n2 = 0;
                while (n2 < n) {
                    Binding binding;
                    Object modelObject;
                    Object conflict = objectArray[n2];
                    BindingElement be = (BindingElement)conflict;
                    if (be != bindingElement && (modelObject = be.getModelObject()) instanceof Binding && (binding = (Binding)modelObject).getType() == 0) {
                        ParameterizedCommand pCommand = binding.getParameterizedCommand();
                        be.fill(pCommand);
                        this.commandToElement.put(pCommand, be);
                    }
                    ++n2;
                }
            }
        }
        ParameterizedCommand parameterizedCommand = keyBinding.getParameterizedCommand();
        bindingElement.fill(parameterizedCommand);
        this.commandToElement.put(parameterizedCommand, bindingElement);
        this.controller.firePropertyChange(this, PROP_CONFLICT_ELEMENT_MAP, null, bindingElement);
    }

    public void restoreBinding(BindingElement element) {
        if (element == null) {
            return;
        }
        Object modelObject = element.getModelObject();
        ParameterizedCommand cmd = null;
        if (modelObject instanceof ParameterizedCommand) {
            cmd = (ParameterizedCommand)modelObject;
            TriggerSequence trigger = this.bindingManager.getBestActiveBindingFor(cmd.getId());
            Binding binding = this.bindingManager.getPerfectMatch(trigger);
            if (binding != null && binding.getType() == 0) {
                return;
            }
        } else if (modelObject instanceof KeyBinding) {
            cmd = ((KeyBinding)modelObject).getParameterizedCommand();
        }
        Binding[] managerBindings = this.bindingManager.getBindings();
        ArrayList<Binding> systemBindings = new ArrayList<Binding>();
        ArrayList<Binding> removalBindings = new ArrayList<Binding>();
        Binding[] bindingArray = managerBindings;
        int n = managerBindings.length;
        int n2 = 0;
        while (n2 < n) {
            Binding managerBinding = bindingArray[n2];
            if (managerBinding.getParameterizedCommand() == null) {
                removalBindings.add(managerBinding);
            } else if (managerBinding.getParameterizedCommand().equals((Object)cmd)) {
                if (managerBinding.getType() == 1) {
                    this.bindingManager.removeBinding(managerBinding);
                } else if (managerBinding.getType() == 0) {
                    systemBindings.add(managerBinding);
                }
            }
            ++n2;
        }
        for (Binding sys : systemBindings) {
            for (Binding del : removalBindings) {
                if (!BindingModel.deletes(del, sys) || del.getType() != 1) continue;
                this.bindingManager.removeBinding(del);
            }
        }
        this.setSelectedElement(null);
        this.bindingElements.remove(element);
        this.bindingToElement.remove(modelObject);
        this.commandToElement.remove(modelObject);
        this.controller.firePropertyChange(this, PROP_BINDING_REMOVE, null, element);
    }

    public void restoreBinding(ContextModel contextModel) {
        BindingElement element = (BindingElement)this.getSelectedElement();
        if (element == null) {
            return;
        }
        this.restoreBinding(element);
        this.refresh(contextModel);
        Object obj = element.getModelObject();
        ParameterizedCommand cmd = null;
        if (obj instanceof ParameterizedCommand) {
            cmd = (ParameterizedCommand)obj;
        } else if (obj instanceof KeyBinding) {
            cmd = ((KeyBinding)obj).getParameterizedCommand();
        }
        boolean done = false;
        Iterator<BindingElement> i = this.bindingElements.iterator();
        while (i.hasNext() && !done) {
            BindingElement be = i.next();
            obj = be.getModelObject();
            ParameterizedCommand pcmd = null;
            if (obj instanceof ParameterizedCommand) {
                pcmd = (ParameterizedCommand)obj;
            } else if (obj instanceof KeyBinding) {
                pcmd = ((KeyBinding)obj).getParameterizedCommand();
            }
            if (!cmd.equals((Object)pcmd)) continue;
            done = true;
            this.setSelectedElement(be);
        }
    }

    public void setBindings(HashSet<BindingElement> bindings) {
        HashSet<BindingElement> old = this.bindingElements;
        this.bindingElements = bindings;
        this.controller.firePropertyChange(this, PROP_BINDINGS, old, bindings);
    }

    public void setBindingToElement(Map<Binding, BindingElement> bindingToElement) {
        Map<Binding, BindingElement> old = this.bindingToElement;
        this.bindingToElement = bindingToElement;
        this.controller.firePropertyChange(this, PROP_BINDING_ELEMENT_MAP, old, bindingToElement);
    }
}

