/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.handlers;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.ui.Messages;
import org.eclipse.fordiac.ide.deployment.ui.handlers.AbstractDeviceDeploymentCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.ui.PlatformUI;

public class FullyCleanDeviceHandler
extends AbstractDeviceDeploymentCommand {
    @Override
    protected void executeCommand(IDeviceManagementInteractor executor) throws DeploymentException {
        List<String> resNames = executor.queryResources().stream().map(res -> res.getName()).collect(Collectors.toList());
        if (!resNames.isEmpty() && this.runDeleteQuestionDialog(resNames) == 0) {
            FullyCleanDeviceHandler.deleteResources(executor, resNames);
        }
    }

    @Override
    protected String getErrorMessageHeader() {
        return Messages.FullyCleanDeviceHandler_FullyCleanDeviceError;
    }

    private int runDeleteQuestionDialog(List<String> resNames) {
        StringBuilder message = new StringBuilder(MessageFormat.format(Messages.FullyCleanDeviceHandler_DeleteResourcesFromDevice, this.getDevice().getName()));
        for (String name : resNames) {
            message.append("\n\t");
            message.append(name);
        }
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.FullyCleanDeviceHandler_FullyCleanDevice, null, message.toString(), 3, new String[]{Messages.FullyCleanDeviceHandler_Delete, SWT.getMessage((String)"SWT_Cancel")}, 0);
        return dialog.open();
    }

    private static void deleteResources(IDeviceManagementInteractor executor, List<String> resNames) throws DeploymentException {
        for (String res : resNames) {
            executor.deleteResource(res);
        }
    }
}

