/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.fordiac.ide.export.IExportTemplate;
import org.eclipse.fordiac.ide.export.Messages;

public abstract class ExportTemplate
implements IExportTemplate {
    private final String name;
    private final Path path;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();
    private final List<String> infos = new ArrayList<String>();

    public ExportTemplate(String name) {
        this(name, Paths.get("", new String[0]));
    }

    public ExportTemplate(String name, Path prefix) {
        this.name = name;
        this.path = prefix.resolve(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public List<String> getInfos() {
        return this.infos;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExportTemplate)) {
            return false;
        }
        return Objects.equals(this.path, ((ExportTemplate)obj).path);
    }

    public String toString() {
        return MessageFormat.format(Messages.ExportTemplate_ExportTemplate, this.path);
    }
}

