/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.commands;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceType;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceTypeFB;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.gef.commands.Command;

public class ResourceCreateCommand
extends Command {
    private final ResourceTypeEntry entry;
    private Resource resource;
    private final Device device;
    private final boolean deviceTypeRes;
    private int index = -1;

    public ResourceCreateCommand(ResourceTypeEntry entry, Device device, boolean deviceTypeRes) {
        this.entry = entry;
        this.device = device;
        this.deviceTypeRes = deviceTypeRes;
    }

    public ResourceCreateCommand(ResourceTypeEntry entry, Device device, int index, boolean deviceTypeRes) {
        this.entry = entry;
        this.device = device;
        this.index = index;
        this.deviceTypeRes = deviceTypeRes;
    }

    public void execute() {
        this.resource = LibraryElementFactory.eINSTANCE.createResource();
        this.resource.setDeviceTypeResource(this.deviceTypeRes);
        this.resource.setPaletteEntry((PaletteEntry)this.entry);
        this.resource.getVarDeclarations().addAll(EcoreUtil.copyAll((Collection)this.entry.getResourceType().getVarDeclaration()));
        for (VarDeclaration element : this.resource.getVarDeclarations()) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            element.setValue(value);
        }
        FBNetwork resourceFBNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        if (this.entry.getResourceType().getFBNetwork() != null) {
            this.resource.setFBNetwork(resourceFBNetwork);
            this.createResourceTypeNetwork(this.resource, this.entry.getResourceType(), resourceFBNetwork);
        } else {
            this.resource.setFBNetwork(resourceFBNetwork);
        }
        if (this.index < 0 || this.index > this.device.getResource().size()) {
            this.index = this.device.getResource().size();
        }
        this.device.getResource().add(this.index, (Object)this.resource);
        this.resource.setName(NameRepository.createUniqueName((INamedElement)this.resource, (String)this.entry.getLabel()));
        SystemManager.INSTANCE.notifyListeners();
    }

    public void createResourceTypeNetwork(Resource resource, ResourceType type, FBNetwork resourceFBNetwork) {
        Event dest;
        Event source;
        FB destFB;
        FB sourceFB;
        HashMap<String, Event> events = new HashMap<String, Event>();
        HashMap<String, VarDeclaration> varDecls = new HashMap<String, VarDeclaration>();
        for (FBNetworkElement element : type.getFBNetwork().getNetworkElements()) {
            Event eventCopy;
            VarDeclaration varDeclCopy;
            ResourceTypeFB copy = LibraryElementFactory.eINSTANCE.createResourceTypeFB();
            resource.getFBNetwork().getNetworkElements().add((Object)copy);
            copy.setPaletteEntry(element.getPaletteEntry());
            copy.setName(element.getName());
            InterfaceList interfaceList = LibraryElementFactory.eINSTANCE.createInterfaceList();
            for (VarDeclaration varDecl : element.getInterface().getOutputVars()) {
                varDeclCopy = LibraryElementFactory.eINSTANCE.createVarDeclaration();
                varDeclCopy.setType(varDecl.getType());
                varDeclCopy.setName(varDecl.getName());
                varDeclCopy.setComment(varDecl.getComment());
                varDeclCopy.setIsInput(varDecl.isIsInput());
                if (varDecl.getValue() != null) {
                    varDeclCopy.setValue((Value)EcoreUtil.copy((EObject)varDecl.getValue()));
                }
                varDecls.put(String.valueOf(element.getName()) + "." + varDeclCopy.getName(), varDeclCopy);
                interfaceList.getOutputVars().add((Object)varDeclCopy);
            }
            for (VarDeclaration varDecl : element.getInterface().getInputVars()) {
                varDeclCopy = LibraryElementFactory.eINSTANCE.createVarDeclaration();
                varDeclCopy.setType(varDecl.getType());
                varDeclCopy.setName(varDecl.getName());
                varDeclCopy.setComment(varDecl.getComment());
                varDeclCopy.setIsInput(varDecl.isIsInput());
                if (varDecl.getValue() != null) {
                    varDeclCopy.setValue((Value)EcoreUtil.copy((EObject)varDecl.getValue()));
                }
                varDecls.put(String.valueOf(element.getName()) + "." + varDeclCopy.getName(), varDeclCopy);
                interfaceList.getInputVars().add((Object)varDeclCopy);
            }
            for (Event event : element.getInterface().getEventInputs()) {
                eventCopy = LibraryElementFactory.eINSTANCE.createEvent();
                eventCopy.setName(event.getName());
                eventCopy.setComment(event.getComment());
                eventCopy.setIsInput(event.isIsInput());
                events.put(String.valueOf(element.getName()) + "." + event.getName(), eventCopy);
                interfaceList.getEventInputs().add((Object)eventCopy);
            }
            for (Event event : element.getInterface().getEventOutputs()) {
                eventCopy = LibraryElementFactory.eINSTANCE.createEvent();
                eventCopy.setName(event.getName());
                eventCopy.setComment(event.getComment());
                eventCopy.setIsInput(event.isIsInput());
                events.put(String.valueOf(element.getName()) + "." + event.getName(), eventCopy);
                interfaceList.getEventOutputs().add((Object)eventCopy);
            }
            copy.setInterface(interfaceList);
            copy.setX(element.getX());
            copy.setY(element.getY());
        }
        for (EventConnection eventCon : type.getFBNetwork().getEventConnections()) {
            if (eventCon.getSource() == null || eventCon.getDestination() == null) continue;
            sourceFB = (FB)eventCon.getSource().eContainer().eContainer();
            destFB = (FB)eventCon.getDestination().eContainer().eContainer();
            source = (Event)events.get(String.valueOf(sourceFB.getName()) + "." + eventCon.getSource().getName());
            dest = (Event)events.get(String.valueOf(destFB.getName()) + "." + eventCon.getDestination().getName());
            EventConnection copyEventCon = LibraryElementFactory.eINSTANCE.createEventConnection();
            copyEventCon.setSource((IInterfaceElement)source);
            copyEventCon.setDestination((IInterfaceElement)dest);
            copyEventCon.setResTypeConnection(true);
            resourceFBNetwork.getEventConnections().add((Object)copyEventCon);
        }
        for (DataConnection dataCon : type.getFBNetwork().getDataConnections()) {
            if (dataCon.getSource() == null || dataCon.getDestination() == null) continue;
            sourceFB = (FB)dataCon.getSource().eContainer().eContainer();
            destFB = (FB)dataCon.getDestination().eContainer().eContainer();
            if (sourceFB != null) {
                source = (VarDeclaration)varDecls.get(String.valueOf(sourceFB.getName()) + "." + dataCon.getSource().getName());
                dest = (VarDeclaration)varDecls.get(String.valueOf(destFB.getName()) + "." + dataCon.getDestination().getName());
                DataConnection copyDataCon = LibraryElementFactory.eINSTANCE.createDataConnection();
                copyDataCon.setSource((IInterfaceElement)source);
                copyDataCon.setDestination((IInterfaceElement)dest);
                copyDataCon.setResTypeConnection(true);
                resourceFBNetwork.getDataConnections().add((Object)copyDataCon);
                continue;
            }
            VarDeclaration var = LibraryElementFactory.eINSTANCE.createVarDeclaration();
            var.setName(dataCon.getSource().getName());
            var.setIsInput(true);
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            value.setValue(dataCon.getDataSource().getValue().getValue());
            var.setValue(value);
            this.device.getVarDeclarations().add((Object)var);
        }
    }

    public void undo() {
        this.device.getResource().remove((Object)this.resource);
        SystemManager.INSTANCE.notifyListeners();
    }

    public void redo() {
        this.device.getResource().add(this.index, (Object)this.resource);
        SystemManager.INSTANCE.notifyListeners();
    }

    public Resource getResource() {
        return this.resource;
    }
}

