/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.commands;

import java.util.Collection;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SegmentTypePaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.util.ColorHelper;
import org.eclipse.gef.commands.Command;

public class SegmentCreateCommand
extends Command {
    private final SegmentTypePaletteEntry type;
    private final SystemConfiguration parent;
    private final Rectangle bounds;
    private Segment segment;

    public SegmentCreateCommand(SegmentTypePaletteEntry type, SystemConfiguration parent, Rectangle bounds) {
        this.type = type;
        this.parent = parent;
        this.bounds = bounds;
    }

    public boolean canExecute() {
        return this.parent != null;
    }

    public void execute() {
        this.segment = LibraryElementFactory.eINSTANCE.createSegment();
        this.segment.setColor(ColorHelper.createRandomColor());
        this.segment.setPaletteEntry((PaletteEntry)this.type);
        this.segment.getVarDeclarations().addAll(EcoreUtil.copyAll((Collection)this.type.getSegmentType().getVarDeclaration()));
        this.segment.setX(this.bounds.x);
        this.segment.setY(this.bounds.y);
        this.segment.setWidth(-1 != this.bounds.width ? this.bounds.width : 300);
        this.redo();
        this.segment.setName(NameRepository.createUniqueName((INamedElement)this.segment, (String)this.type.getSegmentType().getName()));
    }

    public void undo() {
        this.parent.getSegments().remove((Object)this.segment);
    }

    public void redo() {
        this.parent.getSegments().add((Object)this.segment);
    }
}

