/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.network.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.editparts.EditorWithInterfaceEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.network.editparts.CompositeFBNetworkLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

public class CompositeNetworkEditPart
extends EditorWithInterfaceEditPart {
    private Adapter adapter;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getModel().eAdapters().add((Object)this.getContentAdapter());
            this.getModel().eContainer().eAdapters().add((Object)this.getContentAdapter());
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModel().eAdapters().remove((Object)this.getContentAdapter());
            this.getModel().eContainer().eAdapters().remove((Object)this.getContentAdapter());
        }
    }

    public Adapter getContentAdapter() {
        if (this.adapter == null) {
            this.adapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    switch (notification.getEventType()) {
                        case 3: 
                        case 5: {
                            CompositeNetworkEditPart.this.refreshChildren();
                            break;
                        }
                        case 7: {
                            if (!(notification.getNewValue() instanceof IInterfaceElement)) break;
                            CompositeNetworkEditPart.this.refreshChildren();
                            break;
                        }
                        case 4: 
                        case 6: {
                            CompositeNetworkEditPart.this.refreshChildren();
                            break;
                        }
                    }
                }
            };
        }
        return this.adapter;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new CompositeFBNetworkLayoutEditPolicy());
    }

    protected List<?> getModelChildren() {
        ArrayList children = new ArrayList();
        if (this.getModel() != null) {
            CompositeFBType fbType = this.getFbType();
            children.addAll(fbType.getInterfaceList().getEventInputs());
            children.addAll(fbType.getInterfaceList().getEventOutputs());
            children.addAll(fbType.getInterfaceList().getInputVars());
            children.addAll(fbType.getInterfaceList().getOutputVars());
            if (fbType instanceof SubAppType) {
                children.addAll(fbType.getInterfaceList().getPlugs());
                children.addAll(fbType.getInterfaceList().getSockets());
            }
            children.addAll(super.getModelChildren());
        }
        return children;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        EditPart refEditPart = null;
        if (index < this.getChildren().size()) {
            refEditPart = (EditPart)this.getChildren().get(index);
        }
        if (childEditPart instanceof InterfaceEditPart) {
            IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
            CompositeNetworkEditPart.insertChild(this.getChildVisualContainer(childEditPart), refEditPart, child);
            child.setVisible(this.isVarVisible(childEditPart).booleanValue());
        } else {
            super.addChildVisual(childEditPart, -1);
        }
    }

    private static void insertChild(Figure container, EditPart refEditPart, IFigure child) {
        if (refEditPart != null) {
            int index = container.getChildren().indexOf(((GraphicalEditPart)refEditPart).getFigure());
            container.add(child, index);
        } else {
            container.add(child);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (childEditPart instanceof InterfaceEditPart) {
            IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
            this.getChildVisualContainer(childEditPart).remove(child);
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    private Figure getChildVisualContainer(EditPart childEditPart) {
        if (((InterfaceEditPart)childEditPart).getModel().isIsInput()) {
            if (((InterfaceEditPart)childEditPart).isEvent()) {
                return this.getLeftEventInterfaceContainer();
            }
            if (this.isVarVisible(childEditPart).booleanValue()) {
                return this.getLeftVarInterfaceContainer();
            }
            return this.getLeftInterfaceContainer();
        }
        if (((InterfaceEditPart)childEditPart).isEvent()) {
            return this.getRightEventInterfaceContainer();
        }
        if (this.isVarVisible(childEditPart).booleanValue()) {
            return this.getRightVarInterfaceContainer();
        }
        return this.getRightInterfaceContainer();
    }

    protected void reorderChild(EditPart editpart, int index) {
        IFigure childFigure = ((GraphicalEditPart)editpart).getFigure();
        LayoutManager layout = this.getContentPane().getLayoutManager();
        Object constraint = null;
        if (layout != null) {
            constraint = layout.getConstraint(childFigure);
        }
        this.removeChildVisual(editpart);
        this.addChildVisual(editpart, index);
        List children = this.getChildren();
        children.remove(editpart);
        children.add(index, editpart);
        this.setLayoutConstraint(editpart, childFigure, constraint);
    }

    protected void addChild(EditPart child, int index) {
        Assert.isNotNull((Object)child);
        if (index == -1) {
            index = this.getChildren().size();
        }
        if (this.children == null) {
            this.children = new ArrayList(2);
        }
        this.addChildVisual(child, index);
        this.children.add(index, child);
        child.setParent((EditPart)this);
        child.addNotify();
        if (this.isActive()) {
            child.activate();
        }
        this.fireChildAdded(child, index);
    }

    private CompositeFBType getFbType() {
        return (CompositeFBType)this.getModel().eContainer();
    }

    protected Boolean isVarVisible(EditPart childEditPart) {
        return !(childEditPart.getModel() instanceof AdapterDeclaration);
    }
}

