/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;

public abstract class TypeImporter
extends CommonElementImporter {
    private LibraryElement type;

    protected TypeImporter() {
    }

    protected TypeImporter(XMLStreamReader reader) {
        super(reader);
    }

    protected LibraryElement getType() {
        return this.type;
    }

    public void setType(LibraryElement type) {
        this.type = type;
    }

    public LibraryElement importType(IFile typeFile) throws TypeImportException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (CommonElementImporter.ImporterStreams streams = this.createInputStreams(typeFile.getContents());){
                this.type = this.createType();
                this.proceedToStartElementNamed(this.getStartElementName());
                this.readNameCommentAttributes(this.type);
                this.processChildren(this.getStartElementName(), this.getTypeChildrenHandler());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TypeImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TypeImportException(e.getMessage(), e);
        }
        return this.type;
    }

    protected abstract LibraryElement createType();

    protected abstract String getStartElementName();

    protected abstract CommonElementImporter.IChildHandler getTypeChildrenHandler();

    protected VarDeclaration parseVarDeclaration() throws TypeImportException, XMLStreamException {
        VarDeclaration v = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        this.readNameCommentAttributes(v);
        String typeName = this.getAttributeValue("Type");
        if (typeName != null) {
            DataType dataType = DataTypeLibrary.getInstance().getType(typeName);
            v.setTypeName(typeName);
            if (dataType != null) {
                v.setType(dataType);
            }
        } else {
            throw new TypeImportException(Messages.Import_ERROR_InputVariableTypeNotDefined);
        }
        String arraySize = this.getAttributeValue("ArraySize");
        if (arraySize != null) {
            try {
                v.setArraySize(Integer.parseInt(arraySize));
            }
            catch (NumberFormatException nfe) {
                throw new TypeImportException(Messages.Import_ERROR_ArraySize_NumberFormat, nfe);
            }
        } else {
            v.setArraySize(-1);
        }
        String initialValue = this.getAttributeValue("InitialValue");
        if (initialValue != null) {
            Value varInitialization = LibraryElementFactory.eINSTANCE.createValue();
            varInitialization.setValue(initialValue);
            v.setValue(varInitialization);
        }
        this.proceedToEndElementNamed("VarDeclaration");
        return v;
    }
}

