/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.resourceediting.editors;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceEditorInput;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.util.AbstractUntypedEditorInputFactory;
import org.eclipse.ui.IMemento;

public class ResourceEditorInputFactory
extends AbstractUntypedEditorInputFactory {
    private static final String ID_FACTORY = "org.eclipse.fordiac.ide.resourceediting.editors.ResourceEditorInputFactory";
    private static final String TAG_DEVICE = "DEVICE";
    private static final String TAG_RESORUCE = "RESOURCE";

    public IAdaptable createElement(IMemento memento) {
        Resource res;
        Device device;
        AutomationSystem system;
        String systemName = ResourceEditorInputFactory.loadAutomationSystemName((IMemento)memento);
        String deviceName = memento.getString(TAG_DEVICE);
        String resourceName = memento.getString(TAG_RESORUCE);
        if (systemName != null && deviceName != null && resourceName != null && (system = SystemManager.INSTANCE.getSystemForName(systemName)) != null && (device = system.getDeviceNamed(deviceName)) != null && (res = device.getResourceNamed(resourceName)) != null) {
            return new ResourceEditorInput(res);
        }
        return null;
    }

    public static String getFactoryId() {
        return ID_FACTORY;
    }

    public static void saveState(IMemento memento, ResourceEditorInput input) {
        if (input.getContent().getDevice() != null) {
            ResourceEditorInputFactory.saveAutomationSystem((IMemento)memento, (AutomationSystem)input.getContent().getAutomationSystem());
            memento.putString(TAG_DEVICE, input.getContent().getDevice().getName());
            memento.putString(TAG_RESORUCE, input.getContent().getName());
        }
    }
}

