/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.server.auth.AsyncAuthException;
import org.apache.sshd.server.auth.pubkey.KeySetPublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.RejectAllPublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

@FunctionalInterface
public interface PublickeyAuthenticator {
    public boolean authenticate(String var1, PublicKey var2, ServerSession var3) throws AsyncAuthException;

    public static PublickeyAuthenticator fromAuthorizedEntries(Object id, ServerSession session, Collection<? extends AuthorizedKeyEntry> entries, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        List<PublicKey> keys = PublicKeyEntry.resolvePublicKeyEntries(session, entries, fallbackResolver);
        if (GenericUtils.isEmpty(keys)) {
            return RejectAllPublickeyAuthenticator.INSTANCE;
        }
        return new KeySetPublickeyAuthenticator(id, keys);
    }
}

