/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.commands.PasteCommand;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PasteEditPartsAction
extends SelectionAction {
    private org.eclipse.swt.graphics.Point pasteRefPosition;

    public PasteEditPartsAction(IWorkbenchPart editor) {
        super(editor);
    }

    protected boolean calculateEnabled() {
        FBNetwork fbNetwork = this.getFBNetwork();
        return fbNetwork != null && !this.getClipboardContents().isEmpty();
    }

    protected Command createPasteCommand() {
        FBNetwork fbNetwork = this.getFBNetwork();
        if (fbNetwork != null) {
            return new PasteCommand(this.getClipboardContents(), fbNetwork, this.pasteRefPosition);
        }
        return new CompoundCommand();
    }

    private List getClipboardContents() {
        List list = Collections.emptyList();
        Object obj = Clipboard.getDefault().getContents();
        if (obj instanceof List) {
            list = (List)obj;
        }
        return list;
    }

    protected void init() {
        this.setId(ActionFactory.PASTE.getId());
        this.setText(Messages.PasteEditPartsAction_Text);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof FigureCanvas) {
            this.setMouseLocationAsPastePos(event);
        }
        super.runWithEvent(event);
    }

    public void setMouseLocationAsPastePos(Event event) {
        FigureCanvas figureCanvas = (FigureCanvas)event.widget;
        Point viewLocation = figureCanvas.getViewport().getViewLocation();
        org.eclipse.swt.graphics.Point mouseLocation = Display.getCurrent().getCursorLocation();
        mouseLocation = figureCanvas.toControl(mouseLocation.x, mouseLocation.y);
        if (figureCanvas.getBounds().contains(mouseLocation.x, mouseLocation.y)) {
            ZoomManager zoomManager = ((FBNetworkEditor)this.getWorkbenchPart()).getZoomManger();
            mouseLocation.x += viewLocation.x;
            mouseLocation.y += viewLocation.y;
            this.setPastRefPosition(new Point(mouseLocation.x, mouseLocation.y).scale(1.0 / zoomManager.getZoom()));
        } else {
            Dimension visibleArea = figureCanvas.getViewport().getSize();
            this.setPastRefPosition(new org.eclipse.swt.graphics.Point(viewLocation.x + visibleArea.width / 2, viewLocation.y + visibleArea.height / 2));
        }
    }

    public void run() {
        this.execute(this.createPasteCommand());
        this.pasteRefPosition = null;
    }

    protected FBNetwork getFBNetwork() {
        if (this.getWorkbenchPart() instanceof FBNetworkEditor) {
            return ((FBNetworkEditor)this.getWorkbenchPart()).getModel();
        }
        return null;
    }

    public void setPastRefPosition(org.eclipse.swt.graphics.Point pt) {
        this.pasteRefPosition = pt;
    }

    public void setPastRefPosition(Point point) {
        this.setPastRefPosition(new org.eclipse.swt.graphics.Point(point.x, point.y));
    }
}

