/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class CloseSystemActionProvider
extends CommonActionProvider {
    private CloseResourceAction closeProjectAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        IShellProvider sp = new IShellProvider(){

            public Shell getShell() {
                return CloseSystemActionProvider.this.getActionSite().getViewSite().getShell();
            }
        };
        this.closeProjectAction = new CloseResourceAction(sp);
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.closeProjectAction);
        this.updateActionBars();
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = this.getSelectedProjects();
        if (!selection.isEmpty()) {
            this.closeProjectAction.selectionChanged(selection);
            menu.appendToGroup("group.build", (IAction)this.closeProjectAction);
        }
    }

    public void updateActionBars() {
        this.closeProjectAction.selectionChanged(this.getSelectedProjects());
    }

    private IStructuredSelection getSelectedProjects() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        ArrayList<IProject> projectSelection = new ArrayList<IProject>();
        for (Object element : selection.toList()) {
            if (element instanceof AutomationSystem) {
                projectSelection.add(((AutomationSystem)element).getProject());
                continue;
            }
            if (!(element instanceof IProject)) continue;
            projectSelection.add((IProject)element);
        }
        return new StructuredSelection(projectSelection);
    }
}

