/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.I4DIACElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.Activator;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.commands.NewAppCommand;
import org.eclipse.fordiac.ide.systemmanagement.ui.wizard.NewSystemPage;
import org.eclipse.fordiac.ide.systemmanagement.util.SystemPaletteManagement;
import org.eclipse.fordiac.ide.typemanagement.preferences.TypeManagementPreferencesHelper;
import org.eclipse.fordiac.ide.util.OpenListenerManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewSystemWizard
extends Wizard
implements INewWizard {
    private NewSystemPage page;

    public NewSystemWizard() {
        this.setWindowTitle(Messages.NewSystemWizard_WizardName);
    }

    public void addPages() {
        this.page = new NewSystemPage(Messages.NewSystemWizard_WizardName);
        this.page.setTitle(Messages.NewSystemWizard_WizardName);
        this.page.setDescription(Messages.NewSystemWizard_WizardDesc);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    NewSystemWizard.this.createProject((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            return false;
        }
        return true;
    }

    private static String[] getNatureIDs() {
        return new String[]{"org.eclipse.fordiac.ide.systemmanagement.FordiacNature"};
    }

    private void createProject(IProgressMonitor monitor) {
        try {
            try {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject project = root.getProject(this.page.getProjectName());
                IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
                IPath location = this.page.getLocationPath();
                if (!Platform.getLocation().equals((Object)location)) {
                    description.setLocation(location);
                }
                description.setNatureIds(NewSystemWizard.getNatureIDs());
                project.create(description, monitor);
                project.open(monitor);
                if (this.page.importDefaultPalette()) {
                    SystemPaletteManagement.copyToolTypeLibToProject((IProject)project);
                }
                AutomationSystem system = SystemManager.INSTANCE.createAutomationSystem(project);
                TypeManagementPreferencesHelper.setupVersionInfo((LibraryElement)system);
                SystemManager.INSTANCE.addSystem(system);
                this.createInitialApplication(monitor, system);
                SystemManager.INSTANCE.saveSystem(system);
            }
            catch (CoreException e) {
                Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void createInitialApplication(IProgressMonitor monitor, AutomationSystem system) {
        NewAppCommand cmd = new NewAppCommand(system, this.page.getInitialApplicationName(), Messages.NewApplicationWizard_Comment);
        cmd.execute(monitor, null);
        Application app = cmd.getApplication();
        if (this.page.getOpenApplication() && app != null) {
            OpenListenerManager.openEditor((I4DIACElement)app);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

