/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.monitoringbase.AbstractMonitoringManager;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.deployment.monitoringbase.PortElement;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.Activator;
import org.eclipse.fordiac.ide.monitoring.SystemMonitoringData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MonitoringManager
extends AbstractMonitoringManager {
    private final Map<AutomationSystem, SystemMonitoringData> systemMonitoringData = new HashMap<AutomationSystem, SystemMonitoringData>();

    public static MonitoringManager getInstance() {
        return (MonitoringManager)AbstractMonitoringManager.getMonitoringManager();
    }

    public MonitoringBaseElement getMonitoringElement(IInterfaceElement port) {
        if (port != null) {
            for (SystemMonitoringData data : this.systemMonitoringData.values()) {
                MonitoringBaseElement element = data.getMonitoredElement(port);
                if (element == null) continue;
                return element;
            }
        }
        return null;
    }

    public void addMonitoringElement(MonitoringBaseElement element) {
        PortElement port = element.getPort();
        SystemMonitoringData data = this.getSystemMonitoringData(port.getSystem());
        data.addMonitoringElement(element);
        this.notifyAddPort(port);
        if (element instanceof MonitoringElement) {
            this.notifyWatchesAdapterPortAdded(port);
        }
    }

    public void removeMonitoringElement(MonitoringBaseElement element) {
        SystemMonitoringData data = this.getSystemMonitoringData(element.getPort().getSystem());
        data.removeMonitoringElement(element);
        if (element instanceof MonitoringElement) {
            this.notifyWatchesAdapterPortRemoved(element.getPort());
        }
        this.notifyRemovePort(element.getPort());
    }

    public boolean containsPort(IInterfaceElement interfaceElement) {
        if (interfaceElement != null) {
            return this.getMonitoringElement(interfaceElement) != null;
        }
        return false;
    }

    public Collection<MonitoringBaseElement> getElementsToMonitor() {
        ArrayList<MonitoringBaseElement> elements = new ArrayList<MonitoringBaseElement>();
        for (SystemMonitoringData data : this.systemMonitoringData.values()) {
            elements.addAll(data.getMonitoredElements());
        }
        return elements;
    }

    public void enableSystem(AutomationSystem system) {
        this.getSystemMonitoringData(system).enableSystem();
    }

    public void enableSystemSynch(AutomationSystem system, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.getSystemMonitoringData(system).enableSystemSynch(monitor);
    }

    public void disableSystem(AutomationSystem system) {
        this.getSystemMonitoringData(system).disableSystem();
    }

    public void disableSystemSynch(AutomationSystem system, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.getSystemMonitoringData(system).disableSystemSynch(monitor);
    }

    public boolean isSystemMonitored(AutomationSystem system) {
        return this.getSystemMonitoringData(system).isMonitoringForSystemEnabled();
    }

    public boolean monitoringForSystemEnabled(AutomationSystem system) {
        SystemMonitoringData data = this.getSystemMonitoringData(system);
        return data.isMonitoringForSystemEnabled();
    }

    public void triggerEvent(IInterfaceElement interfaceElement) {
        MonitoringElement monitoringElement;
        SystemMonitoringData data;
        IDeviceManagementInteractor devMgmInteractor;
        MonitoringBaseElement element = this.getMonitoringElement(interfaceElement);
        if (element instanceof MonitoringElement && (devMgmInteractor = (data = this.getSystemMonitoringData((monitoringElement = (MonitoringElement)element).getPort().getSystem())).getDevMgmInteractor(monitoringElement.getPort().getDevice())) != null) {
            try {
                devMgmInteractor.triggerEvent((MonitoringBaseElement)monitoringElement);
            }
            catch (DeploymentException e) {
                Activator.getDefault().logError("Could not trigger event for " + element.getQualifiedString(), (Exception)((Object)e));
            }
            this.notifyTriggerEvent(monitoringElement.getPort());
        }
    }

    public void writeValue(MonitoringElement element, String value) {
        AutomationSystem automationSystem = element.getPort().getSystem();
        if (automationSystem == null) {
            MonitoringManager.showSystemNotFoundErrorMsg(element);
            return;
        }
        Device device = element.getPort().getDevice();
        if (device == null) {
            MonitoringManager.showDeviceNotFounderroMsg(element);
            return;
        }
        IDeviceManagementInteractor devMgmInteractor = this.getSystemMonitoringData(automationSystem).getDevMgmInteractor(device);
        if (devMgmInteractor != null) {
            String fullName = element.getQualifiedString();
            fullName = fullName.substring(0, fullName.lastIndexOf(46));
            fullName = fullName.substring(0, fullName.lastIndexOf(46) + 1);
            FBDeploymentData data = new FBDeploymentData(fullName, element.getPort().getFb());
            try {
                devMgmInteractor.writeFBParameter(element.getPort().getResource(), value, data, (VarDeclaration)element.getPort().getInterfaceElement());
            }
            catch (DeploymentException e) {
                Activator.getDefault().logError("Could not write value to " + element.getQualifiedString(), (Exception)((Object)e));
            }
        }
    }

    public void forceValue(MonitoringElement element, String value) {
        AutomationSystem automationSystem = element.getPort().getSystem();
        if (automationSystem == null) {
            MonitoringManager.showSystemNotFoundErrorMsg(element);
            return;
        }
        Device device = element.getPort().getDevice();
        if (device == null) {
            MonitoringManager.showDeviceNotFounderroMsg(element);
            return;
        }
        element.forceValue(value);
        IDeviceManagementInteractor devMgmInteractor = this.getSystemMonitoringData(automationSystem).getDevMgmInteractor(device);
        if (devMgmInteractor != null) {
            try {
                if (element.isForce()) {
                    devMgmInteractor.forceValue((MonitoringBaseElement)element, value);
                } else {
                    devMgmInteractor.clearForce((MonitoringBaseElement)element);
                }
            }
            catch (DeploymentException e) {
                Activator.getDefault().logError("Could not force value of " + element.getQualifiedString() + "to " + value, (Exception)((Object)e));
            }
        }
    }

    public SystemMonitoringData getSystemMonitoringData(AutomationSystem system) {
        SystemMonitoringData retVal = this.systemMonitoringData.get(system);
        if (retVal == null) {
            retVal = this.createSystemMonitoringData(system);
        }
        return retVal;
    }

    private SystemMonitoringData createSystemMonitoringData(AutomationSystem system) {
        SystemMonitoringData newData = new SystemMonitoringData(system);
        this.systemMonitoringData.put(system, newData);
        return newData;
    }

    private static void showDeviceNotFounderroMsg(MonitoringElement element) {
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Device could not be found for FB port: " + element.getPort() + "."));
    }

    private static void showSystemNotFoundErrorMsg(MonitoringElement element) {
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("System could not be found for FB port: " + element.getPort() + "."));
    }
}

