/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence;

import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.gef.utilities.TemplateCreationFactory;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.jface.resource.ImageDescriptor;

public final class ServiceInterfacePaletteFactory {
    private static final String SERVICE_TRANSACTION = "ServiceTransaction";
    public static final String RIGHT_OUTPUT_PRIMITIVE = "RightOutputPrimitive";
    public static final String RIGHT_INPUT_PRIMITIVE = "RightInputPrimitive";
    public static final String LEFT_OUTPUT_PRIMITIVE = "LeftOutputPrimitive";
    public static final String LEFT_INPUT_PRIMITIVE = "LeftInputPrimitive";
    private static final String PALETTE_DOCK_LOCATION = "ServiceInterfacePaletteFactory.Location";
    private static final String PALETTE_SIZE = "ServiceInterfacePaletteFactory.Size";
    private static final String PALETTE_STATE = "ServiceInterfacePaletteFactory.State";

    public static FlyoutPaletteComposite.FlyoutPreferences createPalettePreferences() {
        return new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return Activator.getDefault().getPreferenceStore().getInt(ServiceInterfacePaletteFactory.PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                return Activator.getDefault().getPreferenceStore().getInt(ServiceInterfacePaletteFactory.PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return Activator.getDefault().getPreferenceStore().getInt(ServiceInterfacePaletteFactory.PALETTE_SIZE);
            }

            public void setDockLocation(int location) {
                Activator.getDefault().getPreferenceStore().setValue(ServiceInterfacePaletteFactory.PALETTE_DOCK_LOCATION, location);
            }

            public void setPaletteState(int state) {
                Activator.getDefault().getPreferenceStore().setValue(ServiceInterfacePaletteFactory.PALETTE_STATE, state);
            }

            public void setPaletteWidth(int width) {
                Activator.getDefault().getPreferenceStore().setValue(ServiceInterfacePaletteFactory.PALETTE_SIZE, width);
            }
        };
    }

    public static PaletteRoot createPalette() {
        PaletteRoot palette = new PaletteRoot();
        ServiceInterfacePaletteFactory.fillPalette(palette);
        return palette;
    }

    private static void fillPalette(PaletteRoot palette) {
        PaletteDrawer drawer = new PaletteDrawer(Messages.ServiceInterfacePaletteFactory_LeftInterface);
        ImageDescriptor desc = FordiacImage.ICON_LEFT_INPUT_PRIMITIVE.getImageDescriptor();
        CombinedTemplateCreationEntry entry = new CombinedTemplateCreationEntry(Messages.ServiceInterfacePaletteFactory_InputPrimitive, Messages.ServiceInterfacePaletteFactory_InputPrimitive_Desc, (CreationFactory)new TemplateCreationFactory((Object)LEFT_INPUT_PRIMITIVE), desc, desc);
        drawer.add((PaletteEntry)entry);
        desc = FordiacImage.ICON_LEFT_OUTPUT_PRIMITIVE.getImageDescriptor();
        CombinedTemplateCreationEntry entry2 = new CombinedTemplateCreationEntry(Messages.ServiceInterfacePaletteFactory_OutputPrimitive, Messages.ServiceInterfacePaletteFactory_OutputPrimitive_Desc, (CreationFactory)new TemplateCreationFactory((Object)LEFT_OUTPUT_PRIMITIVE), desc, desc);
        drawer.add((PaletteEntry)entry2);
        palette.add((PaletteEntry)drawer);
        drawer = new PaletteDrawer(Messages.ServiceInterfacePaletteFactory_RightInterface);
        desc = FordiacImage.ICON_RIGHT_INPUT_PRIMITIVE.getImageDescriptor();
        CombinedTemplateCreationEntry entry3 = new CombinedTemplateCreationEntry(Messages.ServiceInterfacePaletteFactory_InputPrimitive, Messages.ServiceInterfacePaletteFactory_InputPrimitive_Desc, (CreationFactory)new TemplateCreationFactory((Object)RIGHT_INPUT_PRIMITIVE), desc, desc);
        drawer.add((PaletteEntry)entry3);
        desc = FordiacImage.ICON_RIGHT_OUTPUT_PRIMITIVE.getImageDescriptor();
        CombinedTemplateCreationEntry entry4 = new CombinedTemplateCreationEntry(Messages.ServiceInterfacePaletteFactory_OutputPrimitive, Messages.ServiceInterfacePaletteFactory_OutputPrimitive_Desc, (CreationFactory)new TemplateCreationFactory((Object)RIGHT_OUTPUT_PRIMITIVE), desc, desc);
        drawer.add((PaletteEntry)entry4);
        palette.add((PaletteEntry)drawer);
        drawer = new PaletteDrawer(Messages.ServiceInterfacePaletteFactory_ServiceTransaction);
        desc = FordiacImage.ICON_TRANSACTION.getImageDescriptor();
        CombinedTemplateCreationEntry entry5 = new CombinedTemplateCreationEntry(Messages.ServiceInterfacePaletteFactory_ServiceTransaction, Messages.ServiceInterfacePaletteFactory_ServiceTransaction_Desc, (CreationFactory)new TemplateCreationFactory((Object)SERVICE_TRANSACTION), desc, desc);
        drawer.add((PaletteEntry)entry5);
        palette.add((PaletteEntry)drawer);
    }

    private ServiceInterfacePaletteFactory() {
        throw new UnsupportedOperationException("ServiceInterfacePaletteFactory utility class should not be instantiated!");
    }
}

