/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import java.lang.reflect.Constructor;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ValueEditPart;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;

public class ComboDirectEditManager
extends DirectEditManager {
    private final Label label;
    private Font scaledFont;
    private List<String> comboData;
    private int selectedItem = -1;
    private final Class editorType;

    public ComboDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator, Label label) {
        super(source, editorType, locator);
        this.label = label;
        this.editorType = editorType;
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        try {
            Constructor constructor = this.editorType.getConstructor(Composite.class, String[].class);
            return (CellEditor)constructor.newInstance(composite, new String[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void show() {
        super.show();
        this.getComboBox().setListVisible(true);
    }

    public void show(char initialChar) {
        this.show();
        this.setDirty(true);
        this.getLocator().relocate(this.getCellEditor());
        this.getComboBox().setListVisible(true);
    }

    protected void bringDown() {
        if (this.getEditPart() instanceof ValueEditPart) {
            ((ValueEditPart)this.getEditPart()).refreshValue();
        }
        if (this.getEditPart() instanceof AbstractViewEditPart) {
            ((AbstractViewEditPart)this.getEditPart()).refreshName();
        }
        Font disposeFont = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
    }

    protected void initCellEditor() {
        CCombo combo = this.getComboBox();
        combo.setEditable(false);
        combo.addModifyListener(e -> this.setDirty(true));
        ComboBoxWidgetFactory.configureTypeaheadHandling((CCombo)combo);
        if (this.comboData != null) {
            this.updateComboData(this.comboData);
            this.setSelectedItem(this.selectedItem);
        }
        IFigure figure = this.getEditPart().getFigure();
        this.scaledFont = figure.getFont();
        FontData data = this.scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        this.label.translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        this.scaledFont = new Font(null, data);
        combo.setFont(this.scaledFont);
    }

    public void updateComboData(List<String> comboData) {
        this.comboData = comboData;
        CCombo combo = this.getComboBox();
        if (combo != null && !combo.isDisposed()) {
            combo.removeAll();
            for (String string : comboData) {
                combo.add(string);
            }
        }
    }

    public void setSelectedItem(int newVal) {
        this.selectedItem = newVal;
        CCombo combo = this.getComboBox();
        if (combo != null && !combo.isDisposed()) {
            combo.select(newVal);
        }
    }

    public CCombo getComboBox() {
        if (this.getCellEditor() != null && this.getCellEditor().getControl() instanceof CCombo) {
            return (CCombo)this.getCellEditor().getControl();
        }
        return null;
    }
}

