/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.onlineedit.handlers;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.deployment.data.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.ui.handlers.AbstractDeploymentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.gef.ConnectionEditPart;

public class OnlineCreateConnectionHandler
extends AbstractDeploymentCommand {
    private Connection conn = null;
    private Resource res = null;

    protected boolean prepareParametersToExecute(Object element) {
        if (element instanceof ConnectionEditPart) {
            this.conn = (Connection)((ConnectionEditPart)element).getModel();
            Connection resCon = OnlineCreateConnectionHandler.getResourceConnection(this.conn);
            if (resCon != null) {
                this.res = (Resource)resCon.getFBNetwork().eContainer();
                if (this.res != null) {
                    this.setDevice(this.res.getDevice());
                    return this.getDevice() != null;
                }
            }
        }
        return false;
    }

    protected void executeCommand(IDeviceManagementInteractor executor) throws DeploymentException {
        executor.createConnection(this.res, new ConnectionDeploymentData("", this.conn.getSource(), "", this.conn.getDestination()));
    }

    private static Connection getResourceConnection(Connection conn) {
        if (conn.getFBNetwork().eContainer() instanceof Resource) {
            return conn;
        }
        FBNetworkElement oppositeSource = conn.getSourceElement().getOpposite();
        if (oppositeSource != null) {
            EList conns = oppositeSource.getInterfaceElement(conn.getSource().getName()).getOutputConnections();
            for (Connection connection : conns) {
                if (!connection.getDestination().getName().equals(conn.getDestination().getName())) continue;
                return connection;
            }
        }
        return null;
    }

    protected String getErrorMessageHeader() {
        return "Create Connection Error";
    }

    protected String getCurrentElementName() {
        return "Connection: " + this.conn.getName();
    }
}

