/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.libraryElement.ColorizableElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Identification;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;

abstract class CommonElementExporter {
    public static final String LINE_END = "\n";
    public static final String TAB = "\t";
    private final XMLStreamWriter writer;
    private ByteBufferOutputStream outputStream;
    private int tabCount = 0;

    protected CommonElementExporter() {
        this.writer = this.createEventWriter();
    }

    protected CommonElementExporter(CommonElementExporter parent) {
        this.writer = parent.writer;
        this.tabCount = parent.tabCount;
    }

    protected XMLStreamWriter getWriter() {
        return this.writer;
    }

    protected void addStartElement(String name) throws XMLStreamException {
        this.addTabs();
        this.writer.writeStartElement(name);
        ++this.tabCount;
    }

    protected void addEmptyStartElement(String name) throws XMLStreamException {
        this.addTabs();
        this.writer.writeEmptyElement(name);
    }

    private void addTabs() throws XMLStreamException {
        this.writer.writeCharacters(LINE_END);
        int i = 0;
        while (i < this.tabCount) {
            this.writer.writeCharacters(TAB);
            ++i;
        }
    }

    protected void addEndElement() throws XMLStreamException {
        --this.tabCount;
        this.addTabs();
        this.writer.writeEndElement();
    }

    protected void addInlineEndElement() throws XMLStreamException {
        --this.tabCount;
        this.writer.writeEndElement();
    }

    private XMLStreamWriter createEventWriter() {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        this.outputStream = new ByteBufferOutputStream();
        try {
            XMLStreamWriter newWriter = outputFactory.createXMLStreamWriter(this.outputStream, StandardCharsets.UTF_8.name());
            newWriter.writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
            return newWriter;
        }
        catch (XMLStreamException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return null;
        }
    }

    protected void addColorAttributeElement(ColorizableElement colElement) throws XMLStreamException {
        String colorValue = String.valueOf(colElement.getColor().getRed()) + "," + colElement.getColor().getGreen() + "," + colElement.getColor().getBlue();
        this.addAttributeElement("Color", "STRING", colorValue, "color");
    }

    protected void addAttributeElement(String name, String type, String value, String comment) throws XMLStreamException {
        this.addEmptyStartElement("Attribute");
        this.getWriter().writeAttribute("Name", name);
        this.getWriter().writeAttribute("Type", type);
        this.getWriter().writeAttribute("Value", value);
        this.getWriter().writeAttribute("Comment", comment);
    }

    protected void createNamedElementEntry(INamedElement namedElement, String elemName) throws XMLStreamException {
        this.addStartElement(elemName);
        this.addNameAndCommentAttribute(namedElement);
    }

    protected void writeToFile(IFile iFile) {
        long startTime = System.currentTimeMillis();
        try {
            this.writer.writeCharacters(LINE_END);
            this.writer.writeEndDocument();
            this.writer.close();
            ByteBufferInputStream inputStream = new ByteBufferInputStream(this.outputStream.getDataBuffers());
            if (iFile.exists()) {
                iFile.setContents((InputStream)inputStream, 3, null);
            } else {
                CommonElementExporter.checkAndCreateFolderHierarchy(iFile);
                iFile.create((InputStream)inputStream, 3, null);
            }
        }
        catch (XMLStreamException | CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)e);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Saving time for System: " + (endTime - startTime) + " ms");
    }

    private static void checkAndCreateFolderHierarchy(IFile file) throws CoreException {
        IFolder folder;
        IPath path = file.getProjectRelativePath().removeLastSegments(1);
        if (!path.isEmpty() && !(folder = file.getProject().getFolder(path)).exists()) {
            folder.create(true, true, null);
            folder.refreshLocal(0, null);
        }
    }

    protected void addIdentification(LibraryElement libraryelement) throws XMLStreamException {
        if (libraryelement.getIdentification() != null) {
            this.addStartElement("Identification");
            Identification ident = libraryelement.getIdentification();
            if (ident.getStandard() != null && !ident.getStandard().equals("")) {
                this.writer.writeAttribute("Standard", ident.getStandard());
            }
            if (ident.getClassification() != null && !ident.getClassification().equals("")) {
                this.writer.writeAttribute("Classification", ident.getClassification());
            }
            if (ident.getApplicationDomain() != null && !ident.getApplicationDomain().equals("")) {
                this.writer.writeAttribute("ApplicationDomain", ident.getApplicationDomain());
            }
            if (ident.getFunction() != null && !ident.getFunction().equals("")) {
                this.writer.writeAttribute("Function", ident.getFunction());
            }
            if (ident.getType() != null && !ident.getType().equals("")) {
                this.writer.writeAttribute("Type", ident.getType());
            }
            if (ident.getDescription() != null && !ident.getDescription().equals("")) {
                this.writeAttributeRaw("Description", CommonElementExporter.fullyEscapeValue(ident.getDescription()));
            }
            this.addEndElement();
        }
    }

    public void addVersionInfo(LibraryElement libraryelement) throws XMLStreamException {
        if (!libraryelement.getVersionInfo().isEmpty()) {
            for (VersionInfo info : libraryelement.getVersionInfo()) {
                this.addStartElement("VersionInfo");
                if (info.getOrganization() != null && !info.getOrganization().equals("")) {
                    this.writer.writeAttribute("Organization", info.getOrganization());
                }
                if (info.getVersion() != null && !info.getVersion().equals("")) {
                    this.writer.writeAttribute("Version", info.getVersion());
                }
                if (info.getAuthor() != null && !info.getAuthor().equals("")) {
                    this.writer.writeAttribute("Author", info.getAuthor());
                }
                if (info.getDate() != null && !info.getDate().equals("")) {
                    this.writer.writeAttribute("Date", info.getDate());
                }
                if (info.getRemarks() != null && !info.getRemarks().equals("")) {
                    this.writer.writeAttribute("Remarks", info.getRemarks());
                }
                this.addEndElement();
            }
        }
    }

    protected void addCommentAttribute(INamedElement namedElement) throws XMLStreamException {
        if (namedElement.getComment() != null) {
            this.writer.writeAttribute("Comment", namedElement.getComment());
        }
    }

    protected void addNameAndCommentAttribute(INamedElement namedElement) throws XMLStreamException {
        this.addNameAttribute(namedElement.getName());
        this.addCommentAttribute(namedElement);
    }

    protected void addNameTypeCommentAttribute(INamedElement namedElement, INamedElement type) throws XMLStreamException {
        this.addNameAttribute(namedElement.getName());
        this.addTypeAttribute(type);
        this.addCommentAttribute(namedElement);
    }

    protected void writeAttributeRaw(String attributeName, String attributeValue) throws XMLStreamException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)this.outputStream, StandardCharsets.UTF_8);){
                osWriter.write(" ");
                osWriter.write(attributeName);
                osWriter.write("=\"");
                osWriter.write(attributeValue);
                osWriter.write("\" ");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new XMLStreamException("Could not write raw attribute", e);
        }
    }

    protected static String fullyEscapeValue(String value) {
        String escapedValue = value.replace("&", "&amp;");
        escapedValue = escapedValue.replace("<", "&lt;");
        escapedValue = escapedValue.replace(">", "&gt;");
        escapedValue = escapedValue.replace("\"", "&quot;");
        escapedValue = escapedValue.replace("'", "&apos;");
        escapedValue = escapedValue.replace(LINE_END, "&#10;");
        escapedValue = escapedValue.replace(TAB, "&#9;");
        return escapedValue;
    }

    protected void addTypeAttribute(INamedElement type) throws XMLStreamException {
        this.addTypeAttribute(type != null && type.getName() != null ? type.getName() : "");
    }

    protected void addTypeAttribute(String type) throws XMLStreamException {
        this.writer.writeAttribute("Type", type != null ? type : "");
    }

    protected void addNameAttribute(String name) throws XMLStreamException {
        this.writer.writeAttribute("Name", name != null ? name : "");
    }

    protected void addParamsConfig(EList<VarDeclaration> inputVars) throws XMLStreamException {
        for (VarDeclaration var : inputVars) {
            if (var.getValue() == null || var.getValue().getValue() == null || var.getValue().getValue().equals("")) continue;
            this.addEmptyStartElement("Parameter");
            this.addNameAttribute(var.getName());
            this.writer.writeAttribute("Value", var.getValue().getValue());
        }
    }

    protected void addXYAttributes(PositionableElement fb) throws XMLStreamException {
        this.addXYAttributes(fb.getX(), fb.getY());
    }

    protected void addXYAttributes(int x, int y) throws XMLStreamException {
        this.writer.writeAttribute("x", CoordinateConverter.INSTANCE.convertTo1499XML(x));
        this.writer.writeAttribute("y", CoordinateConverter.INSTANCE.convertTo1499XML(y));
    }

    private static class ByteBufferInputStream
    extends InputStream {
        private final Iterator<ByteBuffer> bufferIterator;
        private ByteBuffer currentDataBuffer;

        public ByteBufferInputStream(List<ByteBuffer> dataBuffers) {
            dataBuffers.forEach(Buffer::flip);
            this.bufferIterator = dataBuffers.iterator();
            this.currentDataBuffer = this.bufferIterator.next();
        }

        @Override
        public int read() throws IOException {
            if (this.currentDataBuffer.hasRemaining()) {
                return this.currentDataBuffer.get() & 0xFF;
            }
            if (this.bufferIterator.hasNext()) {
                this.currentDataBuffer = this.bufferIterator.next();
                return this.currentDataBuffer.get() & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.currentDataBuffer.hasRemaining()) {
                return super.read(b);
            }
            if (this.bufferIterator.hasNext()) {
                this.currentDataBuffer = this.bufferIterator.next();
                return super.read(b);
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int readLen = Math.min(this.available(), len);
            this.currentDataBuffer.get(b, off, readLen);
            return readLen;
        }

        @Override
        public int available() throws IOException {
            return this.currentDataBuffer.remaining();
        }
    }

    private static class ByteBufferOutputStream
    extends OutputStream {
        private static final int SINGLE_DATA_BUFFER_CAPACITY = 524288000;
        private final List<ByteBuffer> dataBuffers = new ArrayList<ByteBuffer>(5);
        private ByteBuffer currentDataBuffer;

        public ByteBufferOutputStream() {
            this.addNewDataBuffer();
        }

        public List<ByteBuffer> getDataBuffers() {
            return this.dataBuffers;
        }

        private void addNewDataBuffer() {
            this.currentDataBuffer = ByteBuffer.allocateDirect(524288000);
            this.dataBuffers.add(this.currentDataBuffer);
        }

        @Override
        public void write(int arg0) throws IOException {
            if (!this.currentDataBuffer.hasRemaining()) {
                this.addNewDataBuffer();
            }
            this.currentDataBuffer.put((byte)arg0);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.currentDataBuffer.remaining() < len) {
                this.addNewDataBuffer();
            }
            this.currentDataBuffer.put(b, off, len);
        }
    }
}

