/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataexport.SubApplicationTypeExporter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceType;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceTypeFB;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;

class FBNetworkExporter
extends CommonElementExporter {
    FBNetworkExporter(CommonElementExporter parent) {
        super(parent);
    }

    void createFBNetworkElement(FBNetwork fbNetwork) throws XMLStreamException {
        this.addStartElement(FBNetworkExporter.getMainElementName(fbNetwork));
        this.addFBNetworkElements(fbNetwork);
        this.addConnections((List<? extends Connection>)fbNetwork.getEventConnections(), "EventConnections", fbNetwork);
        this.addConnections((List<? extends Connection>)fbNetwork.getDataConnections(), "DataConnections", fbNetwork);
        this.addConnections((List<? extends Connection>)fbNetwork.getAdapterConnections(), "AdapterConnections", fbNetwork);
        this.addEndElement();
    }

    private static String getMainElementName(FBNetwork fbNetwork) {
        String elementName = "SubAppNetwork";
        if (fbNetwork.eContainer() instanceof FBType && !(fbNetwork.eContainer() instanceof SubAppType) || fbNetwork.eContainer() instanceof Resource || fbNetwork.eContainer() instanceof ResourceType) {
            elementName = "FBNetwork";
        }
        return elementName;
    }

    private void addFBNetworkElements(FBNetwork network) throws XMLStreamException {
        for (FBNetworkElement fbnElement : network.getNetworkElements()) {
            String nodeName = FBNetworkExporter.getFBNElementNodeName(fbnElement);
            if (nodeName == null) continue;
            this.addStartElement(nodeName);
            this.addNameAttribute(fbnElement.getName());
            if (fbnElement.getType() != null) {
                this.addTypeAttribute(fbnElement.getType());
            }
            this.addCommentAttribute(fbnElement);
            this.addXYAttributes(fbnElement);
            if (fbnElement instanceof SubApp && ((SubApp)fbnElement).getType() == null) {
                this.createUntypedSubAppcontents((SubApp)fbnElement);
            }
            this.addParamsConfig(fbnElement.getInterface().getInputVars());
            this.addEndElement();
        }
    }

    private static String getFBNElementNodeName(FBNetworkElement fbnElement) {
        if (!(fbnElement.getType() instanceof AdapterFBType)) {
            if (fbnElement instanceof FB && !(fbnElement instanceof ResourceTypeFB)) {
                return "FB";
            }
            if (fbnElement instanceof SubApp) {
                return "SubApp";
            }
        }
        return null;
    }

    private void createUntypedSubAppcontents(SubApp element) throws XMLStreamException {
        new SubApplicationTypeExporter(this).addInterfaceList(element.getInterface());
        if (element.getSubAppNetwork() != null) {
            new FBNetworkExporter(this).createFBNetworkElement(element.getSubAppNetwork());
        }
    }

    private void addConnections(List<? extends Connection> connections, String connectionElementName, FBNetwork fbNetwork) throws XMLStreamException {
        if (!connections.isEmpty()) {
            this.addStartElement(connectionElementName);
            for (Connection connection : connections) {
                this.addConnection(connection, fbNetwork);
            }
            this.addEndElement();
        }
    }

    private void addConnection(Connection connection, FBNetwork fbNetwork) throws XMLStreamException {
        this.addEmptyStartElement("Connection");
        if (connection.getSource() != null && connection.getSource().eContainer() instanceof InterfaceList) {
            this.getWriter().writeAttribute("Source", FBNetworkExporter.getConnectionEndpointIdentifier(connection.getSource(), fbNetwork));
        }
        if (connection.getDestination() != null && connection.getDestination().eContainer() instanceof InterfaceList) {
            this.getWriter().writeAttribute("Destination", FBNetworkExporter.getConnectionEndpointIdentifier(connection.getDestination(), fbNetwork));
        }
        this.addCommentAttribute(connection);
        this.addConnectionCoordinates(connection);
    }

    private static String getConnectionEndpointIdentifier(IInterfaceElement interfaceElement, FBNetwork fbNetwork) {
        String retVal = "";
        if (interfaceElement.getFBNetworkElement() != null && interfaceElement.getFBNetworkElement().getFbNetwork() == fbNetwork) {
            retVal = String.valueOf(interfaceElement.getFBNetworkElement().getName()) + ".";
        }
        retVal = String.valueOf(retVal) + interfaceElement.getName();
        return retVal;
    }

    private void addConnectionCoordinates(Connection connection) throws XMLStreamException {
        if (connection.getDx1() != 0) {
            this.getWriter().writeAttribute("dx1", CoordinateConverter.INSTANCE.convertTo1499XML(connection.getDx1()));
            if (connection.getDx2() != 0) {
                this.getWriter().writeAttribute("dx2", CoordinateConverter.INSTANCE.convertTo1499XML(connection.getDx2()));
                this.getWriter().writeAttribute("dy", CoordinateConverter.INSTANCE.convertTo1499XML(connection.getDy()));
            }
        }
    }
}

