/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.data.BaseType1;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ResDevFBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.TypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.DeviceType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DEVImporter
extends TypeImporter {
    private final Palette palette;

    public DEVImporter(Palette palette) {
        this.palette = palette;
    }

    @Override
    protected DeviceType getType() {
        return (DeviceType)super.getType();
    }

    @Override
    protected LibraryElement createType() {
        return LibraryElementFactory.eINSTANCE.createDeviceType();
    }

    @Override
    protected String getStartElementName() {
        return "DeviceType";
    }

    @Override
    protected CommonElementImporter.IChildHandler getTypeChildrenHandler() {
        return name -> {
            switch (name) {
                case "Identification": {
                    this.parseIdentification(this.getType());
                    break;
                }
                case "VersionInfo": {
                    this.parseVersionInfo(this.getType());
                    break;
                }
                case "CompilerInfo": {
                    this.parseCompilerInfo(this.getType());
                    break;
                }
                case "VarDeclaration": {
                    VarDeclaration v = this.parseVarDeclaration();
                    v.setIsInput(true);
                    this.getType().getVarDeclaration().add((Object)v);
                    break;
                }
                case "Resource": {
                    this.getType().getResource().add((Object)this.parseResource());
                    break;
                }
                case "FBNetwork": {
                    this.getType().setFBNetwork(new ResDevFBNetworkImporter(this.palette, this.getType().getVarDeclaration(), this.getReader()).parseFBNetwork("FBNetwork"));
                    break;
                }
                case "Attribute": {
                    this.parseDeviceTypeAttribute();
                    break;
                }
                case "AttributeDeclaration": {
                    this.parseDeviceTypeAttributeDeclaration();
                    break;
                }
                default: {
                    return false;
                }
                case "ResourceTypeName": 
            }
            return true;
        };
    }

    private Resource parseResource() throws TypeImportException, XMLStreamException {
        String y;
        Resource res = LibraryElementFactory.eINSTANCE.createResource();
        this.readNameCommentAttributes(res);
        String resType = this.getAttributeValue("Type");
        if (resType == null) {
            throw new TypeImportException(Messages.DEVImporter_ERROR_ResourceTypeHasToBeSet);
        }
        res.setPaletteEntry(this.palette.getResourceTypeEntry(resType));
        String x = this.getAttributeValue("x");
        if (x != null) {
            res.setX(x);
        }
        if ((y = this.getAttributeValue("y")) != null) {
            res.setY(y);
        }
        this.processChildren("Device", name -> {
            switch (name) {
                case "Parameter": {
                    res.getVarDeclarations().add((Object)this.parseParameter());
                    break;
                }
                case "FBNetwork": {
                    res.setFBNetwork(new ResDevFBNetworkImporter(this.palette, (EList<VarDeclaration>)res.getVarDeclarations(), this.getReader()).parseFBNetwork("FBNetwork"));
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        return res;
    }

    public static List<String> getReferencedTypes(File file) {
        ArrayList<String> references = new ArrayList<String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(file);
            Element rootNode = document.getDocumentElement();
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeName().equals("Resource")) {
                    String type = "";
                    type = n.getAttributes().getNamedItem("Type").getNodeValue();
                    references.add(type);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return references;
    }

    private void parseDeviceTypeAttributeDeclaration() {
        AttributeDeclaration attributeDeclaration = LibraryElementFactory.eINSTANCE.createAttributeDeclaration();
        attributeDeclaration.setName(this.getAttributeValue("Name"));
        attributeDeclaration.setComment(this.getAttributeValue("Comment"));
        attributeDeclaration.setInitialValue(this.getAttributeValue("InitialValue"));
        attributeDeclaration.setType(BaseType1.getByName(this.getAttributeValue("Type")));
        this.getType().getAttributeDeclarations().add((Object)attributeDeclaration);
    }

    private void parseDeviceTypeAttribute() {
        if (this.isProfileAttribute()) {
            this.parseProfile();
        }
    }

    private void parseProfile() {
        String value = this.getAttributeValue("Value");
        if (value != null) {
            this.getType().setProfile(value);
        }
    }
}

