/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.Palette.DeviceTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ResDevFBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.ColorizableElement;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.IVarElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceType;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceTypeFB;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class SystemImporter
extends CommonElementImporter {
    private final AutomationSystem system;

    private Palette getPalette() {
        return this.system.getPalette();
    }

    public SystemImporter(AutomationSystem system) {
        this.system = system;
    }

    public void importSystem(InputStream systemStream) throws TypeImportException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (CommonElementImporter.ImporterStreams streams = this.createInputStreams(systemStream);){
                this.proceedToStartElementNamed("System");
                this.readNameCommentAttributes(this.system);
                this.parseSystemContent();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TypeImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TypeImportException(e.getMessage(), e);
        }
    }

    private void parseSystemContent() throws XMLStreamException, TypeImportException {
        SystemConfiguration sysConf = this.system.getSystemConfiguration();
        this.processChildren("System", name -> {
            switch (name) {
                case "VersionInfo": {
                    this.parseVersionInfo(this.system);
                    break;
                }
                case "Identification": {
                    this.parseIdentification(this.system);
                    break;
                }
                case "Application": {
                    this.system.getApplication().add((Object)this.parseApplication());
                    break;
                }
                case "Device": {
                    sysConf.getDevices().add((Object)this.parseDevice());
                    break;
                }
                case "Mapping": {
                    this.parseMapping();
                    break;
                }
                case "Segment": {
                    sysConf.getSegments().add((Object)this.parseSegment());
                    break;
                }
                case "Link": {
                    this.parseLink(sysConf);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
    }

    private Segment parseSegment() throws TypeImportException, XMLStreamException {
        String type;
        Segment segment = LibraryElementFactory.eINSTANCE.createSegment();
        this.readNameCommentAttributes(segment);
        this.getXandY(segment);
        String dx1 = this.getAttributeValue("dx1");
        if (dx1 != null) {
            segment.setWidth(CoordinateConverter.INSTANCE.convertFrom1499XML(dx1));
        }
        if ((type = this.getAttributeValue("Type")) != null) {
            segment.setPaletteEntry(this.getPalette().getSegmentTypeEntry(type));
        }
        this.parseSegmentNodeChildren(segment);
        return segment;
    }

    private void parseSegmentNodeChildren(Segment segment) throws XMLStreamException, TypeImportException {
        this.processChildren("Segment", name -> {
            if ("Attribute".equals(name)) {
                if (this.isColorAttributeNode()) {
                    this.parseColor(segment);
                } else {
                    this.parseGenericAttributeNode(segment);
                }
                this.proceedToEndElementNamed("Attribute");
                return true;
            }
            return false;
        });
    }

    private void parseLink(SystemConfiguration sysConf) throws XMLStreamException {
        String commResource = this.getAttributeValue("CommResource");
        String comment = this.getAttributeValue("Comment");
        String segmentName = this.getAttributeValue("SegmentName");
        Segment segment = sysConf.getSegmentNamed(segmentName);
        Device device = sysConf.getDeviceNamed(commResource);
        if (segment != null && device != null) {
            Link link = LibraryElementFactory.eINSTANCE.createLink();
            link.setComment(comment);
            segment.getOutConnections().add((Object)link);
            device.getInConnections().add((Object)link);
            sysConf.getLinks().add((Object)link);
        }
        this.proceedToEndElementNamed("Link");
    }

    private Device parseDevice() throws TypeImportException, XMLStreamException {
        Device device = LibraryElementFactory.eINSTANCE.createDevice();
        this.parseCommon(device);
        this.parseDeviceType(device);
        this.parseDeviceNodeChildren(device);
        return device;
    }

    private void parseCommon(IVarElement element) throws TypeImportException {
        this.readNameCommentAttributes((INamedElement)((Object)element));
        if (element instanceof PositionableElement) {
            this.getXandY((PositionableElement)((Object)element));
        }
    }

    private void parseDeviceType(Device device) {
        DeviceTypePaletteEntry entry;
        String typeName = this.getAttributeValue("Type");
        if (typeName != null && (entry = this.getPalette().getDeviceTypeEntry(typeName)) != null) {
            device.setPaletteEntry(entry);
            SystemImporter.createParamters(device);
        }
    }

    private void parseMapping() throws XMLStreamException {
        String fromValue = this.getAttributeValue("From");
        String toValue = this.getAttributeValue("To");
        FBNetworkElement fromElement = this.findMappingTargetFromName(fromValue);
        FBNetworkElement toElement = this.findMappingTargetFromName(toValue);
        if (fromElement != null && toElement != null) {
            this.system.getMapping().add((Object)SystemImporter.createMappingEntry(toElement, fromElement));
        }
        this.proceedToEndElementNamed("Mapping");
    }

    private static Mapping createMappingEntry(FBNetworkElement toElement, FBNetworkElement fromElement) {
        Mapping mapping = LibraryElementFactory.eINSTANCE.createMapping();
        mapping.setFrom(fromElement);
        mapping.setTo(toElement);
        toElement.setMapping(mapping);
        fromElement.setMapping(mapping);
        return mapping;
    }

    private FBNetworkElement findMappingTargetFromName(String targetName) {
        ArrayDeque<String> parts;
        FBNetworkElement element = null;
        if (targetName != null && (parts = new ArrayDeque<String>(Arrays.asList(targetName.split("\\.")))).size() >= 2) {
            FBNetwork nw = null;
            Device dev = this.system.getDeviceNamed((String)parts.getFirst());
            Application application = this.system.getApplicationNamed((String)parts.getFirst());
            if (dev != null) {
                parts.pollFirst();
                Resource res = dev.getResourceNamed((String)parts.pollFirst());
                if (res != null) {
                    nw = res.getFBNetwork();
                    element = SystemImporter.findMappingTargetInFBNetwork(nw, parts);
                }
            }
            if (element == null && application != null) {
                parts = new ArrayDeque<String>(Arrays.asList(targetName.split("\\.")));
                parts.pollFirst();
                nw = application.getFBNetwork();
                element = SystemImporter.findMappingTargetInFBNetwork(nw, parts);
            }
        }
        return element;
    }

    private static FBNetworkElement findMappingTargetInFBNetwork(FBNetwork nw, Deque<String> parts) {
        FBNetworkElement element;
        if (nw != null && (element = nw.getElementNamed(parts.pollFirst())) != null) {
            if (parts.isEmpty()) {
                return element;
            }
            if (element instanceof SubApp) {
                SystemImporter.findMappingTargetInFBNetwork(((SubApp)element).getFbNetwork(), parts);
            }
        }
        return null;
    }

    private void parseDeviceNodeChildren(Device device) throws TypeImportException, XMLStreamException {
        this.processChildren("Device", name -> {
            switch (name) {
                case "Attribute": {
                    this.parseDeviceAttribute(device);
                    break;
                }
                case "Parameter": {
                    VarDeclaration parameter = this.parseParameter();
                    if (parameter == null) break;
                    VarDeclaration devParam = SystemImporter.getParamter((EList<VarDeclaration>)device.getVarDeclarations(), parameter.getName());
                    if (devParam != null) {
                        devParam.setValue(parameter.getValue());
                        break;
                    }
                    parameter.setIsInput(true);
                    device.getVarDeclarations().add((Object)parameter);
                    break;
                }
                case "Resource": {
                    device.getResource().add((Object)this.parseResource());
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
    }

    private void parseDeviceAttribute(Device device) throws XMLStreamException {
        if (this.isColorAttributeNode()) {
            this.parseColor(device);
        } else if (this.isProfileAttribute()) {
            this.parseProfile(device);
        } else {
            this.parseGenericAttributeNode(device);
        }
        this.proceedToEndElementNamed("Attribute");
    }

    private boolean isColorAttributeNode() {
        String name = this.getAttributeValue("Name");
        return name != null && "Color".equals(name);
    }

    private void parseColor(ColorizableElement colElement) {
        Color color = LibraryElementFactory.eINSTANCE.createColor();
        String value = this.getAttributeValue("Value");
        if (value != null) {
            String[] colors = value.split(",");
            color.setRed(Integer.valueOf(colors[0]));
            color.setGreen(Integer.valueOf(colors[1]));
            color.setBlue(Integer.valueOf(colors[2]));
            colElement.setColor(color);
        }
    }

    public static void createParamters(IVarElement element) {
        if (element instanceof Device) {
            element.getVarDeclarations().addAll(EcoreUtil.copyAll(((DeviceTypePaletteEntry)((TypedConfigureableObject)((Object)element)).getPaletteEntry()).getDeviceType().getVarDeclaration()));
        }
        if (element instanceof Resource) {
            element.getVarDeclarations().addAll(EcoreUtil.copyAll(((ResourceTypeEntry)((TypedConfigureableObject)((Object)element)).getPaletteEntry()).getResourceType().getVarDeclaration()));
        }
        for (VarDeclaration varDecl : element.getVarDeclarations()) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            varDecl.setValue(value);
            VarDeclaration typeVar = SystemImporter.getTypeVariable(varDecl);
            if (typeVar == null || typeVar.getValue() == null || typeVar.getValue().getValue() == null) continue;
            value.setValue(typeVar.getValue().getValue());
        }
    }

    private static VarDeclaration getTypeVariable(VarDeclaration var) {
        Resource res;
        EList<VarDeclaration> varList = null;
        if (var.eContainer() instanceof Device) {
            Device dev = (Device)var.eContainer();
            if (dev.getType() != null) {
                varList = dev.getType().getVarDeclaration();
            }
        } else if (var.eContainer() instanceof Resource && (res = (Resource)var.eContainer()).getType() != null) {
            varList = res.getType().getVarDeclaration();
        }
        if (varList != null) {
            for (VarDeclaration typeVar : varList) {
                if (!typeVar.getName().equals(var.getName())) continue;
                return typeVar;
            }
        }
        return null;
    }

    private static VarDeclaration getParamter(EList<VarDeclaration> paramList, String name) {
        for (VarDeclaration varDecl : paramList) {
            if (!varDecl.getName().equals(name)) continue;
            return varDecl;
        }
        return null;
    }

    private Resource parseResource() throws TypeImportException, XMLStreamException {
        Resource resource = LibraryElementFactory.eINSTANCE.createResource();
        resource.setDeviceTypeResource(false);
        this.parseCommon(resource);
        this.parseResourceType(resource);
        FBNetwork fbNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        SystemImporter.createResourceTypeNetwork(((ResourceTypeEntry)resource.getPaletteEntry()).getResourceType(), fbNetwork);
        this.processChildren("Resource", name -> {
            switch (name) {
                case "FBNetwork": {
                    resource.setFBNetwork(new ResDevFBNetworkImporter(this.getPalette(), fbNetwork, (EList<VarDeclaration>)resource.getVarDeclarations(), this.getReader()).parseFBNetwork("FBNetwork"));
                    break;
                }
                case "Attribute": {
                    this.parseGenericAttributeNode(resource);
                    this.proceedToEndElementNamed("Attribute");
                    break;
                }
                case "Parameter": {
                    VarDeclaration parameter = this.parseParameter();
                    if (parameter == null) break;
                    VarDeclaration devParam = SystemImporter.getParamter((EList<VarDeclaration>)resource.getVarDeclarations(), parameter.getName());
                    if (devParam != null) {
                        devParam.setValue(parameter.getValue());
                        break;
                    }
                    parameter.setIsInput(true);
                    resource.getVarDeclarations().add((Object)parameter);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        return resource;
    }

    private void parseResourceType(Resource resource) {
        ResourceTypeEntry entry;
        String typeName = this.getAttributeValue("Type");
        if (typeName != null && (entry = this.getPalette().getResourceTypeEntry(typeName)) != null) {
            resource.setPaletteEntry(entry);
            SystemImporter.createParamters(resource);
        }
    }

    private Application parseApplication() throws TypeImportException, XMLStreamException {
        Application application = LibraryElementFactory.eINSTANCE.createApplication();
        this.readNameCommentAttributes(application);
        this.processChildren("Application", name -> {
            switch (name) {
                case "Attribute": {
                    this.parseGenericAttributeNode(application);
                    this.proceedToEndElementNamed("Attribute");
                    break;
                }
                case "SubAppNetwork": {
                    application.setFBNetwork(new SubAppNetworkImporter(this.getPalette(), this.getReader()).parseFBNetwork("SubAppNetwork"));
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        return application;
    }

    public static void createResourceTypeNetwork(ResourceType type, FBNetwork resourceFBNetwork) {
        IInterfaceElement dest;
        IInterfaceElement source;
        FB destFB;
        FB sourceFB;
        HashMap<String, Event> events = new HashMap<String, Event>();
        HashMap<String, VarDeclaration> varDecls = new HashMap<String, VarDeclaration>();
        for (FBNetworkElement element : type.getFBNetwork().getNetworkElements()) {
            Event eventCopy;
            VarDeclaration varDeclCopy;
            ResourceTypeFB copy = LibraryElementFactory.eINSTANCE.createResourceTypeFB();
            resourceFBNetwork.getNetworkElements().add((Object)copy);
            copy.setPaletteEntry(element.getPaletteEntry());
            copy.setName(element.getName());
            InterfaceList interfaceList = LibraryElementFactory.eINSTANCE.createInterfaceList();
            for (VarDeclaration varDecl : element.getInterface().getOutputVars()) {
                varDeclCopy = LibraryElementFactory.eINSTANCE.createVarDeclaration();
                varDeclCopy.setType(varDecl.getType());
                varDeclCopy.setName(varDecl.getName());
                varDeclCopy.setComment(varDecl.getComment());
                varDeclCopy.setIsInput(varDecl.isIsInput());
                if (varDecl.getValue() != null) {
                    varDeclCopy.setValue((Value)EcoreUtil.copy((EObject)varDecl.getValue()));
                }
                varDecls.put(String.valueOf(element.getName()) + "." + varDeclCopy.getName(), varDeclCopy);
                interfaceList.getOutputVars().add((Object)varDeclCopy);
            }
            for (VarDeclaration varDecl : element.getInterface().getInputVars()) {
                varDeclCopy = LibraryElementFactory.eINSTANCE.createVarDeclaration();
                varDeclCopy.setType(varDecl.getType());
                varDeclCopy.setName(varDecl.getName());
                varDeclCopy.setComment(varDecl.getComment());
                varDeclCopy.setIsInput(varDecl.isIsInput());
                if (varDecl.getValue() != null) {
                    varDeclCopy.setValue((Value)EcoreUtil.copy((EObject)varDecl.getValue()));
                }
                varDecls.put(String.valueOf(element.getName()) + "." + varDeclCopy.getName(), varDeclCopy);
                interfaceList.getInputVars().add((Object)varDeclCopy);
            }
            for (Event event : element.getInterface().getEventInputs()) {
                eventCopy = LibraryElementFactory.eINSTANCE.createEvent();
                eventCopy.setType(event.getType());
                eventCopy.setName(event.getName());
                eventCopy.setComment(event.getComment());
                eventCopy.setIsInput(event.isIsInput());
                events.put(String.valueOf(element.getName()) + "." + event.getName(), eventCopy);
                interfaceList.getEventInputs().add((Object)eventCopy);
            }
            for (Event event : element.getInterface().getEventOutputs()) {
                eventCopy = LibraryElementFactory.eINSTANCE.createEvent();
                eventCopy.setType(event.getType());
                eventCopy.setName(event.getName());
                eventCopy.setComment(event.getComment());
                eventCopy.setIsInput(event.isIsInput());
                events.put(String.valueOf(element.getName()) + "." + event.getName(), eventCopy);
                interfaceList.getEventOutputs().add((Object)eventCopy);
            }
            copy.setInterface(interfaceList);
            copy.setX(element.getX());
            copy.setY(element.getY());
        }
        for (EventConnection eventCon : type.getFBNetwork().getEventConnections()) {
            if (eventCon.getSource() == null || eventCon.getDestination() == null) continue;
            sourceFB = (FB)eventCon.getSource().eContainer().eContainer();
            destFB = (FB)eventCon.getDestination().eContainer().eContainer();
            source = (Event)events.get(String.valueOf(sourceFB.getName()) + "." + eventCon.getSource().getName());
            dest = (Event)events.get(String.valueOf(destFB.getName()) + "." + eventCon.getDestination().getName());
            EventConnection copyEventCon = LibraryElementFactory.eINSTANCE.createEventConnection();
            copyEventCon.setSource(source);
            copyEventCon.setDestination(dest);
            copyEventCon.setResTypeConnection(true);
            resourceFBNetwork.getEventConnections().add((Object)copyEventCon);
        }
        for (DataConnection dataCon : type.getFBNetwork().getDataConnections()) {
            if (dataCon.getSource() == null || dataCon.getDestination() == null) continue;
            sourceFB = (FB)dataCon.getSource().eContainer().eContainer();
            destFB = (FB)dataCon.getDestination().eContainer().eContainer();
            source = (VarDeclaration)varDecls.get(String.valueOf(sourceFB.getName()) + "." + dataCon.getSource().getName());
            dest = (VarDeclaration)varDecls.get(String.valueOf(destFB.getName()) + "." + dataCon.getDestination().getName());
            DataConnection copyDataCon = LibraryElementFactory.eINSTANCE.createDataConnection();
            copyDataCon.setSource(source);
            copyDataCon.setDestination(dest);
            copyDataCon.setResTypeConnection(true);
            resourceFBNetwork.getDataConnections().add((Object)copyDataCon);
        }
    }
}

