/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.fbtypeeditor.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.DataTypeCreationFactory;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.jface.resource.ImageDescriptor;

public final class FBInterfacePaletteFactory {
    private static final String PALETTE_DOCK_LOCATION = "FBInterfacePaletteFactory.Location";
    private static final String PALETTE_SIZE = "FBInterfacePaletteFactory.Size";
    private static final String PALETTE_STATE = "FBInterfacePaletteFactory.State";

    public static FlyoutPaletteComposite.FlyoutPreferences createPalettePreferences() {
        boolean val = Activator.getDefault().getPreferenceStore().contains(PALETTE_STATE);
        FlyoutPaletteComposite.FlyoutPreferences preferences = new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return Activator.getDefault().getPreferenceStore().getInt(FBInterfacePaletteFactory.PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                return Activator.getDefault().getPreferenceStore().getInt(FBInterfacePaletteFactory.PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return Activator.getDefault().getPreferenceStore().getInt(FBInterfacePaletteFactory.PALETTE_SIZE);
            }

            public void setDockLocation(int location) {
                Activator.getDefault().getPreferenceStore().setValue(FBInterfacePaletteFactory.PALETTE_DOCK_LOCATION, location);
            }

            public void setPaletteState(int state) {
                Activator.getDefault().getPreferenceStore().setValue(FBInterfacePaletteFactory.PALETTE_STATE, state);
            }

            public void setPaletteWidth(int width) {
                Activator.getDefault().getPreferenceStore().setValue(FBInterfacePaletteFactory.PALETTE_SIZE, width);
            }
        };
        if (!val) {
            preferences.setPaletteState(4);
            preferences.setPaletteWidth(125);
        }
        return preferences;
    }

    public static PaletteRoot createPalette(Palette systemPalette) {
        PaletteRoot palette = new PaletteRoot();
        FBInterfacePaletteFactory.fillPalette(systemPalette, palette);
        return palette;
    }

    private static void fillPalette(Palette systemPalette, PaletteRoot palette) {
        CombinedTemplateCreationEntry combined;
        ImageDescriptor desc;
        PaletteDrawer drawer = new PaletteDrawer("EventTypes");
        for (DataType type : EventTypeLibrary.getInstance().getEventTypes()) {
            desc = FordiacImage.ICON_DataType.getImageDescriptor();
            combined = new CombinedTemplateCreationEntry(type.getName(), type.getComment(), (CreationFactory)new DataTypeCreationFactory(type), desc, desc);
            drawer.add((org.eclipse.gef.palette.PaletteEntry)combined);
        }
        palette.add((org.eclipse.gef.palette.PaletteEntry)drawer);
        drawer = new PaletteDrawer("DataTypes");
        for (DataType dataType : DataTypeLibrary.getInstance().getDataTypesSorted()) {
            desc = FordiacImage.ICON_DataType.getImageDescriptor();
            combined = new CombinedTemplateCreationEntry(dataType.getName(), dataType.getComment(), (CreationFactory)new DataTypeCreationFactory(dataType), desc, desc);
            drawer.add((org.eclipse.gef.palette.PaletteEntry)combined);
        }
        palette.add((org.eclipse.gef.palette.PaletteEntry)drawer);
        FBInterfacePaletteFactory.fillPalette(palette, systemPalette);
    }

    private static void fillPalette(PaletteRoot palette, Palette systemPalette) {
        Palette pal = null;
        pal = systemPalette == null ? TypeLibrary.getInstance().getPalette() : systemPalette;
        PaletteDrawer drawer = FBInterfacePaletteFactory.createGroup(pal.getRootGroup(), "", palette);
        if (drawer.getChildren().size() > 0) {
            palette.add((org.eclipse.gef.palette.PaletteEntry)drawer);
        }
    }

    private static PaletteDrawer createGroup(PaletteGroup group, String parentGroup, PaletteRoot palette) {
        String newParent = "";
        if (!group.getLabel().equals("Root Group")) {
            newParent = String.valueOf(newParent) + (parentGroup.equals("") ? String.valueOf(parentGroup) + "." + group.getLabel() : group.getLabel());
        }
        for (PaletteGroup paletteGroup : group.getSubGroups()) {
            PaletteDrawer drawer = FBInterfacePaletteFactory.createGroup(paletteGroup, newParent, palette);
            if (drawer.getChildren().size() <= 0) continue;
            palette.add((org.eclipse.gef.palette.PaletteEntry)drawer);
        }
        PaletteDrawer paletteContainer = new PaletteDrawer(!parentGroup.equals("") ? String.valueOf(parentGroup) + "." + group.getLabel() : group.getLabel());
        paletteContainer.addAll(FBInterfacePaletteFactory.createAdapterEntries(group));
        return paletteContainer;
    }

    private static List<org.eclipse.gef.palette.PaletteEntry> createAdapterEntries(PaletteGroup group) {
        ArrayList<org.eclipse.gef.palette.PaletteEntry> entries = new ArrayList<org.eclipse.gef.palette.PaletteEntry>();
        for (PaletteEntry paletteEntry : group.getEntries()) {
            if (!(paletteEntry instanceof AdapterTypePaletteEntry)) continue;
            AdapterTypePaletteEntry entry = (AdapterTypePaletteEntry)paletteEntry;
            ImageDescriptor desc = FordiacImage.ICON_DataType.getImageDescriptor();
            CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(entry.getLabel(), entry.getType().getComment(), (CreationFactory)new DataTypeCreationFactory((DataType)entry.getAdapterType()), desc, desc);
            if (combined == null) continue;
            entries.add((org.eclipse.gef.palette.PaletteEntry)combined);
        }
        return entries;
    }
}

