/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.draw2d.AdvancedRoundedRectangle;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;

public class FBTypeFigure
extends Shape {
    private final Figure main = new Figure();
    private RoundedRectangle top;
    private final Figure topInputs = new Figure();
    private final Figure topOutputs = new Figure();
    private RoundedRectangle middle;
    private final Figure middleInputs = new Figure();
    private final Figure middleOutputs = new Figure();
    private RoundedRectangle bottom;
    private final Figure bottomInputs = new Figure();
    private final Figure bottomInputValuesFigure = new Figure();
    private final Figure bottomOutputs = new Figure();
    private final Figure eventInputs = new Figure();
    private final Figure eventOutputs = new Figure();
    private final Figure dataInputs = new Figure();
    private final Figure sockets = new Figure();
    private final Figure dataOutputs = new Figure();
    private final Figure plugs = new Figure();
    protected TopBorder bottomBorder;
    protected Label typeName;
    private Label versionInfoLabel;
    private FBType type;
    private ZoomManager zoomManager;

    public FBTypeFigure() {
        this.configureRectangles();
    }

    private void configureRectangles() {
        this.top = new AdvancedRoundedRectangle(25, this.zoomManager, this.main, true, null);
        this.middle = new AdvancedRoundedRectangle(24, this.zoomManager, this.main, true, null);
        this.bottom = new AdvancedRoundedRectangle(28, this.zoomManager, this.main, true, null);
    }

    public FBTypeFigure(FBType type, ZoomManager zoomManager) {
        this.type = type;
        this.zoomManager = zoomManager;
        this.setBackgroundColor(ColorConstants.white);
        this.setFillXOR(true);
        this.configureRectangles();
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayoutManager((LayoutManager)gridLayout);
        GridLayout mainLayout = new GridLayout(3, false);
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainLayout.horizontalSpacing = 0;
        mainLayout.verticalSpacing = -1;
        GridData mainLayoutData = new GridData(1808);
        this.main.setLayoutManager((LayoutManager)mainLayout);
        this.add((IFigure)this.main);
        this.setConstraint((IFigure)this.main, mainLayoutData);
        IPreferenceStore pf = Activator.getDefault().getPreferenceStore();
        int cornerDim = pf.getInt("CornerDim");
        this.top.setCornerDimensions(new Dimension(cornerDim, cornerDim));
        this.top.setCornerDimensions(new Dimension(cornerDim, cornerDim));
        GridData topLayoutData = new GridData(784);
        BorderLayout topLayout = new BorderLayout();
        this.top.setLayoutManager((LayoutManager)topLayout);
        this.main.add((IFigure)this.topInputs);
        this.main.add((IFigure)this.top);
        this.main.add((IFigure)this.topOutputs);
        this.main.setConstraint((IFigure)this.top, (Object)topLayoutData);
        GridLayout tpl = new GridLayout(3, false);
        tpl.marginHeight = 0;
        this.topInputs.setLayoutManager((LayoutManager)tpl);
        ToolbarLayout topInputsLayout = new ToolbarLayout(false);
        topInputsLayout.setStretchMinorAxis(true);
        this.eventInputs.setLayoutManager((LayoutManager)topInputsLayout);
        this.eventInputs.setBorder((Border)new MarginBorder(4, 0, 4, 0));
        this.top.add((IFigure)this.eventInputs);
        this.top.setConstraint((IFigure)this.eventInputs, (Object)BorderLayout.LEFT);
        ToolbarLayout topOutputsLayout = new ToolbarLayout(false);
        topOutputsLayout.setStretchMinorAxis(true);
        this.eventOutputs.setLayoutManager((LayoutManager)topOutputsLayout);
        this.eventOutputs.setMinimumSize(new Dimension(40, 18));
        this.eventOutputs.setBorder((Border)new MarginBorder(4, 0, 4, 0));
        this.top.add((IFigure)this.eventOutputs);
        this.top.setConstraint((IFigure)this.eventOutputs, (Object)BorderLayout.RIGHT);
        Figure middleContainer = new Figure();
        BorderLayout borderLayout = new BorderLayout();
        middleContainer.setLayoutManager((LayoutManager)borderLayout);
        borderLayout.setHorizontalSpacing(10);
        middleContainer.setBorder((Border)new MarginBorder(0, 7, 0, 7));
        this.main.add((IFigure)this.middleInputs);
        this.middleInputs.setBorder((Border)new LineBorder(ColorConstants.orange));
        this.main.add((IFigure)middleContainer);
        this.main.add((IFigure)this.middleOutputs);
        middleContainer.add((IFigure)this.middle, (Object)BorderLayout.CENTER);
        this.middle.setCornerDimensions(new Dimension());
        GridLayout middleLayout = new GridLayout(1, true);
        GridData middleLayouData = new GridData(768);
        this.main.setConstraint((IFigure)middleContainer, (Object)middleLayouData);
        this.middle.setLayoutManager((LayoutManager)middleLayout);
        this.middle.setBorder((Border)new TopBorder(this.getBackgroundColor(), 0));
        middleLayout.marginHeight = 0;
        middleLayout.verticalSpacing = 1;
        this.typeName = new Label(type.getName() != null ? type.getName() : "N/D");
        this.middle.add((IFigure)this.typeName);
        this.typeName.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        this.typeName.setTextAlignment(2);
        this.middle.setConstraint((IFigure)this.typeName, (Object)new GridData(768));
        this.versionInfoLabel = new Label();
        this.updateVersionInfoLabel();
        this.middle.add((IFigure)this.versionInfoLabel);
        this.versionInfoLabel.setTextAlignment(2);
        this.middle.setConstraint((IFigure)this.versionInfoLabel, (Object)new GridData(768));
        this.bottom.setCornerDimensions(new Dimension(cornerDim, cornerDim));
        this.bottomBorder = new TopBorder(this.getBackgroundColor(), 10);
        this.bottom.setBorder((Border)this.bottomBorder);
        BorderLayout bottomLayout = new BorderLayout();
        this.bottom.setLayoutManager((LayoutManager)bottomLayout);
        GridData bottomLayoutData = new GridData(1808);
        bottomLayoutData.verticalAlignment = 128;
        GridLayout bottomInputValuesLayout = new GridLayout();
        bottomInputValuesLayout.marginHeight = 4;
        bottomInputValuesLayout.marginWidth = 2;
        bottomInputValuesLayout.horizontalSpacing = 0;
        GridData bottomILayoutData = new GridData(1808);
        bottomILayoutData.verticalAlignment = 128;
        this.main.add((IFigure)this.bottomInputs);
        this.main.setConstraint((IFigure)this.bottomInputs, (Object)bottomILayoutData);
        this.bottomInputs.setLayoutManager((LayoutManager)bottomInputValuesLayout);
        ToolbarLayout bottomInputValuesFigureLayout = new ToolbarLayout(false);
        bottomInputValuesFigureLayout.setStretchMinorAxis(true);
        this.bottomInputValuesFigure.setLayoutManager((LayoutManager)bottomInputValuesFigureLayout);
        GridData bottomInputsFigureLayoutData = new GridData(1808);
        bottomInputsFigureLayoutData.verticalAlignment = 128;
        this.bottomInputs.add((IFigure)this.bottomInputValuesFigure);
        this.bottomInputs.setConstraint((IFigure)this.bottomInputValuesFigure, (Object)bottomInputsFigureLayoutData);
        this.main.add((IFigure)this.bottom);
        this.main.add((IFigure)this.bottomOutputs);
        this.main.setConstraint((IFigure)this.bottom, (Object)bottomLayoutData);
        Figure bottomInputContainer = new Figure();
        FlowLayout inputContainerLayout = new FlowLayout();
        inputContainerLayout.setHorizontal(false);
        inputContainerLayout.setStretchMinorAxis(true);
        bottomInputContainer.setLayoutManager((LayoutManager)inputContainerLayout);
        this.bottom.add((IFigure)bottomInputContainer);
        this.bottom.setConstraint((IFigure)bottomInputContainer, (Object)BorderLayout.LEFT);
        ToolbarLayout bottomInputsLayout = new ToolbarLayout(false);
        bottomInputsLayout.setStretchMinorAxis(true);
        this.dataInputs.setLayoutManager((LayoutManager)bottomInputsLayout);
        this.dataInputs.setBorder((Border)new MarginBorder(4, 0, 0, 0));
        bottomInputContainer.add((IFigure)this.dataInputs);
        ToolbarLayout bottomSocketsLayout = new ToolbarLayout(false);
        bottomSocketsLayout.setStretchMinorAxis(true);
        this.sockets.setLayoutManager((LayoutManager)bottomSocketsLayout);
        this.sockets.setBorder((Border)new MarginBorder(0, 0, 4, 0));
        bottomInputContainer.add((IFigure)this.sockets);
        Figure bottomOutputContainer = new Figure();
        FlowLayout outputContainerLayout = new FlowLayout();
        outputContainerLayout.setHorizontal(false);
        outputContainerLayout.setStretchMinorAxis(true);
        outputContainerLayout.setMajorSpacing(0);
        outputContainerLayout.setMinorAlignment(2);
        bottomOutputContainer.setLayoutManager((LayoutManager)outputContainerLayout);
        this.bottom.add((IFigure)bottomOutputContainer);
        this.bottom.setConstraint((IFigure)bottomOutputContainer, (Object)BorderLayout.RIGHT);
        ToolbarLayout bottomOutputsLayout = new ToolbarLayout(false);
        bottomOutputsLayout.setStretchMinorAxis(true);
        bottomOutputsLayout.setMinorAlignment(2);
        bottomOutputsLayout.setSpacing(0);
        this.dataOutputs.setLayoutManager((LayoutManager)bottomOutputsLayout);
        this.dataOutputs.setBorder((Border)new MarginBorder(4, 0, 0, 0));
        Figure bottomDataOutputContainer = new Figure();
        BorderLayout bottomDataOutputLayout = new BorderLayout();
        bottomDataOutputContainer.setLayoutManager((LayoutManager)bottomDataOutputLayout);
        bottomOutputContainer.add((IFigure)bottomDataOutputContainer);
        bottomOutputContainer.setConstraint((IFigure)bottomDataOutputContainer, (Object)2);
        bottomDataOutputContainer.add((IFigure)this.dataOutputs);
        bottomDataOutputContainer.setConstraint((IFigure)this.dataOutputs, (Object)BorderLayout.RIGHT);
        ToolbarLayout bottomPlugsLayout = new ToolbarLayout(false);
        bottomPlugsLayout.setStretchMinorAxis(true);
        bottomPlugsLayout.setMinorAlignment(2);
        this.plugs.setLayoutManager((LayoutManager)bottomPlugsLayout);
        this.plugs.setBorder((Border)new MarginBorder(0, 0, 4, 0));
        Figure bottomPlugsContainer = new Figure();
        BorderLayout bottomPlugsContainerLayout = new BorderLayout();
        bottomPlugsContainer.setLayoutManager((LayoutManager)bottomPlugsContainerLayout);
        bottomOutputContainer.add((IFigure)bottomPlugsContainer);
        bottomOutputContainer.setConstraint((IFigure)bottomPlugsContainer, (Object)2);
        bottomPlugsContainer.add((IFigure)this.plugs);
        bottomPlugsContainer.setConstraint((IFigure)this.plugs, (Object)BorderLayout.RIGHT);
    }

    public Figure getInputEvents() {
        return this.eventInputs;
    }

    public Figure getOutputEvents() {
        return this.eventOutputs;
    }

    public Figure getInputVariables() {
        return this.dataInputs;
    }

    public Figure getSockets() {
        return this.sockets;
    }

    public Figure getPlugs() {
        return this.plugs;
    }

    public Figure getOutputVariables() {
        return this.dataOutputs;
    }

    public Label getTypeNameLabel() {
        return this.typeName;
    }

    public void updateVersionInfoLabel() {
        VersionInfo versionInfo = null;
        if (this.type.getVersionInfo().size() > 0) {
            versionInfo = (VersionInfo)this.type.getVersionInfo().get(this.type.getVersionInfo().size() - 1);
        }
        this.versionInfoLabel.setText(versionInfo != null ? versionInfo.getVersion() : "N/D");
    }

    protected void fillShape(Graphics graphics) {
    }

    protected void outlineShape(Graphics graphics) {
    }

    private class TopBorder
    extends LineBorder {
        private int cornerDimensions;

        private TopBorder(Color color, int cornerDimensions) {
            super(color);
            this.cornerDimensions = 0;
            this.cornerDimensions = cornerDimensions;
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(0, 0, 0, 0);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.setAntialias(1);
            tempRect.setBounds(TopBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
            if (1 == (this.getWidth() & 1)) {
                --TopBorder.tempRect.width;
                --TopBorder.tempRect.height;
            }
            tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
            graphics.setLineWidth(this.getWidth());
            if (this.getColor() != null) {
                graphics.setForegroundColor(this.getColor());
            }
            graphics.drawLine(TopBorder.tempRect.x + this.cornerDimensions, TopBorder.tempRect.y, TopBorder.tempRect.x + TopBorder.tempRect.width - this.cornerDimensions, TopBorder.tempRect.y);
        }
    }
}

