/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts;

import java.util.ArrayList;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeConditionEventCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteTransitionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.MoveBendpointCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.policies.TransitionBendPointEditPolicy;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.preferences.PreferenceGetter;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterEvent;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.util.STStringTokenHandling;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Path;

public class ECTransitionEditPart
extends AbstractConnectionEditPart {
    private Label condition;
    private TransitionOrderDecorator transitionOrderDecorator;
    private final EContentAdapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            ECTransitionEditPart.this.refresh();
        }
    };
    private final EContentAdapter interfaceAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 4) {
                if (notification.getOldValue() == ECTransitionEditPart.this.getCastedModel().getConditionEvent() || ECTransitionEditPart.this.getCastedModel().getConditionEvent() instanceof AdapterEvent && notification.getOldValue() instanceof AdapterDeclaration && ((AdapterEvent)ECTransitionEditPart.this.getCastedModel().getConditionEvent()).getAdapterDeclaration() == notification.getOldValue()) {
                    AbstractDirectEditableEditPart.executeCommand((Command)new ChangeConditionEventCommand(ECTransitionEditPart.this.getCastedModel(), ""));
                }
            } else if (notification.getEventType() == 1) {
                if (ECTransitionEditPart.this.getCastedModel().getConditionEvent() != null && notification.getNewValue() instanceof String) {
                    if (ECTransitionEditPart.this.getCastedModel().getConditionEvent().getName().equals(notification.getNewValue())) {
                        super.notifyChanged(notification);
                        ECTransitionEditPart.this.refresh();
                    } else if (ECTransitionEditPart.this.getCastedModel().getConditionEvent() instanceof AdapterEvent && ((AdapterEvent)ECTransitionEditPart.this.getCastedModel().getConditionEvent()).getAdapterDeclaration().getName().equals(notification.getNewValue())) {
                        super.notifyChanged(notification);
                        ECTransitionEditPart.this.refresh();
                    }
                }
                if (notification.getNotifier() instanceof VarDeclaration) {
                    this.checkConditionExpresion(notification);
                }
            }
        }

        private void checkConditionExpresion(Notification notification) {
            if (notification.getNewValue() instanceof String) {
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature) && ECTransitionEditPart.this.getCastedModel().getConditionExpression() != null && -1 != ECTransitionEditPart.this.getCastedModel().getConditionExpression().indexOf(notification.getOldStringValue())) {
                    String expresion = STStringTokenHandling.replaceSTToken((String)ECTransitionEditPart.this.getCastedModel().getConditionExpression(), (String)notification.getOldStringValue(), (String)notification.getNewStringValue());
                    ECTransitionEditPart.this.getCastedModel().setConditionExpression(expresion);
                    ECTransitionEditPart.this.refresh();
                }
            }
        }
    };

    private void updateOrderLabel() {
        ECTransition transition = this.getCastedModel();
        if (transition.getSource() != null) {
            if (1 < transition.getSource().getOutTransitions().size()) {
                int i = 1;
                for (ECTransition runner : transition.getSource().getOutTransitions()) {
                    if (runner.equals(transition)) {
                        this.transitionOrderDecorator.setText(Integer.toString(i));
                    }
                    ++i;
                }
            } else {
                this.transitionOrderDecorator.setText("");
            }
        }
    }

    public ECTransition getCastedModel() {
        return (ECTransition)this.getModel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new TransitionBendPointEditPolicy(this.getCastedModel()));
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                return new DeleteTransitionCommand(ECTransitionEditPart.this.getCastedModel());
            }
        });
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new XYLayoutEditPolicy(){

            public Command getCommand(Request request) {
                if ("move".equals(request.getType())) {
                    return this.getTransitionMoveCommand((ChangeBoundsRequest)request);
                }
                return null;
            }

            public boolean understandsRequest(Request request) {
                return "move".equals(request.getType());
            }

            protected Command getTransitionMoveCommand(ChangeBoundsRequest request) {
                Point p = new Point(ECTransitionEditPart.this.getCastedModel().getX(), ECTransitionEditPart.this.getCastedModel().getY());
                p.x += request.getMoveDelta().x;
                p.y += request.getMoveDelta().y;
                return new MoveBendpointCommand(ECTransitionEditPart.this.getCastedModel(), p);
            }

            protected EditPolicy createChildEditPolicy(EditPart child) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }
        });
    }

    public void performRequest(Request request) {
        if (request.getType() != "open") {
            super.performRequest(request);
        }
    }

    protected void refreshVisuals() {
        this.condition.setText(this.getCastedModel().getConditionText());
        this.updateOrderLabel();
        AbsoluteBendpoint ab = new AbsoluteBendpoint(this.getCastedModel().getX(), this.getCastedModel().getY());
        ArrayList<AbsoluteBendpoint> bendPoints = new ArrayList<AbsoluteBendpoint>();
        bendPoints.add(ab);
        this.getConnectionFigure().getConnectionRouter().setConstraint(this.getConnectionFigure(), bendPoints);
    }

    protected IFigure createFigure() {
        final PolylineConnection connection = new PolylineConnection(){

            protected void outlineShape(Graphics g) {
                Path p = new Path(null);
                p.moveTo((float)this.getStart().x, (float)this.getStart().y);
                p.quadTo((float)this.getPoints().getMidpoint().x, (float)this.getPoints().getMidpoint().y, (float)this.getEnd().x, (float)this.getEnd().y);
                g.drawPath(p);
                p.dispose();
            }
        };
        connection.setLineWidth(2);
        connection.setAntialias(1);
        PolygonDecoration rectDec = new PolygonDecoration();
        rectDec.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        rectDec.setScale(7.0, 4.0);
        rectDec.setFill(true);
        connection.setForegroundColor(PreferenceGetter.getColor("ECCEditorTransitionColor"));
        connection.setTargetDecoration((RotatableDecoration)rectDec);
        ConnectionLocator constraintLocator = new ConnectionLocator((Connection)connection, 4){

            protected Point getReferencePoint() {
                Path path = new Path(null);
                path.moveTo((float)connection.getStart().x, (float)connection.getStart().y);
                path.quadTo((float)connection.getPoints().getMidpoint().x, (float)connection.getPoints().getMidpoint().y, (float)connection.getEnd().x, (float)connection.getEnd().y);
                PointList ptl = new PointList();
                float[] linePoints = path.getPathData().points;
                int i = 0;
                while (i + 1 < linePoints.length) {
                    int x = (int)linePoints[i];
                    int y = (int)linePoints[i + 1];
                    ptl.addPoint(x, y);
                    i += 2;
                }
                path.dispose();
                Point p = this.getLocation(ptl);
                this.getConnection().translateToAbsolute((Translatable)p);
                return p;
            }
        };
        this.condition = new Label(this.getCastedModel().getConditionText());
        this.condition.setBorder((Border)new MarginBorder(3, 6, 3, 6));
        this.condition.setOpaque(true);
        connection.add((IFigure)this.condition, (Object)constraintLocator);
        AbsoluteBendpoint ab = new AbsoluteBendpoint(this.getCastedModel().getX(), this.getCastedModel().getY());
        ArrayList<AbsoluteBendpoint> bendPoints = new ArrayList<AbsoluteBendpoint>();
        bendPoints.add(ab);
        BendpointConnectionRouter bcr = new BendpointConnectionRouter();
        bcr.setConstraint((Connection)connection, bendPoints);
        connection.setConnectionRouter((ConnectionRouter)bcr);
        this.transitionOrderDecorator = new TransitionOrderDecorator();
        connection.setSourceDecoration((RotatableDecoration)this.transitionOrderDecorator);
        this.updateOrderLabel();
        return connection;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().eAdapters().add((Object)this.adapter);
            this.getCastedModel().eContainer().eAdapters().add((Object)this.adapter);
            ((BasicFBType)this.getCastedModel().eContainer().eContainer()).getInterfaceList().eAdapters().add((Object)this.interfaceAdapter);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getCastedModel().eAdapters().remove((Object)this.adapter);
            this.getCastedModel().eContainer().eAdapters().remove((Object)this.adapter);
            ((BasicFBType)this.getCastedModel().eContainer().eContainer()).getInterfaceList().eAdapters().remove((Object)this.interfaceAdapter);
        }
    }

    public void highlight(boolean highlight) {
        PolylineConnection pc = null;
        if (this.getConnectionFigure() instanceof PolylineConnection) {
            pc = (PolylineConnection)this.getConnectionFigure();
        }
        if (highlight && pc != null) {
            pc.setLineWidth(3);
        } else if (!highlight && pc != null) {
            pc.setLineWidth(2);
        }
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTracker((EditPart)this){

            protected boolean isMove() {
                if (this.getSourceEditPart() instanceof ECTransitionEditPart) {
                    return true;
                }
                return super.isMove();
            }
        };
    }

    private class TransitionOrderDecorator
    extends Ellipse
    implements RotatableDecoration {
        private Label orderLabel;

        public TransitionOrderDecorator() {
            this.setLayoutManager((LayoutManager)new StackLayout());
            this.orderLabel = new Label();
            this.orderLabel.setOpaque(false);
            this.setFill(true);
            this.setAntialias(1);
            this.setBackgroundColor(PreferenceGetter.getColor("ECCEditorTransitionColor"));
            this.setOutline(false);
            this.orderLabel.setForegroundColor(ColorConstants.white);
            this.orderLabel.setFont(new Font(null, "Tahoma", 7, 0));
            this.add((IFigure)this.orderLabel);
        }

        public void setReferencePoint(Point p) {
        }

        public void setLocation(Point p) {
            p.x -= this.getSize().width() / 2;
            p.y -= this.getSize().height() / 2;
            super.setLocation(p);
        }

        public void setText(String val) {
            this.orderLabel.setText(val);
            if ("".equals(this.orderLabel.getText())) {
                this.setSize(0, 0);
            } else {
                this.setSize(14, 14);
            }
        }
    }
}

