/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import java.util.Hashtable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeAlgorithmCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeOutputCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateAlgorithmCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteAlgorithmCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.ActionContentProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionAlgorithm;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionAlgorithmEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionHelpers;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionOutputEvent;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionOutputEventEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AbstractECSection;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AlgorithmGroup;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ActionSection
extends AbstractECSection {
    private Composite actionComposite;
    private Combo algorithmCombo;
    private Combo outputEventCombo;
    private AlgorithmGroup algorithmGroup;
    private Hashtable<String, Event> events = new Hashtable();
    private TreeViewer algorithmsViewer;
    private Button algorithmNew;
    private Button algorithmDelete;

    protected ECAction getType() {
        return (ECAction)this.type;
    }

    protected Algorithm getAlgorithm() {
        return this.getType().getAlgorithm();
    }

    protected EList<Event> getOutputEvents() {
        BasicFBType fb = ECActionHelpers.getFBType(this.getType());
        return fb != null ? fb.getInterfaceList().getEventOutputs() : ECollections.emptyEList();
    }

    protected Object getInputType(Object input) {
        if (input instanceof ECActionAlgorithmEditPart) {
            return ((ECActionAlgorithmEditPart)((Object)input)).getAction();
        }
        if (input instanceof ECActionAlgorithm) {
            return ((ECActionAlgorithm)input).getAction();
        }
        if (input instanceof ECActionOutputEventEditPart) {
            return ((ECActionOutputEventEditPart)((Object)input)).getAction();
        }
        if (input instanceof ECActionOutputEvent) {
            return ((ECActionOutputEvent)input).getAction();
        }
        if (input instanceof ECAction) {
            return input;
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(3, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createActionCombos(parent);
        this.algorithmGroup = new AlgorithmGroup(parent, this.getWidgetFactory());
        this.createAlgorithmView(parent);
    }

    private void createActionCombos(Composite parent) {
        this.actionComposite = this.getWidgetFactory().createComposite(parent);
        GridData actionCompositeLayoutData = new GridData(4, 0, true, false);
        actionCompositeLayoutData.horizontalSpan = 3;
        this.actionComposite.setLayoutData((Object)actionCompositeLayoutData);
        RowLayout layout = new RowLayout();
        layout.fill = true;
        this.actionComposite.setLayout((Layout)layout);
        this.getWidgetFactory().createCLabel(this.actionComposite, "Algorithm: ");
        this.algorithmCombo = new Combo(this.actionComposite, 12);
        this.algorithmCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ActionSection.this.removeContentAdapter();
                if (ActionSection.this.algorithmCombo.indexOf(ActionSection.this.algorithmCombo.getText()) > 0) {
                    BasicFBType fb = ECActionHelpers.getFBType(ActionSection.this.getType());
                    if (fb != null) {
                        ActionSection.this.executeCommand(new ChangeAlgorithmCommand(ActionSection.this.getType(), (Algorithm)fb.getAlgorithm().get(ActionSection.this.algorithmCombo.indexOf(ActionSection.this.algorithmCombo.getText()) - 1)));
                    }
                } else {
                    ActionSection.this.executeCommand(new ChangeAlgorithmCommand(ActionSection.this.getType(), null));
                }
                ActionSection.this.algorithmGroup.setAlgorithm(ActionSection.this.getAlgorithm());
                ActionSection.this.algorithmsViewer.setInput((Object)ActionSection.this.getType());
                ActionSection.this.addContentAdapter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getWidgetFactory().createCLabel(this.actionComposite, "Output Event: ");
        this.outputEventCombo = new Combo(this.actionComposite, 12);
        this.outputEventCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ActionSection.this.removeContentAdapter();
                ActionSection.this.executeCommand(new ChangeOutputCommand(ActionSection.this.getType(), (Event)ActionSection.this.events.get(ActionSection.this.outputEventCombo.getText())));
                ActionSection.this.addContentAdapter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createAlgorithmView(Composite parent) {
        Group algorithmComposite = this.getWidgetFactory().createGroup(parent, "All Algorithms");
        algorithmComposite.setLayout((Layout)new GridLayout(2, false));
        algorithmComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createAllAlgorithmViewer((Composite)algorithmComposite);
        this.createAddDeleteButtons((Composite)algorithmComposite);
    }

    private void createAddDeleteButtons(Composite parent) {
        Composite buttonComp = new Composite(parent, 0);
        GridData buttonCompLayoutData = new GridData(0x1000000, 128, false, false);
        buttonComp.setLayoutData((Object)buttonCompLayoutData);
        buttonComp.setLayout((Layout)new FillLayout(512));
        this.algorithmNew = this.getWidgetFactory().createButton(buttonComp, "", 0x800000);
        this.algorithmNew.setToolTipText("Create new algorithm");
        this.algorithmNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.algorithmNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BasicFBType fb = ECActionHelpers.getFBType(ActionSection.this.getType());
                if (fb != null) {
                    ActionSection.this.executeCommand(new CreateAlgorithmCommand(fb));
                    ActionSection.this.algorithmsViewer.refresh();
                    ActionSection.this.setAlgorithmDropdown();
                }
            }
        });
        this.algorithmDelete = this.getWidgetFactory().createButton(buttonComp, "", 0x800000);
        this.algorithmDelete.setToolTipText("Delete algorithm");
        this.algorithmDelete.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.algorithmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicFBType fb;
                Object selection = ((TreeSelection)ActionSection.this.algorithmsViewer.getSelection()).getFirstElement();
                if (selection instanceof Algorithm && (fb = ECActionHelpers.getFBType(ActionSection.this.getType())) != null) {
                    ActionSection.this.executeCommand(new DeleteAlgorithmCommand(fb, (Algorithm)((IStructuredSelection)ActionSection.this.algorithmsViewer.getSelection()).getFirstElement()));
                    ActionSection.this.algorithmsViewer.refresh();
                    ActionSection.this.setAlgorithmDropdown();
                }
            }
        });
    }

    private void createAllAlgorithmViewer(Composite parent) {
        this.algorithmsViewer = new TreeViewer(parent, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        this.algorithmsViewer.getTree().setLayoutData((Object)gridData);
        this.algorithmsViewer.setContentProvider((IContentProvider)new ActionContentProvider());
        this.algorithmsViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.getAdapterFactory()));
        new AdapterFactoryTreeEditor(this.algorithmsViewer.getTree(), (AdapterFactory)this.adapterFactory);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.commandStack = this.getCommandStack(part, input);
        if (this.commandStack == null) {
            this.outputEventCombo.removeAll();
            this.outputEventCombo.setEnabled(false);
            this.algorithmCombo.removeAll();
            this.algorithmCombo.setEnabled(false);
        }
        this.setType(input);
        this.algorithmGroup.initialize(ECActionHelpers.getFBType(this.getType()), this.commandStack);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.setOutputEventDropdown();
            this.outputEventCombo.select(this.getType().getOutput() != null ? this.outputEventCombo.indexOf(this.getType().getOutput().getName()) : this.outputEventCombo.indexOf(""));
            this.setAlgorithmDropdown();
            this.algorithmGroup.setAlgorithm(this.getAlgorithm());
            this.algorithmsViewer.setInput((Object)this.getType());
        }
        this.commandStack = commandStackBuffer;
    }

    private void setOutputEventDropdown() {
        this.outputEventCombo.removeAll();
        this.events.clear();
        for (Event e : ECActionHelpers.getOutputEvents(ECActionHelpers.getFBType(this.getType()))) {
            String name = e.getName();
            this.outputEventCombo.add(name);
            this.events.put(name, e);
        }
        this.outputEventCombo.add(" ");
    }

    private void setAlgorithmDropdown() {
        this.algorithmCombo.removeAll();
        this.algorithmCombo.add("");
        BasicFBType fb = ECActionHelpers.getFBType(this.getType());
        if (fb != null) {
            for (Algorithm alg : fb.getAlgorithm()) {
                this.algorithmCombo.add(alg.getName());
            }
        }
        this.algorithmCombo.select(this.getAlgorithm() == null ? 0 : this.algorithmCombo.indexOf(this.getAlgorithm().getName()));
        this.actionComposite.layout();
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
    }
}

