/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.IAlgorithmEditor;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.IAlgorithmEditorCreator;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.AlgorithmTextChangedCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeAlgorithmTypeCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AbstractECSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.TextAlgorithm;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

class AlgorithmGroup {
    private Group algorithmGroup;
    private CLabel languageLabel;
    private Combo languageCombo;
    private CLabel commentLabel;
    private Text commentText;
    private Composite codeEditors;
    private StackLayout stack;
    private Hashtable<String, IAlgorithmEditor> editors = new Hashtable();
    private IAlgorithmEditor currentAlgEditor;
    private boolean blockUpdates = false;
    private final IDocumentListener listener = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            if (AlgorithmGroup.this.getAlgorithm() != null && AlgorithmGroup.this.currentAlgEditor != null && AlgorithmGroup.this.currentAlgEditor.isDocumentValid()) {
                AlgorithmGroup.this.executeCommand(new AlgorithmTextChangedCommand((TextAlgorithm)AlgorithmGroup.this.getAlgorithm(), AlgorithmGroup.this.currentAlgEditor.getAlgorithmText()));
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    };
    private CommandStack commandStack;
    private Algorithm currentAlgorithm;

    private Algorithm getAlgorithm() {
        return this.currentAlgorithm;
    }

    private BasicFBType getBasicFBType() {
        return (BasicFBType)this.currentAlgorithm.eContainer();
    }

    AlgorithmGroup(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        this.algorithmGroup = widgetFactory.createGroup(parent, Messages.ECAlgorithmGroup_Title);
        GridData algorithmGroupLayoutData = new GridData(4, 4, true, true);
        algorithmGroupLayoutData.horizontalSpan = 2;
        this.algorithmGroup.setLayoutData((Object)algorithmGroupLayoutData);
        this.algorithmGroup.setLayout((Layout)new GridLayout(1, true));
        Composite langAndComents = widgetFactory.createComposite((Composite)this.algorithmGroup);
        langAndComents.setLayout((Layout)new GridLayout(4, false));
        langAndComents.setLayoutData((Object)new GridData(4, 0, true, false));
        this.languageLabel = widgetFactory.createCLabel(langAndComents, "Langugage: ");
        this.languageCombo = new Combo(langAndComents, 12);
        this.fillLanguageDropDown();
        this.languageCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AlgorithmGroup.this.executeCommand(new ChangeAlgorithmTypeCommand(AlgorithmGroup.this.getBasicFBType(), AlgorithmGroup.this.getAlgorithm(), AlgorithmGroup.this.languageCombo.getText()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.commentLabel = widgetFactory.createCLabel(langAndComents, "Comment:");
        this.commentText = widgetFactory.createText(langAndComents, "");
        this.commentText.setEditable(true);
        this.commentText.setEnabled(true);
        this.commentText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.commentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AlgorithmGroup.this.executeCommand((Command)new ChangeCommentCommand((INamedElement)AlgorithmGroup.this.getAlgorithm(), AlgorithmGroup.this.commentText.getText()));
            }
        });
        GridData codeEditorsGridData = new GridData(4, 4, true, true);
        codeEditorsGridData.horizontalSpan = 1;
        codeEditorsGridData.minimumHeight = 250;
        this.codeEditors = widgetFactory.createGroup((Composite)this.algorithmGroup, "");
        this.stack = new StackLayout();
        this.codeEditors.setLayout((Layout)this.stack);
        this.codeEditors.setLayoutData((Object)codeEditorsGridData);
        this.disableAllFields();
    }

    private void executeCommand(Command cmd) {
        if (this.currentAlgorithm != null && this.commandStack != null) {
            this.blockUpdates = true;
            this.commandStack.execute(cmd);
            this.blockUpdates = false;
        }
    }

    void initialize(BasicFBType basicFBType, CommandStack commandStack) {
        this.commandStack = commandStack;
        this.loadEditors(basicFBType);
    }

    private void loadEditors(BasicFBType basicFBType) {
        IExtension[] extensions;
        this.editors.clear();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.fordiac.ide.fbtypeeditor.ecc.algorithmEditor");
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                Object obj = null;
                try {
                    obj = element.createExecutableExtension("class");
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
                if (obj instanceof IAlgorithmEditorCreator) {
                    IAlgorithmEditor editor = ((IAlgorithmEditorCreator)obj).createAlgorithmEditor(this.codeEditors, basicFBType);
                    String lang = element.getAttribute("language");
                    this.editors.put(lang, editor);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void setAlgorithm(Algorithm algorithm) {
        if (!this.blockUpdates) {
            CommandStack commandStackBuffer = this.commandStack;
            this.commandStack = null;
            if (this.currentAlgorithm != algorithm) {
                this.currentAlgorithm = algorithm;
                if (this.currentAlgorithm != null) {
                    this.initializeEditor();
                    this.enableAllFields();
                    this.updateAlgFields();
                } else {
                    this.algorithmGroup.setText(Messages.ECAlgorithmGroup_Title);
                    this.commentText.setText("");
                    this.languageCombo.select(0);
                    this.stack.topControl = null;
                    this.codeEditors.layout();
                    this.disableAllFields();
                }
            } else if (this.currentAlgorithm != null) {
                this.updateAlgFields();
            }
            this.commandStack = commandStackBuffer;
        }
    }

    private void enableAllFields() {
        this.languageLabel.setEnabled(true);
        this.algorithmGroup.setEnabled(true);
        this.commentLabel.setEnabled(true);
        this.commentText.setEnabled(true);
        this.languageCombo.setEnabled(true);
    }

    private void disableAllFields() {
        this.languageLabel.setEnabled(false);
        this.algorithmGroup.setEnabled(false);
        this.commentLabel.setEnabled(false);
        this.commentText.setEnabled(false);
        this.languageCombo.setEnabled(false);
    }

    private void updateAlgFields() {
        this.algorithmGroup.setText(String.valueOf(Messages.ECAlgorithmGroup_Title) + " " + this.currentAlgorithm.getName());
        this.commentText.setText(this.getAlgorithm().getComment());
        this.languageCombo.select(this.languageCombo.indexOf(this.getAlgorithmTypeString(this.getAlgorithm())));
        if (this.currentAlgEditor != null) {
            this.currentAlgEditor.setAlgorithmText(((TextAlgorithm)this.getAlgorithm()).getText());
        }
    }

    private void initializeEditor() {
        if (this.currentAlgEditor != null) {
            this.currentAlgEditor.removeDocumentListener(this.listener);
        }
        String algType = this.getAlgorithmTypeString(this.getAlgorithm());
        this.currentAlgEditor = this.editors.get(algType);
        if (this.currentAlgEditor != null) {
            this.stack.topControl = this.currentAlgEditor.getControl();
            this.currentAlgEditor.addDocumentListener(this.listener);
        }
        this.codeEditors.layout();
    }

    private String getAlgorithmTypeString(Algorithm algorithm) {
        if (algorithm instanceof STAlgorithm) {
            return "ST";
        }
        if (algorithm instanceof TextAlgorithm) {
            return "AnyText";
        }
        return "AnyText";
    }

    private void fillLanguageDropDown() {
        this.languageCombo.removeAll();
        for (String alg : AbstractECSection.getLanguages()) {
            this.languageCombo.add(alg);
        }
    }
}

