/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtest.automatedRemoteTest;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.automatedRemoteTest.ART_DeploymentMgr;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.automatedRemoteTest.ART_TCPClient;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.util.DataVariable;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.util.Event;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.util.FBTHelper;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.util.TestPrimitive;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.util.TestSequence;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.util.TestTransaction;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.util.comm.datatypes.IECDataTypeFactory;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_UINT;
import org.eclipse.fordiac.ide.util.comm.exceptions.CommException;

public class AutomatedRemoteTest {
    FBType fbType;
    String fbInterface = "";
    String MgrID;
    List<IEC_ANY> sendList = new ArrayList<IEC_ANY>();
    List<IEC_ANY> recvListTemplate = new ArrayList<IEC_ANY>();
    List<List<IEC_ANY>> recvList = new ArrayList<List<IEC_ANY>>();
    Hashtable<String, Integer> InputEventTable = new Hashtable();
    Hashtable<String, Integer> OutputEventTable = new Hashtable();
    int nNumberOfInputEvents = 0;
    int nNumberOfOutputEvents = 0;
    Hashtable<String, Integer> InputVarsTable = new Hashtable();
    Hashtable<String, Integer> OutputVarsTable = new Hashtable();
    List<TestSequence> Tests = null;
    ART_TCPClient TCPTestInterface;
    ART_DeploymentMgr DMgr;
    public String DMgr_response = "";

    public boolean prepareART(FBType fbType, List<TestSequence> paTestSequences) {
        this.fbType = fbType;
        this.sendList.clear();
        this.recvList.clear();
        this.recvList.clear();
        this.InputEventTable.clear();
        this.OutputEventTable.clear();
        this.InputVarsTable.clear();
        this.OutputVarsTable.clear();
        this.Tests = null;
        boolean retval = this.prepareInterface() && this.prepareTestCases(paTestSequences);
        return retval;
    }

    private boolean prepareTestCases(List<TestSequence> paTestSequences) {
        this.Tests = paTestSequences;
        return true;
    }

    private boolean prepareInterface() {
        IEC_ANY newVar;
        this.fbInterface = "";
        IEC_UINT InputEventID = new IEC_UINT();
        IEC_UINT OutputEventID = new IEC_UINT();
        try {
            this.nNumberOfInputEvents = this.fbType.getInterfaceList().getEventInputs().size();
            this.nNumberOfOutputEvents = this.fbType.getInterfaceList().getEventOutputs().size();
        }
        catch (Exception exception) {
            return false;
        }
        if (this.nNumberOfInputEvents == 0 || this.nNumberOfOutputEvents == 0) {
            return false;
        }
        this.fbInterface = String.valueOf(this.fbInterface) + "EventInputs\n";
        for (org.eclipse.fordiac.ide.model.libraryElement.Event entry : this.fbType.getInterfaceList().getEventInputs()) {
            this.fbInterface = String.valueOf(this.fbInterface) + "\t" + entry.getName() + " (" + this.fbType.getInterfaceList().getEventInputs().indexOf((Object)entry) + ")\n";
        }
        this.sendList.add((IEC_ANY)InputEventID);
        if (this.fbType.getInterfaceList().getInputVars().size() > 0) {
            this.fbInterface = String.valueOf(this.fbInterface) + "DataInputs\n";
            for (org.eclipse.fordiac.ide.model.libraryElement.Event entry : this.fbType.getInterfaceList().getInputVars()) {
                this.fbInterface = String.valueOf(this.fbInterface) + "\t" + entry.getName() + " (" + this.fbType.getInterfaceList().getInputVars().indexOf((Object)entry) + ")" + " -\t" + entry.getType().getName() + "\n";
                newVar = IECDataTypeFactory.getIECTypeByTypename((String)entry.getType().getName());
                this.sendList.add(newVar);
                this.InputVarsTable.put(entry.getName(), 1 + FBTHelper.getDIID(this.fbType, entry.getName()));
            }
        }
        this.fbInterface = String.valueOf(this.fbInterface) + "EventOutputs\n";
        for (org.eclipse.fordiac.ide.model.libraryElement.Event entry : this.fbType.getInterfaceList().getEventOutputs()) {
            this.fbInterface = String.valueOf(this.fbInterface) + "\t" + entry.getName() + " (" + this.fbType.getInterfaceList().getEventOutputs().indexOf((Object)entry) + ")\n";
        }
        this.recvListTemplate.add((IEC_ANY)OutputEventID);
        if (this.fbType.getInterfaceList().getOutputVars().size() > 0) {
            this.fbInterface = String.valueOf(this.fbInterface) + "DataOutputs\n";
            for (org.eclipse.fordiac.ide.model.libraryElement.Event entry : this.fbType.getInterfaceList().getOutputVars()) {
                this.fbInterface = String.valueOf(this.fbInterface) + "\t" + entry.getName() + " (" + this.fbType.getInterfaceList().getOutputVars().indexOf((Object)entry) + ")" + " -\t" + entry.getType().getName() + "\n";
                newVar = IECDataTypeFactory.getIECTypeByTypename((String)entry.getType().getName());
                this.recvListTemplate.add(newVar);
                this.OutputVarsTable.put(entry.getName(), 1 + FBTHelper.getDOID(this.fbType, entry.getName()));
            }
        }
        return true;
    }

    public boolean deployTestRes(String TestChanID, int paID) {
        this.DMgr = new ART_DeploymentMgr(this.fbType, this.MgrID, paID);
        boolean isOK = this.DMgr.deploy(TestChanID);
        if (!isOK) {
            this.DMgr_response = this.DMgr.MgmtCommands;
        }
        return isOK;
    }

    public boolean configureCommunication(String paCommID) {
        int ReplySize = FBTHelper.getMaxOutputPrimitives(this.Tests);
        this.recvList.clear();
        int i = 0;
        while (i < ReplySize + 1) {
            ArrayList<IEC_ANY> tempArray = new ArrayList<IEC_ANY>();
            for (IEC_ANY Var : this.recvListTemplate) {
                tempArray.add((IEC_ANY)Var.clone());
            }
            this.recvList.add(tempArray);
            ++i;
        }
        try {
            this.TCPTestInterface = new ART_TCPClient(paCommID, this.recvList, ReplySize + 1);
        }
        catch (CommException commException) {
            return false;
        }
        return true;
    }

    public boolean runTests() {
        if (this.Tests == null) {
            return false;
        }
        boolean retval = true;
        for (TestSequence testSequence : this.Tests) {
            if (!this.runSingleTestsequence(testSequence)) {
                testSequence.setSuccess(false);
                testSequence.getRelatedModelElement().setTestResult(-1);
                retval = false;
                continue;
            }
            testSequence.setSuccess(true);
            testSequence.getRelatedModelElement().setTestResult(1);
        }
        return retval;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean runSingleTestsequence(TestSequence paTS) {
        if (paTS != null && paTS.getTestTransactions() != null && paTS.getTestTransactions().size() > 0) {
            for (TestTransaction TT : paTS.getTestTransactions()) {
                block26: {
                    TestPrimitive TP = TT.getInputPrimitive();
                    Event TE = TP.getEvent();
                    IEC_ANY EventVar = this.sendList.get(0);
                    EventVar.setValue(Integer.toString(TE.getEventID()));
                    if (TP.getData() != null && TP.getData().size() > 0) {
                        for (DataVariable DV : TP.getData()) {
                            Integer index = this.InputVarsTable.get(DV.getDataName());
                            IEC_ANY Var = this.sendList.get(index);
                            Var.setValue(DV.getDataValue());
                        }
                    }
                    try {
                        int SLcounter = -1;
                        for (IEC_ANY SL_Var : this.sendList) {
                            if (SLcounter == -1) {
                                TT.setInputMessage("Sent Event: " + FBTHelper.getEINameByIndex(this.fbType, TE.getEventID()) + "\n");
                            } else {
                                TT.setInputMessage(String.valueOf(TT.getInputMessage()) + " " + FBTHelper.getDINameByIndex(this.fbType, SLcounter) + " := " + SL_Var.toString() + "\n");
                            }
                            ++SLcounter;
                        }
                        this.TCPTestInterface.SendIECData(this.sendList);
                    }
                    catch (CommException e) {
                        Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                    }
                    int expectedCount = 0;
                    if (TT.getOutputPrimitives() != null) {
                        expectedCount = TT.getOutputPrimitives().size();
                    }
                    try {
                        if (expectedCount > 0) {
                            int cancelCondition = 0;
                            while (expectedCount > this.TCPTestInterface.getCounter()) {
                                Thread.sleep(100L);
                                if (++cancelCondition <= 100) continue;
                                TT.setSuccess(false);
                                TT.getRelatedModelElement().setTestResult(-1);
                                return false;
                            }
                            List<List<IEC_ANY>> receivedDataList = this.TCPTestInterface.getReceiveDataList();
                            TT.setSuccess(true);
                            TT.getRelatedModelElement().setTestResult(1);
                            TT.setFailMessage("");
                            int j = 0;
                            while (j < expectedCount) {
                                List<IEC_ANY> OPreceiveData = receivedDataList.get(j);
                                if (TT.getOutputPrimitives().size() > 0 && TT.getOutputPrimitives().get(j) != null) {
                                    OutputPrimitive tempOP = TT.getOutputPrimitives().get(j).getRelatedOutputPrimitive();
                                    int expectedEventID = FBTHelper.getEOID(this.fbType, TT.getOutputPrimitives().get(j).getEvent().getEventName());
                                    IEC_ANY receivedEventID = OPreceiveData.get(0);
                                    if (receivedEventID instanceof IEC_UINT) {
                                        if (((IEC_UINT)receivedEventID).getValue() == expectedEventID) {
                                            TT.setSuccess(true);
                                            TT.getRelatedModelElement().setTestResult(1);
                                            tempOP.setTestResult(1);
                                            TT.setFailMessage(String.valueOf(TT.getFailMessage()) + "Received Event " + FBTHelper.getEONameByIndex(this.fbType, ((IEC_UINT)receivedEventID).getValue()) + " (correct)\n");
                                        } else {
                                            TT.setSuccess(false);
                                            TT.getRelatedModelElement().setTestResult(-1);
                                            tempOP.setTestResult(-1);
                                            TT.setFailMessage(String.valueOf(TT.getFailMessage()) + "Expected Event " + FBTHelper.getEONameByIndex(this.fbType, expectedEventID) + " but received Event " + FBTHelper.getEONameByIndex(this.fbType, ((IEC_UINT)receivedEventID).getValue()) + "\n");
                                        }
                                    }
                                    if (TT.getOutputPrimitives().get(j).getData() != null) {
                                        for (DataVariable DV : TT.getOutputPrimitives().get(j).getData()) {
                                            Integer index = this.OutputVarsTable.get(DV.getDataName());
                                            IEC_ANY Var = OPreceiveData.get(index);
                                            IEC_ANY CheckVar = this.recvListTemplate.get(index);
                                            CheckVar.setValue(DV.getDataValue());
                                            if (!Var.toString().equals(CheckVar.toString())) {
                                                TT.setFailMessage(String.valueOf(TT.getFailMessage()) + "  " + DV.getDataName() + " = " + Var.toString() + " (expected: " + CheckVar.toString() + ")\n");
                                                TT.setSuccess(false);
                                                TT.getRelatedModelElement().setTestResult(-1);
                                                tempOP.setTestResult(-1);
                                                continue;
                                            }
                                            TT.setFailMessage(String.valueOf(TT.getFailMessage()) + "  " + DV.getDataName() + " = " + Var.toString() + " (correct)\n");
                                        }
                                    }
                                }
                                ++j;
                            }
                            break block26;
                        }
                        Thread.sleep(2000L);
                        TT.setSuccess(this.TCPTestInterface.getCounter() == 0);
                        if (TT.isSuccess()) {
                            TT.setFailMessage("No Event received (correct)\n");
                            TT.getRelatedModelElement().setTestResult(1);
                            break block26;
                        }
                        TT.getRelatedModelElement().setTestResult(-1);
                        try {
                            IEC_ANY Event_ID_received = this.TCPTestInterface.getReceiveDataList().get(0).get(0);
                            if (Event_ID_received instanceof IEC_UINT) {
                                TT.setFailMessage("Received Event " + FBTHelper.getEONameByIndex(this.fbType, ((IEC_UINT)Event_ID_received).getValue()) + " (unexpected)\n");
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (InterruptedException e) {
                        Activator.getDefault().logError(e.getMessage(), e);
                    }
                }
                if (TT.isSuccess()) continue;
                return false;
            }
        }
        return true;
    }

    public void stopCommunication() {
        try {
            this.TCPTestInterface.deRegister();
        }
        catch (CommException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    public String evaluateTestResults(List<TestSequence> testSequences, boolean DisplayAll) {
        String LineSeparator = "********************************************************************************\n";
        String retval = "";
        retval = String.valueOf(retval) + LineSeparator;
        retval = String.valueOf(retval) + LineSeparator;
        retval = String.valueOf(retval) + " Test-Results for: " + this.fbType.getName() + "  \t";
        Calendar currentDate = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        String dateNow = formatter.format(currentDate.getTime());
        retval = String.valueOf(retval) + "  " + dateNow + "\n";
        retval = String.valueOf(retval) + LineSeparator;
        if (DisplayAll) {
            retval = String.valueOf(retval) + this.fbInterface;
            retval = String.valueOf(retval) + LineSeparator;
        }
        for (TestSequence ts : testSequences) {
            retval = String.valueOf(retval) + " Test-Sequence \"" + ts.getName() + "\"";
            if (!ts.isSuccess()) {
                retval = String.valueOf(retval) + " not";
            }
            retval = String.valueOf(retval) + " successful\n";
            retval = String.valueOf(retval) + LineSeparator;
            int count_all = 0;
            int count_ok = 0;
            boolean displayedFailMsg = false;
            for (TestTransaction tt : ts.getTestTransactions()) {
                ++count_all;
                if (tt.isSuccess()) {
                    ++count_ok;
                    if (!DisplayAll) continue;
                    retval = String.valueOf(retval) + "TestTransaction " + count_all + " success\n";
                    retval = String.valueOf(retval) + tt.getInputMessage();
                    retval = String.valueOf(retval) + "\n";
                    retval = String.valueOf(retval) + tt.getFailMessage();
                    retval = String.valueOf(retval) + "\n";
                    retval = String.valueOf(retval) + LineSeparator;
                    continue;
                }
                if (displayedFailMsg) continue;
                retval = String.valueOf(retval) + "TestTransaction " + count_all + " failed\n";
                retval = String.valueOf(retval) + tt.getInputMessage();
                retval = String.valueOf(retval) + "\n";
                retval = String.valueOf(retval) + tt.getFailMessage();
                retval = String.valueOf(retval) + "\n";
                retval = String.valueOf(retval) + LineSeparator;
                displayedFailMsg = true;
            }
            retval = String.valueOf(retval) + "\n";
            retval = String.valueOf(retval) + count_ok + " of " + count_all + " TestTransactions successful\n";
            retval = String.valueOf(retval) + LineSeparator;
        }
        System.out.print(retval);
        return retval;
    }

    public void cleanRes() {
        this.DMgr.cleanRes();
    }
}

