/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands;

import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.gef.commands.Command;

public class CreateOutputPrimitiveCommand
extends Command {
    private final String type;
    private final ServiceTransaction parent;
    private final OutputPrimitive refElement;
    private OutputPrimitive newElement;

    public CreateOutputPrimitiveCommand(String type, ServiceTransaction element, OutputPrimitive refElement) {
        this.type = type;
        this.parent = element;
        this.refElement = refElement;
    }

    public boolean canExecute() {
        return this.type != null && this.parent != null;
    }

    public void execute() {
        Service service = (Service)this.parent.eContainer().eContainer();
        this.newElement = LibraryElementFactory.eINSTANCE.createOutputPrimitive();
        this.newElement.setEvent("INITO");
        if (this.type.equals("LeftOutputPrimitive")) {
            this.newElement.setInterface(service.getLeftInterface());
        } else if (this.type.equals("RightOutputPrimitive")) {
            this.newElement.setInterface(service.getRightInterface());
        }
        if (this.refElement == null) {
            this.parent.getOutputPrimitive().add((Object)this.newElement);
        } else {
            int index = this.parent.getOutputPrimitive().indexOf((Object)this.refElement);
            this.parent.getOutputPrimitive().add(index, (Object)this.newElement);
        }
    }

    public void undo() {
        this.parent.getOutputPrimitive().remove((Object)this.newElement);
    }

    public void redo() {
        if (this.refElement == null) {
            this.parent.getOutputPrimitive().add((Object)this.newElement);
        } else {
            int index = this.parent.getOutputPrimitive().indexOf((Object)this.refElement);
            this.parent.getOutputPrimitive().add(index, (Object)this.newElement);
        }
    }
}

