/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtester.configuration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.fordiac.ide.fbtester.model.testdata.ValuedVarDecl;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.IFBTestConfiguration;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.IFBTestConfiguratonCreator;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.TestingManager;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.configuration.internal.Utils;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model.TestElement;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.monitoring.communication.Messages;
import org.eclipse.fordiac.ide.monitoring.communication.MonitoringCommunicationOptions;
import org.eclipse.fordiac.ide.monitoring.monCom.Data;
import org.eclipse.fordiac.ide.monitoring.monCom.FB;
import org.eclipse.fordiac.ide.monitoring.monCom.Port;
import org.eclipse.fordiac.ide.monitoring.monCom.Resource;
import org.eclipse.fordiac.ide.monitoring.monCom.Response;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.xml.sax.InputSource;

public class FORTERemoteTester
implements IFBTestConfiguratonCreator {
    private static final String LAST_IP = "lastIp";
    private static final String FORTE_REMOTE_TESTER_SETTINGS = "FORTE_REMOTE_TESTER_SETTINGS";
    private Button run;
    private FBType type;
    private boolean running;
    private Socket socket;
    private IDialogSettings forteRemoteTesterSettings;
    private Text ipText;
    private Text runTimePortText;
    private MonitoringCommunicationOptions data = new MonitoringCommunicationOptions();
    private Map<String, TestElement> testElements;

    public FORTERemoteTester() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.forteRemoteTesterSettings = settings.getSection(FORTE_REMOTE_TESTER_SETTINGS);
        if (this.forteRemoteTesterSettings == null) {
            this.forteRemoteTesterSettings = settings.addNewSection(FORTE_REMOTE_TESTER_SETTINGS);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
        if (running) {
            this.run.setText("Stop Testing FB");
            this.run.setImage(FordiacImage.ICON_Stop.getImage());
        } else {
            this.run.setText("Start Testing FB");
            this.run.setImage(FordiacImage.ICON_Start.getImage());
        }
    }

    @Override
    public IFBTestConfiguration createConfigurationPage(Composite parent) {
        final Composite main = new Composite(parent, 0);
        GridLayout gl = new GridLayout(6, false);
        main.setLayout((Layout)gl);
        Label ipLabel = new Label(main, 0);
        ipLabel.setText("IP-Address:");
        this.ipText = new Text(main, 2048);
        this.ipText.setText("127.0.0.1");
        Label runTimeLabel = new Label(main, 0);
        runTimeLabel.setText("Runtime port:");
        this.runTimePortText = new Text(main, 2048);
        this.runTimePortText.setText("61499");
        this.run = new Button(main, 2);
        this.run.setEnabled(true);
        this.setRunning(false);
        this.run.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int runtimePort = Integer.parseInt(FORTERemoteTester.this.runTimePortText.getText());
                if (FORTERemoteTester.this.run.getSelection()) {
                    String ipAddress = FORTERemoteTester.this.ipText.getText();
                    FORTERemoteTester.this.forteRemoteTesterSettings.put(FORTERemoteTester.LAST_IP, ipAddress);
                    String response = Utils.deployNetwork(FORTERemoteTester.this.type, FORTERemoteTester.this.ipText.getText(), runtimePort);
                    if (response != null) {
                        MessageBox msb = new MessageBox(Display.getCurrent().getActiveShell(), 1);
                        msb.setMessage("FB can not be tested because of the following error: \n" + response);
                        msb.open();
                        FORTERemoteTester.this.setRunning(false);
                        FORTERemoteTester.this.run.setSelection(false);
                        return;
                    }
                    int thread = 0;
                    try {
                        FORTERemoteTester.this.socket = new Socket(InetAddress.getByName(ipAddress), runtimePort);
                        FORTERemoteTester.this.socket.setSoTimeout(500);
                        FORTERemoteTester.this.addWatches("_" + FORTERemoteTester.this.type.getName());
                        FORTERemoteTester.this.setRunning(true);
                        Thread t = new Thread(new TriggerRequestRunnable(FORTERemoteTester.this.socket, thread));
                        t.start();
                        Thread.sleep(500L);
                    }
                    catch (UnknownHostException e1) {
                        Activator.getDefault().logError(e1.getMessage(), e1);
                    }
                    catch (IOException e1) {
                        Activator.getDefault().logError(e1.getMessage(), e1);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("Thread Interrupted");
                    }
                } else {
                    FORTERemoteTester.this.setRunning(false);
                    String response = Utils.cleanNetwork(FORTERemoteTester.this.type, FORTERemoteTester.this.ipText.getText(), runtimePort, FORTERemoteTester.this.socket);
                    if (response != null) {
                        MessageBox msb = new MessageBox(Display.getCurrent().getActiveShell(), 1);
                        msb.setMessage("FB can not be cleaned because of the following error: \n" + response);
                        msb.open();
                    }
                    try {
                        FORTERemoteTester.this.socket.close();
                        FORTERemoteTester.this.socket = null;
                    }
                    catch (IOException e1) {
                        Activator.getDefault().logError(e1.getMessage(), e1);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        IFBTestConfiguration configuration = new IFBTestConfiguration(){

            @Override
            public Control getControl() {
                return main;
            }

            @Override
            public void newTestConf(List<TestElement> variables, List<String> values, List<ValuedVarDecl> resultVars, Map<String, Object> params) {
            }
        };
        this.loadLastIp();
        return configuration;
    }

    private void loadLastIp() {
        String lastIp;
        if (this.forteRemoteTesterSettings != null && (lastIp = this.forteRemoteTesterSettings.get(LAST_IP)) != null) {
            this.ipText.setText(lastIp);
            this.run.setEnabled(true);
        }
    }

    private void addWatches(String fbName) {
        this.testElements = TestingManager.getInstance().getTestElements(this.type, this, this);
        for (TestElement element : this.testElements.values()) {
            if (element.getFBString().equals(fbName)) {
                DataOutputStream outputStream = null;
                DataInputStream inputStream = null;
                try {
                    outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                    inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                    if (element.getInterfaceElement() instanceof VarDeclaration) {
                        this.addWatch(element, outputStream, inputStream);
                    }
                    if (!(element.getInterfaceElement() instanceof Event) || element.getInterfaceElement().isIsInput()) continue;
                    this.addWatch(element, outputStream, inputStream);
                }
                catch (IOException e1) {
                    Activator.getDefault().logError(e1.getMessage(), e1);
                }
                continue;
            }
            System.out.println("element: " + element.getFBString() + " skipped");
        }
    }

    private void addWatch(TestElement element, DataOutputStream outputStream, DataInputStream inputStream) {
        if (outputStream != null && inputStream != null) {
            String request = MessageFormat.format(Messages.TCPCommunicationObject_Monitoring_ADD_Watch, 0, String.valueOf(element.getFBString()) + "." + element.getPortString(), "*");
            this.sendRequest(SendType.addWatch, element.getResourceString(), request, outputStream, inputStream);
        }
    }

    private synchronized void sendRequest(SendType type, String destination, String request, DataOutputStream outputStream, DataInputStream inputStream) {
        try {
            if (this.socket.isConnected()) {
                outputStream.writeByte(80);
                outputStream.writeShort(destination.length());
                outputStream.writeBytes(destination);
                outputStream.writeByte(80);
                outputStream.writeShort(request.length());
                outputStream.writeBytes(request);
                outputStream.flush();
                if (type.equals((Object)SendType.REQ)) {
                    String response = FORTERemoteTester.parseResponse(inputStream);
                    if (!response.equals("")) {
                        XMLResourceImpl resource = new XMLResourceImpl();
                        InputSource source = new InputSource(new StringReader(response));
                        resource.load(source, this.data.getLoadOptions());
                        for (EObject object : resource.getContents()) {
                            Response resp;
                            if (!(object instanceof Response) || (resp = (Response)object).getWatches() == null) continue;
                            for (Resource res : resp.getWatches().getResources()) {
                                for (FB fb : res.getFbs()) {
                                    for (Port p : fb.getPorts()) {
                                        for (Data d : p.getDataValues()) {
                                            TestElement element = this.testElements.get(String.valueOf(res.getName()) + "." + fb.getName() + "." + p.getName());
                                            if (element == null) continue;
                                            element.updateValue(d.getValue(), 0);
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else if (type.equals((Object)SendType.addWatch)) {
                    inputStream.available();
                    inputStream.read();
                } else if (!type.equals((Object)SendType.triggerEvent) && !type.equals((Object)SendType.removeWatch) && !type.equals((Object)SendType.startEventCnt) && type.equals((Object)SendType.forceValue)) {
                    String forceResp = FORTERemoteTester.parseResponse(inputStream);
                    System.out.println("force response: " + forceResp);
                }
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    private static String parseResponse(DataInputStream inputStream) throws IOException {
        StringBuilder response = new StringBuilder();
        inputStream.readByte();
        int size = inputStream.readShort();
        int i = 0;
        while (i < size) {
            response.append((char)inputStream.readByte());
            ++i;
        }
        return response.toString();
    }

    public void setValue(TestElement element) {
        if (this.isRunning()) {
            DataOutputStream outputStream = null;
            DataInputStream inputStream = null;
            try {
                outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                String request = MessageFormat.format(Messages.TCPCommunicationObject_Monitoring_Force_Value, 0, element.getValue(), String.valueOf(element.getFBString()) + "." + element.getPortString(), "true");
                this.sendRequest(SendType.forceValue, element.getResourceString(), request, outputStream, inputStream);
            }
            catch (IOException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void sendEvent(TestElement element) {
        if (this.isRunning()) {
            DataOutputStream outputStream = null;
            DataInputStream inputStream = null;
            try {
                outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                if (element != null) {
                    String request = MessageFormat.format(Messages.TCPCommunicationObject_WriteParameter, 0, "$e", String.valueOf(element.getFBString()) + "." + element.getPortString());
                    this.sendRequest(SendType.triggerEvent, element.getResourceString(), request, outputStream, inputStream);
                }
            }
            catch (IOException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void setType(FBType type) {
        this.type = type;
    }

    @Override
    public void setValue(TestElement element, String value) {
        this.setValue(element);
    }

    @Override
    public void setGroup(PaletteGroup group) {
    }

    private static enum SendType {
        REQ,
        addWatch,
        removeWatch,
        triggerEvent,
        startEventCnt,
        forceValue;

    }

    class TriggerRequestRunnable
    implements Runnable {
        private final Socket socket;
        int i = 0;

        public TriggerRequestRunnable(Socket socket, int thread) {
            this.socket = socket;
        }

        @Override
        public void run() {
            DataOutputStream outputStream = null;
            DataInputStream inputStream = null;
            try {
                outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            }
            catch (IOException iOException) {
                FORTERemoteTester.this.setRunning(false);
            }
            while (FORTERemoteTester.this.running) {
                ++this.i;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    FORTERemoteTester.this.setRunning(false);
                }
                String request = MessageFormat.format(Messages.TCPCommunicationObject_Monitoring_Read_Watches, this.i);
                if (!FORTERemoteTester.this.running) continue;
                FORTERemoteTester.this.sendRequest(SendType.REQ, "", request, outputStream, inputStream);
            }
        }
    }
}

