/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.actions;

import java.util.List;
import org.eclipse.fordiac.ide.model.libraryElement.I4DIACElement;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.actions.Open4DIACElementAction;
import org.eclipse.fordiac.ide.util.IOpenListener;
import org.eclipse.fordiac.ide.util.OpenListenerManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class Open4DIACElementActionProvider
extends CommonActionProvider {
    private Open4DIACElementAction openAction;
    private ICommonViewerWorkbenchSite viewSite = null;
    private boolean contribute = false;

    public void init(ICommonActionExtensionSite aConfig) {
        if (aConfig.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.viewSite = (ICommonViewerWorkbenchSite)aConfig.getViewSite();
            this.openAction = new Open4DIACElementAction(this.viewSite.getPart());
            this.contribute = true;
        }
    }

    public void fillContextMenu(IMenuManager aMenu) {
        if (!this.contribute || this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.openAction.selectionChanged(selection);
        if (this.openAction.isEnabled()) {
            aMenu.insertAfter("group.open", (IAction)this.openAction);
        }
        this.addOpenWithMenu(aMenu);
    }

    public void fillActionBars(IActionBars theActionBars) {
        if (!this.contribute) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.size() == 1) {
            this.openAction.selectionChanged(selection);
            theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        }
    }

    private void addOpenWithMenu(IMenuManager aMenu) {
        IStructuredSelection ss = (IStructuredSelection)this.getContext().getSelection();
        if (ss == null || ss.size() != 1) {
            return;
        }
        Object obj = ss.getFirstElement();
        List listeners = OpenListenerManager.INSTANCE.getOpenListener((I4DIACElement)obj);
        if (!listeners.isEmpty()) {
            MenuManager submenu = new MenuManager(Messages.OpenEditorProvider_OpenWithMenu_label, "group.openWith");
            submenu.add((IContributionItem)new GroupMarker("group.top"));
            for (IOpenListener openListener : listeners) {
                submenu.add((IAction)openListener.getOpenListenerAction());
            }
            submenu.add((IContributionItem)new GroupMarker("additions"));
            if (submenu.getItems().length > 2 && submenu.isEnabled()) {
                aMenu.appendToGroup("group.openWith", (IContributionItem)submenu);
            }
        }
    }
}

