/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.AbstractInterfaceElementEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.CommentTypeEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.CommentTypeField;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.FBTypeRootEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.InputWithAnchor;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.OutputWithAnchor;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.WithEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.policies.DeleteInterfaceEditPolicy;
import org.eclipse.fordiac.ide.fbtypeeditor.policies.WithNodeEditPolicy;
import org.eclipse.fordiac.ide.gef.draw2d.ConnectorBorder;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.gef.editparts.NameCellEditorLocator;
import org.eclipse.fordiac.ide.gef.figures.InteractionStyleFigure;
import org.eclipse.fordiac.ide.gef.policies.INamedElementRenameEditPolicy;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;

public class InterfaceEditPart
extends AbstractInterfaceElementEditPart
implements NodeEditPart {
    public InterfaceEditPart() {
        this.setConnectable(true);
    }

    protected IFigure createFigure() {
        InterfaceFigure fig = new InterfaceFigure();
        fig.addAncestorListener(new AncestorListener(){

            public void ancestorRemoved(IFigure ancestor) {
            }

            public void ancestorMoved(IFigure ancestor) {
                InterfaceEditPart.this.update();
            }

            public void ancestorAdded(IFigure ancestor) {
                InterfaceEditPart.this.update();
            }
        });
        return fig;
    }

    @Override
    protected void update() {
        EditPart parent = this.getParent();
        while (parent != null && !(parent instanceof FBTypeRootEditPart)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            FBTypeRootEditPart fbcep = (FBTypeRootEditPart)parent;
            CommentTypeField commentField = fbcep.getCommentField(this.getCastedModel());
            InterfaceList interfaceList = (InterfaceList)this.getCastedModel().eContainer();
            if (interfaceList == null) {
                return;
            }
            int nrOfInputEvents = interfaceList.getEventInputs().size();
            int nrOfOutputEvents = interfaceList.getEventOutputs().size();
            if (commentField != null) {
                Object o = this.getViewer().getEditPartRegistry().get(commentField);
                String label = commentField.getLabel();
                int x = 0;
                Rectangle bounds = this.getFigure().getBounds();
                if (o instanceof CommentTypeEditPart) {
                    x = this.isInput() ? bounds.x - 15 - FigureUtilities.getTextWidth((String)label, (Font)this.getNameLabel().getFont()) - nrOfInputEvents * 10 : bounds.x + bounds.width + 15 + nrOfOutputEvents * 10;
                    ((CommentTypeEditPart)((Object)o)).getFigure().setLocation(new Point(x, bounds.y));
                    ((CommentTypeEditPart)((Object)o)).getFigure().setSize(FigureUtilities.getTextWidth((String)label, (Font)this.getNameLabel().getFont()), bounds.height);
                }
            }
        }
        this.updateWiths();
    }

    @Override
    public IInterfaceElement getCastedModel() {
        return (IInterfaceElement)this.getModel();
    }

    public void setInOutConnectionsWith(int with) {
        for (ConnectionEditPart cep : this.getSourceConnections()) {
            if (!(cep.getFigure() instanceof PolylineConnection)) continue;
            ((PolylineConnection)cep.getFigure()).setLineWidth(with);
        }
        for (ConnectionEditPart cep : this.getTargetConnections()) {
            if (!(cep.getFigure() instanceof PolylineConnection)) continue;
            ((PolylineConnection)cep.getFigure()).setLineWidth(with);
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new INamedElementRenameEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                if (this.getHost() instanceof AbstractDirectEditableEditPart) {
                    ChangeNameCommand cmd = new ChangeNameCommand((INamedElement)InterfaceEditPart.this.getCastedModel(), (String)request.getCellEditor().getValue());
                    return cmd;
                }
                return null;
            }
        });
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteInterfaceEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", new WithNodeEditPolicy());
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            request.setType((Object)"direct edit");
        }
        super.performRequest(request);
    }

    protected List<With> getModelSourceConnections() {
        if (this.isEvent()) {
            return ((Event)this.getModel()).getWith();
        }
        return Collections.emptyList();
    }

    protected List<With> getModelTargetConnections() {
        if (this.isVariable()) {
            return ((VarDeclaration)this.getModel()).getWiths();
        }
        return Collections.emptyList();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        int pos = 1;
        if (this.isInput()) {
            pos = this.calculateInputWithPos(connection);
            return new InputWithAnchor(this.getFigure(), pos, (EditPart)this);
        }
        pos = this.calculateOutputWithPos(connection);
        return new OutputWithAnchor(this.getFigure(), pos, (EditPart)this);
    }

    private int calculateOutputWithPos(ConnectionEditPart connection) {
        With with = (With)connection.getModel();
        Event event = (Event)with.eContainer();
        InterfaceList interfaceList = (InterfaceList)event.eContainer();
        int pos = interfaceList.getEventOutputs().indexOf((Object)event) + 1;
        return pos;
    }

    private int calculateInputWithPos(ConnectionEditPart connection) {
        With with = (With)connection.getModel();
        Event event = (Event)with.eContainer();
        InterfaceList interfaceList = (InterfaceList)event.eContainer();
        int pos = interfaceList.getEventInputs().indexOf((Object)event) + 1;
        return pos;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        int pos = 1;
        if (this.isInput()) {
            pos = this.calculateInputWithPos(connection);
            return new InputWithAnchor(this.getFigure(), pos, (EditPart)this);
        }
        pos = this.calculateOutputWithPos(connection);
        return new OutputWithAnchor(this.getFigure(), pos, (EditPart)this);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public Label getNameLabel() {
        return (Label)this.getFigure();
    }

    public INamedElement getINamedElement() {
        return this.getCastedModel();
    }

    private void updateWiths() {
        if (this.getCastedModel() instanceof Event && this.sourceConnections != null) {
            for (Object con : this.sourceConnections) {
                WithEditPart with = (WithEditPart)((Object)con);
                with.updateWithPos();
            }
        }
    }

    public DirectEditManager getManager() {
        if (this.manager == null) {
            Label l = this.getNameLabel();
            this.manager = new LabelDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, (CellEditorLocator)new NameCellEditorLocator(l), l, (VerifyListener)new IdentifierVerifyListener()){

                protected void bringDown() {
                    if (this.getEditPart() instanceof InterfaceEditPart) {
                        ((InterfaceEditPart)this.getEditPart()).refreshName();
                    }
                    super.bringDown();
                }
            };
        }
        return this.manager;
    }

    public class InterfaceFigure
    extends Label
    implements InteractionStyleFigure {
        public InterfaceFigure() {
            this.setText(InterfaceEditPart.this.getINamedElement().getName());
            this.setBorder((Border)new ConnectorBorder(InterfaceEditPart.this.getCastedModel()));
            this.setOpaque(false);
            if (InterfaceEditPart.this.isInput()) {
                this.setLabelAlignment(1);
                this.setTextAlignment(1);
            } else {
                this.setLabelAlignment(4);
                this.setTextAlignment(4);
            }
        }

        public int getIntersectionStyle(Point location) {
            if (InterfaceEditPart.this.isInput()) {
                Rectangle bounds = this.getBounds().getCopy();
                bounds.width = 5;
                if (bounds.intersects(new Rectangle(location, new Dimension(1, 1)))) {
                    return 0;
                }
                return 1;
            }
            Rectangle bounds = this.getBounds().getCopy();
            bounds.x += bounds.width - 5;
            bounds.width = 5;
            if (bounds.intersects(new Rectangle(location, new Dimension(1, 1)))) {
                return 0;
            }
            return 1;
        }
    }
}

