/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class AddWordProposal
implements IJavaCompletionProposal {
    private static final String PREF_KEY_DO_NOT_ASK = "do_not_ask_to_install_user_dictionary";
    private final IQuickAssistInvocationContext fContext;
    private final String fWord;

    public AddWordProposal(String word, IQuickAssistInvocationContext context) {
        this.fContext = context;
        this.fWord = word;
    }

    public final void apply(IDocument document) {
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.getSpellChecker();
        if (checker == null) {
            return;
        }
        if (!checker.acceptsWords()) {
            Shell shell = this.fContext != null && this.fContext.getSourceViewer() != null ? this.fContext.getSourceViewer().getTextWidget().getShell() : JavaPlugin.getActiveWorkbenchShell();
            if (!AddWordProposal.canAskToConfigure() || !this.askUserToConfigureUserDictionary(shell)) {
                return;
            }
            String[] preferencePageIds = new String[]{"org.eclipse.ui.editors.preferencePages.Spelling"};
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePageIds[0], (String[])preferencePageIds, null).open();
        }
        if (checker.acceptsWords()) {
            checker.addWord(this.fWord);
            if (this.fContext != null && this.fContext.getSourceViewer() != null) {
                SpellingProblem.removeAll((ISourceViewer)this.fContext.getSourceViewer(), (String)this.fWord);
            }
        }
    }

    private boolean askUserToConfigureUserDictionary(Shell shell) {
        MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)JavaUIMessages.Spelling_add_askToConfigure_title, (String)JavaUIMessages.Spelling_add_askToConfigure_question, (String)JavaUIMessages.Spelling_add_askToConfigure_ignoreMessage, (boolean)false, null, null);
        PreferenceConstants.getPreferenceStore().setValue(PREF_KEY_DO_NOT_ASK, toggleDialog.getToggleState());
        return toggleDialog.getReturnCode() == 2;
    }

    static boolean canAskToConfigure() {
        return !PreferenceConstants.getPreferenceStore().getBoolean(PREF_KEY_DO_NOT_ASK);
    }

    public String getAdditionalProposalInfo() {
        return Messages.format(JavaUIMessages.Spelling_add_info, new String[]{WordCorrectionProposal.getHtmlRepresentation(this.fWord)});
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return Messages.format(JavaUIMessages.Spelling_add_label, new String[]{this.fWord});
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif");
    }

    @Override
    public int getRelevance() {
        return Integer.MIN_VALUE;
    }

    public final Point getSelection(IDocument document) {
        return new Point(this.fContext.getOffset(), this.fContext.getLength());
    }
}

