/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.Iterator;
import java.util.List;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataexport.FBNetworkExporter;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.OtherAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class FbtExporter
extends CommonElementExporter {
    @Override
    protected void addType(Document dom, FBType fbType) {
        Element rootElement = this.createRootElement(dom, fbType, "FBType");
        this.addCompileAbleTypeData(dom, rootElement, fbType);
        this.addInterfaceList(dom, rootElement, fbType.getInterfaceList());
        if (fbType instanceof CompositeFBType) {
            rootElement.appendChild(new FBNetworkExporter(dom).createFBNetworkElement(((CompositeFBType)fbType).getFBNetwork()));
        } else if (fbType instanceof BasicFBType) {
            this.addBasicFB(dom, rootElement, (BasicFBType)fbType);
        }
        this.addService(dom, rootElement, fbType);
    }

    @Override
    protected FBType getType(PaletteEntry entry) {
        return ((FBTypePaletteEntry)entry).getFBType();
    }

    private void addBasicFB(Document dom, Element rootEle, BasicFBType type) {
        Element basicElement = dom.createElement("BasicFB");
        this.addInternalVars(dom, basicElement, (List<VarDeclaration>)type.getInternalVars());
        this.addECC(dom, basicElement, type.getECC());
        this.addAlgorithm(dom, basicElement, (List<Algorithm>)type.getAlgorithm());
        rootEle.appendChild(basicElement);
    }

    private void addAlgorithm(Document dom, Element basicElement, List<Algorithm> algorithms) {
        for (Algorithm algorithm : algorithms) {
            Element algorithmElement = dom.createElement("Algorithm");
            FbtExporter.setNameAttribute(algorithmElement, algorithm.getName());
            FbtExporter.setCommentAttribute(algorithmElement, algorithm);
            if (algorithm instanceof STAlgorithm) {
                FbtExporter.addSTAlgorithm(dom, algorithmElement, (STAlgorithm)algorithm);
            } else if (algorithm instanceof OtherAlgorithm) {
                FbtExporter.addOtherAlgorithm(dom, algorithmElement, (OtherAlgorithm)algorithm);
            }
            basicElement.appendChild(algorithmElement);
        }
    }

    private static void addOtherAlgorithm(Document dom, Element algorithmElement, OtherAlgorithm algorithm) {
        Element st = dom.createElement("Other");
        if (algorithm.getLanguage() != null) {
            st.setAttribute("Language", algorithm.getLanguage());
        } else {
            st.setAttribute("Language", "");
        }
        if (algorithm.getText() != null) {
            st.setAttribute("Text", algorithm.getText());
        } else {
            st.setAttribute("Text", "");
        }
        algorithmElement.appendChild(st);
    }

    private static void addSTAlgorithm(Document dom, Element algorithmElement, STAlgorithm algorithm) {
        Element st = dom.createElement("ST");
        if (algorithm.getText() != null) {
            st.setAttribute("Text", algorithm.getText());
        } else {
            st.setAttribute("Text", "");
        }
        algorithmElement.appendChild(st);
    }

    private void addECC(Document dom, Element basicElement, ECC ecc) {
        Element eccElement = dom.createElement("ECC");
        if (ecc != null) {
            this.addECStates(dom, eccElement, (List<ECState>)ecc.getECState(), ecc.getStart());
            this.addECTransitions(dom, eccElement, ecc);
        }
        basicElement.appendChild(eccElement);
    }

    private void addECTransitions(Document dom, Element eccElement, ECC ecc) {
        for (ECTransition transition : ecc.getECTransition()) {
            this.addTransition(dom, eccElement, transition);
        }
    }

    private void addTransition(Document dom, Element eccElement, ECTransition transition) {
        Element transElement = dom.createElement("ECTransition");
        transElement.setAttribute("Source", transition.getSource().getName());
        transElement.setAttribute("Destination", transition.getDestination().getName());
        transElement.setAttribute("Condition", transition.getConditionText());
        transElement.setAttribute("Comment", transition.getComment());
        transElement.setAttribute("x", CommonElementExporter.reConvertCoordinate(transition.getX()).toString());
        transElement.setAttribute("y", CommonElementExporter.reConvertCoordinate(transition.getY()).toString());
        eccElement.appendChild(transElement);
    }

    private void addECStates(Document dom, Element eccElement, List<ECState> states, ECState startState) {
        Element stateElement = this.createECState(dom, startState);
        if (stateElement != null) {
            eccElement.appendChild(stateElement);
        }
        for (ECState state : states) {
            if (state.equals(startState) || (stateElement = this.createECState(dom, state)) == null) continue;
            eccElement.appendChild(stateElement);
        }
    }

    private Element createECState(Document dom, ECState state) {
        if (state != null) {
            Element stateElement = dom.createElement("ECState");
            FbtExporter.setNameAttribute(stateElement, state.getName());
            FbtExporter.setCommentAttribute(stateElement, state);
            stateElement.setAttribute("x", CommonElementExporter.reConvertCoordinate(state.getX()).toString());
            stateElement.setAttribute("y", CommonElementExporter.reConvertCoordinate(state.getY()).toString());
            FbtExporter.addECActions(dom, stateElement, state.getECAction());
            return stateElement;
        }
        return null;
    }

    private static void addECActions(Document dom, Element stateElement, List<ECAction> actions) {
        for (ECAction action : actions) {
            Element actionElement = dom.createElement("ECAction");
            if (action.getAlgorithm() != null) {
                actionElement.setAttribute("Algorithm", action.getAlgorithm().getName());
            }
            if (action.getOutput() != null) {
                actionElement.setAttribute("Output", action.getOutput().getName());
            }
            stateElement.appendChild(actionElement);
        }
    }

    private void addInternalVars(Document dom, Element basicElement, List<VarDeclaration> internalVars) {
        Iterator<VarDeclaration> iter = internalVars.iterator();
        if (iter.hasNext()) {
            Element internalVarsElement = dom.createElement("InternalVars");
            while (iter.hasNext()) {
                VarDeclaration internalVar = iter.next();
                this.addVariable(dom, internalVarsElement, internalVar);
            }
            basicElement.appendChild(internalVarsElement);
        }
    }
}

