/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringAdapterElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.monitoring.editparts.MonitoringEditPart;
import org.eclipse.fordiac.ide.monitoring.handlers.AbstractMonitoringHandler;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveAllWatchesHandler
extends AbstractMonitoringHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            MonitoringManager manager = MonitoringManager.getInstance();
            Set<IInterfaceElement> foundElements = RemoveAllWatchesHandler.getSelectedWatchedelements(manager, (StructuredSelection)selection);
            for (IInterfaceElement ifElement : foundElements) {
                RemoveAllWatchesHandler.removeMonitoringElement(manager, ifElement);
            }
            this.refreshEditor();
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        boolean needToAdd = false;
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof StructuredSelection) {
            needToAdd = !RemoveAllWatchesHandler.getSelectedWatchedelements(MonitoringManager.getInstance(), (StructuredSelection)selection).isEmpty();
        }
        this.setBaseEnabled(needToAdd);
    }

    private static Set<IInterfaceElement> getSelectedWatchedelements(MonitoringManager manager, StructuredSelection selection) {
        HashSet<IInterfaceElement> foundElements = new HashSet<IInterfaceElement>();
        for (Object selectedObject : selection) {
            if (selectedObject instanceof EditPart) {
                if (selectedObject instanceof MonitoringEditPart) {
                    IInterfaceElement ie = ((MonitoringEditPart)((Object)selectedObject)).getModel().getPort().getInterfaceElement();
                    if (!manager.containsPort(ie)) continue;
                    foundElements.add(ie);
                    continue;
                }
                if (!(((EditPart)selectedObject).getModel() instanceof EObject)) continue;
                foundElements.addAll(RemoveAllWatchesHandler.getWatchedelementsForLibrayElement(manager, (EObject)((EditPart)selectedObject).getModel()));
                continue;
            }
            if (!(selectedObject instanceof EObject)) continue;
            foundElements.addAll(RemoveAllWatchesHandler.getWatchedelementsForLibrayElement(manager, (EObject)selectedObject));
        }
        return foundElements;
    }

    private static Set<IInterfaceElement> getWatchedelementsForLibrayElement(MonitoringManager manager, EObject element) {
        HashSet<IInterfaceElement> foundElements = new HashSet<IInterfaceElement>();
        if (element instanceof FBNetworkElement) {
            foundElements.addAll(RemoveAllWatchesHandler.getWatchedIfElementsForFB(manager, (FBNetworkElement)element));
        } else if (element instanceof FBNetwork) {
            foundElements.addAll(RemoveAllWatchesHandler.getWatchedElementsFromFBNetwork(manager, (FBNetwork)element));
        } else if (element instanceof IInterfaceElement) {
            if (manager.containsPort((IInterfaceElement)element)) {
                foundElements.add((IInterfaceElement)element);
            }
        } else if (element instanceof AutomationSystem) {
            foundElements.addAll(RemoveAllWatchesHandler.getWatchedElementsFromSystem(manager, (AutomationSystem)element));
        } else if (element instanceof Application) {
            foundElements.addAll(RemoveAllWatchesHandler.getWatchedElementsFromFBNetwork(manager, ((Application)element).getFBNetwork()));
        }
        return foundElements;
    }

    private static Set<IInterfaceElement> getWatchedElementsFromFBNetwork(MonitoringManager manager, FBNetwork fbNetwork) {
        HashSet<IInterfaceElement> foundElements = new HashSet<IInterfaceElement>();
        for (FBNetworkElement fbnElement : fbNetwork.getNetworkElements()) {
            foundElements.addAll(RemoveAllWatchesHandler.getWatchedIfElementsForFB(manager, fbnElement));
        }
        return foundElements;
    }

    private static Set<IInterfaceElement> getWatchedIfElementsForFB(MonitoringManager manager, FBNetworkElement model) {
        HashSet<IInterfaceElement> foundElements = new HashSet<IInterfaceElement>();
        for (IInterfaceElement element : model.getInterface().getAllInterfaceElements()) {
            if (!manager.containsPort(element)) continue;
            foundElements.add(element);
        }
        return foundElements;
    }

    private static Collection<? extends IInterfaceElement> getWatchedElementsFromSystem(MonitoringManager manager, AutomationSystem system) {
        HashSet<IInterfaceElement> foundElements = new HashSet<IInterfaceElement>();
        for (Application application : system.getApplication()) {
            foundElements.addAll(RemoveAllWatchesHandler.getWatchedElementsFromFBNetwork(manager, application.getFBNetwork()));
        }
        return foundElements;
    }

    private static void removeMonitoringElement(MonitoringManager manager, IInterfaceElement port) {
        MonitoringBaseElement element = manager.getMonitoringElement(port);
        if (element instanceof MonitoringAdapterElement) {
            for (MonitoringElement child : ((MonitoringAdapterElement)element).getElements()) {
                manager.removeMonitoringElement(child);
            }
        }
        manager.removeMonitoringElement(element);
    }
}

