/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.wizards;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.typemanagement.Activator;
import org.eclipse.fordiac.ide.typemanagement.wizards.NewFBTypeWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class NewFBTypeWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private NewFBTypeWizardPage page1;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private PaletteEntry entry;

    public NewFBTypeWizard() {
        this.setWindowTitle("New Type");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle("New Type");
    }

    public void addPages() {
        this.page1 = this.createNewFBTypeWizardPage();
        this.addPage((IWizardPage)this.page1);
    }

    protected NewFBTypeWizardPage createNewFBTypeWizardPage() {
        return new NewFBTypeWizardPage(this.selection);
    }

    public boolean performFinish() {
        String typeName = this.page1.getFileName();
        File template = this.page1.getTemplate();
        if (!this.checkTemplateAvailable(template.getAbsolutePath())) {
            return false;
        }
        IFile targetTypeFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.page1.getContainerFullPath() + "/" + typeName));
        try {
            ImportUtils.copyFile((File)template, (IFile)targetTypeFile);
            return this.finishTypeCreation(targetTypeFile);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return false;
        }
    }

    private boolean checkTemplateAvailable(String templatePath) {
        if (!new File(templatePath).exists()) {
            this.templateNotAvailable(templatePath);
            return false;
        }
        return true;
    }

    private void templateNotAvailable(String templatePath) {
        MessageBox mbx = new MessageBox(Display.getDefault().getActiveShell());
        mbx.setMessage("Template not available! (" + templatePath + ")");
        mbx.open();
    }

    private boolean finishTypeCreation(IFile targetTypeFile) {
        Palette palette = SystemManager.INSTANCE.getPalette(targetTypeFile.getProject());
        this.entry = TypeLibrary.getPaletteEntry((Palette)palette, (IFile)targetTypeFile);
        if (this.entry == null) {
            TypeLibrary.refreshPalette((Palette)palette);
            this.entry = TypeLibrary.getPaletteEntry((Palette)palette, (IFile)targetTypeFile);
        }
        LibraryElement type = this.entry.getType();
        type.setName(TypeLibrary.getTypeNameFromFile((IFile)targetTypeFile));
        if (type.getVersionInfo().size() != 0) {
            VersionInfo versionInfo = (VersionInfo)type.getVersionInfo().get(0);
            versionInfo.setDate(this.format.format(new Date(System.currentTimeMillis())));
        }
        CommonElementExporter.saveType((PaletteEntry)this.entry);
        this.entry.setType(type);
        if (this.page1.getOpenType()) {
            this.openTypeEditor(this.entry);
        }
        return true;
    }

    private void openTypeEditor(PaletteEntry entry) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(entry.getFile().getName());
        try {
            page.openEditor((IEditorInput)new FileEditorInput(entry.getFile()), desc.getId());
        }
        catch (PartInitException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    public PaletteEntry getPaletteEntry() {
        return this.entry;
    }
}

