/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.OtherAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.TextAlgorithm;
import org.eclipse.gef.commands.Command;

public class ChangeAlgorithmTypeCommand
extends Command {
    private final BasicFBType fbType;
    private Algorithm oldAlgorithm;
    private Algorithm newAlgorithm;
    private String algorithmType;

    public ChangeAlgorithmTypeCommand(BasicFBType fbType, Algorithm oldAlgorithm, String algorithmType) {
        this.fbType = fbType;
        this.oldAlgorithm = oldAlgorithm;
        this.algorithmType = algorithmType;
    }

    public boolean canExecute() {
        if (this.algorithmType.equalsIgnoreCase("ST")) {
            if (this.oldAlgorithm instanceof STAlgorithm) {
                return false;
            }
            if (!(this.oldAlgorithm instanceof TextAlgorithm) && !(this.oldAlgorithm instanceof OtherAlgorithm)) {
                return false;
            }
        } else if (!(this.oldAlgorithm instanceof STAlgorithm) && (this.oldAlgorithm instanceof TextAlgorithm || this.oldAlgorithm instanceof OtherAlgorithm)) {
            return false;
        }
        return true;
    }

    public void execute() {
        this.newAlgorithm = this.algorithmType.equalsIgnoreCase("ST") ? this.createSTAlgorithm() : this.createOtherAlgorithm();
        this.redo();
    }

    private Algorithm createSTAlgorithm() {
        STAlgorithm algorithm = LibraryElementFactory.eINSTANCE.createSTAlgorithm();
        algorithm.setText(((TextAlgorithm)this.oldAlgorithm).getText());
        algorithm.setName(this.oldAlgorithm.getName());
        algorithm.setComment(this.oldAlgorithm.getComment());
        return algorithm;
    }

    private Algorithm createOtherAlgorithm() {
        OtherAlgorithm algorithm = LibraryElementFactory.eINSTANCE.createOtherAlgorithm();
        algorithm.setText(((TextAlgorithm)this.oldAlgorithm).getText());
        algorithm.setName(this.oldAlgorithm.getName());
        algorithm.setComment(this.oldAlgorithm.getComment());
        algorithm.setLanguage("AnyText");
        return algorithm;
    }

    public void undo() {
        this.fbType.getAlgorithm().add(this.fbType.getAlgorithm().indexOf((Object)this.newAlgorithm), (Object)this.oldAlgorithm);
        this.updateECActions(false);
        this.fbType.getAlgorithm().remove((Object)this.newAlgorithm);
    }

    public void redo() {
        this.fbType.getAlgorithm().add(this.fbType.getAlgorithm().indexOf((Object)this.oldAlgorithm), (Object)this.newAlgorithm);
        this.updateECActions(true);
        this.fbType.getAlgorithm().remove((Object)this.oldAlgorithm);
    }

    private void updateECActions(boolean redo) {
        for (ECState state : this.fbType.getECC().getECState()) {
            for (ECAction action : state.getECAction()) {
                if (redo) {
                    if (action.getAlgorithm() != this.oldAlgorithm) continue;
                    action.setAlgorithm(this.newAlgorithm);
                    continue;
                }
                if (action.getAlgorithm() != this.newAlgorithm) continue;
                action.setAlgorithm(this.oldAlgorithm);
            }
        }
    }

    public Algorithm getNewAlgorithm() {
        return this.newAlgorithm;
    }
}

