/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeAlgorithmTypeCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateAlgorithmCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteAlgorithmCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.AlgorithmsLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AlgorithmGroup;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.ECCSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AlgorithmsSection
extends ECCSection {
    private TableViewer algorithmViewer;
    private Button algorithmNew;
    private Button algorithmDelete;
    private AlgorithmGroup algorithmGroup;
    private static final String A_NAME = "Name";
    private static final String A_LANGUAGE = "Language";
    private static final String A_COMMENT = "Comment";

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createAlgorithmControls(parent);
    }

    public void createAlgorithmControls(Composite parent) {
        SashForm view = new SashForm(parent, 65792);
        view.setLayout((Layout)new FillLayout());
        this.leftComposite = this.getWidgetFactory().createComposite((Composite)view);
        this.leftComposite.setLayout((Layout)new GridLayout(2, false));
        this.rightComposite = this.getWidgetFactory().createComposite((Composite)view);
        this.rightComposite.setLayout((Layout)new GridLayout());
        view.setWeights(new int[]{1, 1});
        view.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createAddDelteButtons(this.leftComposite);
        this.createAlgorithmViewer(this.leftComposite);
        this.algorithmGroup = new AlgorithmGroup(this.rightComposite, this.getWidgetFactory());
    }

    private void createAlgorithmViewer(Composite parent) {
        this.algorithmViewer = new TableViewer(parent, 68096);
        GridData gridDataVersionViewer = new GridData(4, 4, true, true);
        gridDataVersionViewer.heightHint = 150;
        gridDataVersionViewer.widthHint = 80;
        this.algorithmViewer.getControl().setLayoutData((Object)gridDataVersionViewer);
        Table table = this.algorithmViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(this.algorithmViewer.getTable(), 16384);
        column1.setText(A_NAME);
        TableColumn column2 = new TableColumn(this.algorithmViewer.getTable(), 0x1000000);
        column2.setText(A_LANGUAGE);
        TableColumn column3 = new TableColumn(this.algorithmViewer.getTable(), 16384);
        column3.setText(A_COMMENT);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 50));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 20));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 50));
        table.setLayout((Layout)layout);
        this.algorithmViewer.setCellEditors(AlgorithmsSection.createAlgorithmCellEditors(table));
        this.algorithmViewer.setColumnProperties(new String[]{A_NAME, A_LANGUAGE, A_COMMENT});
        this.algorithmViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.algorithmViewer.setLabelProvider((IBaseLabelProvider)new AlgorithmsLabelProvider());
        this.algorithmViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                switch (property) {
                    case "Name": {
                        return ((Algorithm)element).getName();
                    }
                    case "Language": {
                        return element instanceof STAlgorithm ? 1 : 0;
                    }
                }
                return ((Algorithm)element).getComment();
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                Algorithm data = (Algorithm)tableItem.getData();
                Object cmd = null;
                cmd = AlgorithmsSection.A_NAME.equals(property) ? new ChangeNameCommand((INamedElement)data, value.toString()) : (AlgorithmsSection.A_LANGUAGE.equals(property) ? new ChangeAlgorithmTypeCommand(AlgorithmsSection.this.getType(), data, AlgorithmsSection.getLanguages().get((Integer)value)) : new ChangeCommentCommand((INamedElement)data, value.toString()));
                if (cmd != null && AlgorithmsSection.this.commandStack != null) {
                    AlgorithmsSection.this.executeCommand((Command)cmd);
                    AlgorithmsSection.this.algorithmViewer.refresh((Object)data);
                    if (cmd instanceof ChangeAlgorithmTypeCommand && (data = ((ChangeAlgorithmTypeCommand)((Object)cmd)).getNewAlgorithm()) != null) {
                        AlgorithmsSection.this.algorithmViewer.setSelection((ISelection)new StructuredSelection((Object)data));
                    }
                    AlgorithmsSection.this.algorithmGroup.setAlgorithm(data);
                    AlgorithmsSection.this.refresh();
                }
            }
        });
        this.algorithmViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)AlgorithmsSection.this.algorithmViewer.getSelection()).getFirstElement();
                AlgorithmsSection.this.setAlgorithDeleteState(selection != null);
                AlgorithmsSection.this.algorithmGroup.setAlgorithm(selection instanceof Algorithm ? (Algorithm)selection : null);
            }
        });
    }

    private static CellEditor[] createAlgorithmCellEditors(Table table) {
        TextCellEditor algorithmNameEditor = new TextCellEditor((Composite)table);
        ((Text)algorithmNameEditor.getControl()).addVerifyListener((VerifyListener)new IdentifierVerifyListener());
        return new CellEditor[]{algorithmNameEditor, new ComboBoxCellEditor((Composite)table, AlgorithmsSection.getLanguages().toArray(new String[0]), 8), new TextCellEditor((Composite)table)};
    }

    private void createAddDelteButtons(Composite composite) {
        Composite buttonComp = new Composite(composite, 0);
        GridData buttonCompLayoutData = new GridData(0x1000000, 128, false, false);
        buttonComp.setLayoutData((Object)buttonCompLayoutData);
        buttonComp.setLayout((Layout)new FillLayout(512));
        this.algorithmNew = this.getWidgetFactory().createButton(buttonComp, "", 0x800000);
        this.algorithmNew.setToolTipText("Create new algorithm");
        this.algorithmNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.algorithmNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateAlgorithmCommand cmd = new CreateAlgorithmCommand(AlgorithmsSection.this.getType());
                AlgorithmsSection.this.executeCommand(cmd);
                AlgorithmsSection.this.algorithmViewer.refresh();
                if (cmd.getNewAlgorithm() != null) {
                    AlgorithmsSection.this.algorithmViewer.setSelection((ISelection)new StructuredSelection((Object)cmd.getNewAlgorithm()), true);
                }
            }
        });
        this.algorithmDelete = this.getWidgetFactory().createButton(buttonComp, "", 8);
        this.setAlgorithDeleteState(false);
        this.algorithmDelete.setToolTipText("Delete selected algorithm");
        this.algorithmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgorithmsSection.this.executeCommand(new DeleteAlgorithmCommand(AlgorithmsSection.this.getType(), (Algorithm)((IStructuredSelection)AlgorithmsSection.this.algorithmViewer.getSelection()).getFirstElement()));
                AlgorithmsSection.this.algorithmViewer.refresh();
            }
        });
    }

    private void setAlgorithDeleteState(boolean enabled) {
        this.algorithmDelete.setEnabled(enabled);
        this.algorithmDelete.setImage(enabled ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE") : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE_DISABLED"));
    }

    protected void setInputCode() {
        this.algorithmViewer.setCellModifier(null);
    }

    protected void setInputInit() {
        this.algorithmGroup.initialize(this.getType(), this.commandStack);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.algorithmViewer.setInput((Object)this.getType().getAlgorithm());
        }
        this.commandStack = commandStackBuffer;
    }
}

