/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateInternalVariableCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteInternalVariableCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.InternalVarsLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.ECCSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeArraySizeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeInitialValueCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTypeCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class InternalVarsSection
extends ECCSection {
    private TableViewer internalVarsViewer;
    private Button internalVarsNew;
    private Button internalVarsDelete;
    private static final String IV_NAME = "Name";
    private static final String IV_TYPE = "Type";
    private static final String IV_ARRAY = "Array Size";
    private static final String IV_INIT = "Initial Value";
    private static final String IV_COMMENT = "Comment";
    private ComboBoxCellEditor typeDropDown;
    private String[] dataTypes = new String[DataTypeLibrary.getInstance().getDataTypesSorted().size()];

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createInternalVarsControls(parent);
    }

    public void createInternalVarsControls(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createAddDelteButtons(composite);
        this.internalVarsViewer = new TableViewer(composite, 68096);
        GridData gridDataVersionViewer = new GridData(4, 4, true, true);
        gridDataVersionViewer.heightHint = 150;
        gridDataVersionViewer.widthHint = 80;
        this.internalVarsViewer.getControl().setLayoutData((Object)gridDataVersionViewer);
        Table table = this.internalVarsViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(this.internalVarsViewer.getTable(), 16384);
        column1.setText(IV_NAME);
        TableColumn column2 = new TableColumn(this.internalVarsViewer.getTable(), 16384);
        column2.setText(IV_TYPE);
        TableColumn column3 = new TableColumn(this.internalVarsViewer.getTable(), 16384);
        column3.setText(IV_COMMENT);
        TableColumn column4 = new TableColumn(this.internalVarsViewer.getTable(), 16384);
        column4.setText(IV_ARRAY);
        TableColumn column5 = new TableColumn(this.internalVarsViewer.getTable(), 16384);
        column5.setText(IV_INIT);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 30));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 30));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 50));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 20));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 20));
        table.setLayout((Layout)layout);
        int i = 0;
        while (i < DataTypeLibrary.getInstance().getDataTypesSorted().size()) {
            this.dataTypes[i] = ((DataType)DataTypeLibrary.getInstance().getDataTypesSorted().toArray()[i]).getName();
            ++i;
        }
        this.internalVarsViewer.setCellEditors(this.createCellEditors(table));
        this.internalVarsViewer.setColumnProperties(new String[]{IV_NAME, IV_TYPE, IV_COMMENT, IV_ARRAY, IV_INIT});
        this.internalVarsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.internalVarsViewer.setLabelProvider((IBaseLabelProvider)new InternalVarsLabelProvider());
        this.internalVarsViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                if (InternalVarsSection.IV_NAME.equals(property)) {
                    return ((VarDeclaration)element).getName();
                }
                if (InternalVarsSection.IV_TYPE.equals(property)) {
                    int i = 0;
                    String[] stringArray = InternalVarsSection.this.typeDropDown.getItems();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        if (item.equals(((VarDeclaration)element).getType().getName())) {
                            return i;
                        }
                        ++i;
                        ++n2;
                    }
                    return 0;
                }
                if (InternalVarsSection.IV_COMMENT.equals(property)) {
                    return ((VarDeclaration)element).getComment();
                }
                if (InternalVarsSection.IV_ARRAY.equals(property)) {
                    return Integer.toString(((VarDeclaration)element).getArraySize());
                }
                return ((VarDeclaration)element).getVarInitialization().getInitialValue();
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                VarDeclaration data = (VarDeclaration)tableItem.getData();
                Object cmd = null;
                cmd = InternalVarsSection.IV_NAME.equals(property) ? new ChangeNameCommand((INamedElement)data, value.toString()) : (InternalVarsSection.IV_TYPE.equals(property) ? new ChangeTypeCommand(data, DataTypeLibrary.getInstance().getType(InternalVarsSection.this.dataTypes[(Integer)value])) : (InternalVarsSection.IV_COMMENT.equals(property) ? new ChangeCommentCommand((INamedElement)data, value.toString()) : (InternalVarsSection.IV_ARRAY.equals(property) ? new ChangeArraySizeCommand(data, value.toString()) : new ChangeInitialValueCommand(data, value.toString()))));
                if (cmd != null) {
                    InternalVarsSection.this.executeCommand((Command)cmd);
                    InternalVarsSection.this.internalVarsViewer.refresh((Object)data);
                }
            }
        });
        this.internalVarsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InternalVarsSection.this.setInternalVarsDeleteState(event.getStructuredSelection().getFirstElement() != null);
            }
        });
    }

    private void createAddDelteButtons(Composite composite) {
        Composite buttonComp = new Composite(composite, 0);
        GridData buttonCompLayoutData = new GridData(0x1000000, 128, false, false);
        buttonComp.setLayoutData((Object)buttonCompLayoutData);
        buttonComp.setLayout((Layout)new FillLayout(512));
        this.internalVarsNew = this.getWidgetFactory().createButton(buttonComp, "", 8);
        this.internalVarsNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.internalVarsNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InternalVarsSection.this.executeCommand(new CreateInternalVariableCommand(InternalVarsSection.this.getType()));
                InternalVarsSection.this.internalVarsViewer.refresh();
            }
        });
        this.internalVarsDelete = this.getWidgetFactory().createButton(buttonComp, "", 8);
        this.setInternalVarsDeleteState(false);
        this.internalVarsDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InternalVarsSection.this.executeCommand(new DeleteInternalVariableCommand(InternalVarsSection.this.getType(), (VarDeclaration)((IStructuredSelection)InternalVarsSection.this.internalVarsViewer.getSelection()).getFirstElement()));
                InternalVarsSection.this.internalVarsViewer.refresh();
            }
        });
    }

    private void setInternalVarsDeleteState(boolean enabled) {
        this.internalVarsDelete.setEnabled(enabled);
        this.internalVarsDelete.setImage(enabled ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE") : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE_DISABLED"));
    }

    private CellEditor[] createCellEditors(Table table) {
        TextCellEditor varNameEditor = new TextCellEditor((Composite)table);
        ((Text)varNameEditor.getControl()).addVerifyListener((VerifyListener)new IdentifierVerifyListener());
        this.typeDropDown = new ComboBoxCellEditor((Composite)table, this.dataTypes, 8);
        return new CellEditor[]{varNameEditor, this.typeDropDown, new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)};
    }

    protected void setInputCode() {
        this.internalVarsViewer.setCellModifier(null);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.internalVarsViewer.setInput((Object)this.getType().getInternalVars());
        }
        this.commandStack = commandStackBuffer;
    }

    protected void setInputInit() {
    }
}

