/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeConditionEventCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeConditionExpressionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeECTransitionCommentCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECTransitionEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AbstractECSection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public class TransitionSection
extends AbstractECSection {
    private static final String ONE_CONDITION = "1";
    private static final String LINKING_FILE_EXTENSION = "xtextfbt";
    private Text commentText;
    private Combo eventCombo;
    Composite conditionEditingContainer;
    CLabel closingBraket;
    private EmbeddedEditor editor;
    Composite composite;
    @Inject
    protected EmbeddedEditorFactory editorFactory;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    @Named(value="file.extensions")
    public String fileExtension;
    EmbeddedEditorModelAccess embeddedEditorModelAccess;
    private final IDocumentListener listener = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            TransitionSection.this.executeCommand(new ChangeConditionExpressionCommand(TransitionSection.this.getType(), TransitionSection.this.embeddedEditorModelAccess.getEditablePart()));
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    };

    protected ECTransition getType() {
        return (ECTransition)this.type;
    }

    protected BasicFBType getBasicFBType() {
        return this.getType().eContainer() != null ? (BasicFBType)this.getType().eContainer().eContainer() : null;
    }

    protected Object getInputType(Object input) {
        if (input instanceof ECTransitionEditPart) {
            return ((ECTransitionEditPart)((Object)input)).getCastedModel();
        }
        if (input instanceof ECTransition) {
            return input;
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        this.composite = this.getWidgetFactory().createComposite(parent);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(this.composite, "Condition:");
        this.createConditionEditingPlaceHolder(this.composite);
        this.getWidgetFactory().createCLabel(this.composite, "Comment:");
        this.commentText = this.createGroupText(this.composite, true);
        this.commentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TransitionSection.this.removeContentAdapter();
                TransitionSection.this.executeCommand(new ChangeECTransitionCommentCommand(TransitionSection.this.getType(), TransitionSection.this.commentText.getText()));
                TransitionSection.this.addContentAdapter();
            }
        });
    }

    private void createConditionEditingPlaceHolder(Composite parent) {
        this.conditionEditingContainer = this.getWidgetFactory().createComposite(parent);
        this.conditionEditingContainer.setLayout((Layout)new GridLayout(4, false));
        GridData compositeLayoutData = new GridData(4, 0, true, false);
        compositeLayoutData.verticalIndent = 0;
        this.conditionEditingContainer.setLayoutData((Object)compositeLayoutData);
        this.eventCombo = new Combo(this.conditionEditingContainer, 2060);
        this.eventCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransitionSection.this.removeContentAdapter();
                TransitionSection.this.executeCommand(new ChangeConditionEventCommand(TransitionSection.this.getType(), TransitionSection.this.eventCombo.getText()));
                TransitionSection.this.checkEnablement();
                TransitionSection.this.addContentAdapter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getWidgetFactory().createCLabel(this.conditionEditingContainer, "[");
        this.closingBraket = this.getWidgetFactory().createCLabel(this.conditionEditingContainer, "]");
    }

    protected void setInputInit() {
        if (this.editor == null) {
            this.createTransitionEditor(this.conditionEditingContainer);
        }
    }

    protected void setInputCode() {
        this.commentText.setEnabled(false);
        this.eventCombo.removeAll();
        this.eventCombo.setEnabled(false);
    }

    private void createTransitionEditor(Composite parent) {
        BasicFBType fbType = this.getBasicFBType();
        IEditedResourceProvider resourceProvider = new IEditedResourceProvider((FBType)fbType){
            private final /* synthetic */ FBType val$fbType;
            {
                this.val$fbType = fBType;
            }

            public XtextResource createResource() {
                XtextResourceSet resourceSet = (XtextResourceSet)TransitionSection.this.resourceSetProvider.get();
                EcoreUtil.Copier copier = new EcoreUtil.Copier();
                Resource fbResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, TransitionSection.LINKING_FILE_EXTENSION));
                fbResource.getContents().add((Object)copier.copy(EcoreUtil.getRootContainer((EObject)this.val$fbType)));
                for (AdapterDeclaration adapter : this.val$fbType.getInterfaceList().getSockets()) {
                    this.createAdapterResource(resourceSet, copier, adapter);
                }
                for (AdapterDeclaration adapter : this.val$fbType.getInterfaceList().getPlugs()) {
                    this.createAdapterResource(resourceSet, copier, adapter);
                }
                copier.copyReferences();
                Resource resource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, TransitionSection.this.fileExtension));
                return (XtextResource)resource;
            }

            private void createAdapterResource(XtextResourceSet resourceSet, EcoreUtil.Copier copier, AdapterDeclaration adapter) {
                if (adapter.getType() instanceof AdapterType) {
                    Resource adapterResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, TransitionSection.LINKING_FILE_EXTENSION));
                    copier.copy((EObject)adapter.getType());
                    adapterResource.getContents().add((Object)copier.copy(EcoreUtil.getRootContainer((EObject)((AdapterType)adapter.getType()).getAdapterFBType())));
                }
            }

            protected URI computeUnusedUri(ResourceSet resourceSet, String fileExtension) {
                String name = "__synthetic";
                int i = 0;
                while (i < Integer.MAX_VALUE) {
                    URI syntheticUri = URI.createURI((String)(String.valueOf(name) + i + "." + fileExtension));
                    if (resourceSet.getResource(syntheticUri, false) == null) {
                        return syntheticUri;
                    }
                    ++i;
                }
                throw new IllegalStateException();
            }
        };
        this.editor = this.editorFactory.newEditor(resourceProvider).withParent(parent);
        StyledText conditionText = (StyledText)this.editor.getViewer().getControl();
        conditionText.setLayoutData((Object)new GridData(4, 0, true, false));
        conditionText.setBottomMargin(5);
        conditionText.setTopMargin(5);
        conditionText.setLeftMargin(5);
        conditionText.setRightMargin(5);
        conditionText.moveAbove((Control)this.closingBraket);
        this.embeddedEditorModelAccess = this.editor.createPartialEditor();
        this.editor.getDocument().addDocumentListener(this.listener);
        this.composite.layout();
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null && this.getBasicFBType() != null) {
            this.setEventConditionDropdown();
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            this.updateConditionExpressionText(this.getType().getConditionExpression());
            if (this.getType().getConditionExpression() != null && this.getType().getConditionExpression().equals(ONE_CONDITION)) {
                this.eventCombo.select(1);
            } else {
                this.eventCombo.select(this.getType().getConditionEvent() != null ? this.eventCombo.indexOf(this.getType().getConditionEvent().getName()) : 0);
            }
            this.checkEnablement();
        }
        this.commandStack = commandStackBuffer;
    }

    private void updateConditionExpressionText(String conditionExpression) {
        if (this.embeddedEditorModelAccess != null) {
            this.embeddedEditorModelAccess.updateModel(conditionExpression != null ? conditionExpression : "");
        }
    }

    private void checkEnablement() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.getType().getConditionExpression() != null && this.getType().getConditionExpression().equals(ONE_CONDITION)) {
            this.updateConditionExpressionText("");
            this.editor.getViewer().getControl().setEnabled(false);
        } else {
            this.editor.getViewer().getControl().setEnabled(true);
        }
        this.commandStack = commandStackBuffer;
    }

    public void setEventConditionDropdown() {
        this.eventCombo.removeAll();
        this.eventCombo.add("");
        this.eventCombo.add(ONE_CONDITION);
        for (Event event : this.getBasicFBType().getInterfaceList().getEventInputs()) {
            this.eventCombo.add(event.getName());
        }
        for (AdapterDeclaration adapter : this.getBasicFBType().getInterfaceList().getPlugs()) {
            if (!(adapter.getType() instanceof AdapterType)) continue;
            for (Event event : ((AdapterType)adapter.getType()).getInterfaceList().getEventInputs()) {
                this.eventCombo.add(String.valueOf(adapter.getName()) + "." + event.getName());
            }
        }
        for (AdapterDeclaration adapter : this.getBasicFBType().getInterfaceList().getSockets()) {
            if (!(adapter.getType() instanceof AdapterType)) continue;
            for (Event event : ((AdapterType)adapter.getType()).getInterfaceList().getEventOutputs()) {
                this.eventCombo.add(String.valueOf(adapter.getName()) + "." + event.getName());
            }
        }
    }
}

