/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.util.Preconditions;

class EnumArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<EnumSource> {
    private EnumSet<?> constants;

    EnumArgumentsProvider() {
    }

    @Override
    public void accept(EnumSource enumSource) {
        Class<? extends Enum<?>> enumClass = enumSource.value();
        this.constants = EnumSet.allOf(enumClass);
        EnumSource.Mode mode = enumSource.mode();
        String[] declaredConstantNames = enumSource.names();
        if (declaredConstantNames.length > 0) {
            Set<String> uniqueNames = Arrays.stream(declaredConstantNames).collect(Collectors.toSet());
            Preconditions.condition((uniqueNames.size() == declaredConstantNames.length ? 1 : 0) != 0, () -> "Duplicate enum constant name(s) found in " + enumSource);
            mode.validate(enumSource, uniqueNames);
            this.constants.removeIf(constant -> !mode.select((Enum<?>)constant, uniqueNames));
        }
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        return this.constants.stream().map(xva$0 -> Arguments.of(xva$0));
    }
}

