/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtest.automatedRemoteTest;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.fordiac.ide.deployment.AbstractDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.exceptions.CreateResourceInstanceException;
import org.eclipse.fordiac.ide.deployment.exceptions.DisconnectException;
import org.eclipse.fordiac.ide.deployment.iec61499.DeploymentExecutor;
import org.eclipse.fordiac.ide.deployment.iec61499.EthernetDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.iec61499.Messages;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtest.util.FBTHelper;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.DeviceType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.LibraryElementFactoryImpl;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class ART_DeploymentMgr {
    private Resource res;
    private DeploymentExecutor executor;
    private IDeploymentListener listener;
    private Device dev;
    private FBType fbType;
    private int REQID = 0;
    private String address;
    private int UID = -2;
    private boolean deploymentError = false;
    private int deploymentResponseCounter = 0;
    public String MgmtResponse = "";
    public String MgmtCommands = "";

    public ART_DeploymentMgr(FBType fbType, String address, int paUID) {
        this.UID = paUID;
        this.fbType = fbType;
        this.address = address != null ? address : "localhost:61499";
        LibraryElementFactory libFactory = LibraryElementFactoryImpl.init();
        DeviceType devType = libFactory.createDeviceType();
        devType.setName("RMT_DEV");
        this.dev = libFactory.createDevice();
        this.dev.setPaletteEntry(null);
        this.dev.setProfile("HOLOBLOC");
        this.dev.setName("TestDevice");
        this.res = libFactory.createResource();
        this.res.setDevice(this.dev);
        List entries = TypeLibrary.getInstance().getPalette().getTypeEntries("EMB_RES");
        if (entries.size() > 0) {
            PaletteEntry entry = (PaletteEntry)entries.get(0);
            this.res.setPaletteEntry(entry);
        }
        this.res.setName("__" + fbType.getName() + "Test" + this.UID);
        this.executor = new DeploymentExecutor();
        this.executor.setDeviceManagementCommunicationHandler((AbstractDeviceManagementCommunicationHandler)new EthernetDeviceManagementCommunicationHandler());
        this.listener = new IDeploymentListener(){

            public void responseReceived(String response, String source) {
                if (response.toLowerCase().indexOf("reason") > -1) {
                    ART_DeploymentMgr.this.deploymentError = true;
                    ART_DeploymentMgr.this.MgmtCommands = String.valueOf(ART_DeploymentMgr.this.MgmtCommands) + response + "\n\n";
                    ART_DeploymentMgr.this.MgmtResponse = String.valueOf(ART_DeploymentMgr.this.MgmtResponse) + response;
                }
                ART_DeploymentMgr aRT_DeploymentMgr = ART_DeploymentMgr.this;
                aRT_DeploymentMgr.deploymentResponseCounter = aRT_DeploymentMgr.deploymentResponseCounter - 1;
            }

            public void postCommandSent(String info, String destination, String command) {
            }

            public void postCommandSent(String message) {
            }

            public void postCommandSent(String command, String destination) {
                ART_DeploymentMgr.this.MgmtCommands = String.valueOf(ART_DeploymentMgr.this.MgmtCommands) + destination + command + "\n";
            }

            public void finished() {
            }
        };
        this.executor.getDevMgmComHandler().addDeploymentListener(this.listener);
    }

    public boolean cleanRes() {
        try {
            this.executor.getDevMgmComHandler().connect(this.address);
            ++this.deploymentResponseCounter;
            ++this.deploymentResponseCounter;
            this.executor.deleteResource(this.res);
            this.executor.getDevMgmComHandler().disconnect();
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return false;
        }
        return true;
    }

    public boolean deploy(String TestChannelID) {
        this.MgmtResponse = "";
        this.MgmtCommands = "";
        boolean Error = false;
        int numEI = FBTHelper.getEISize(this.fbType);
        int numEO = FBTHelper.getEOSize(this.fbType);
        int numDI = FBTHelper.getDISize(this.fbType);
        int numDO = FBTHelper.getDOSize(this.fbType);
        try {
            this.executor.getDevMgmComHandler().connect(this.address);
        }
        catch (Exception exception) {
            this.MgmtCommands = "Error during connection to device: " + this.address + "\n";
            Error = true;
        }
        if (Error) {
            return false;
        }
        try {
            ++this.deploymentResponseCounter;
            this.executor.createResource(this.res);
        }
        catch (CreateResourceInstanceException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
            Error = true;
        }
        while (!Error && !this.deploymentError && this.deploymentResponseCounter > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.deploymentError || Error) {
            return false;
        }
        String destination = this.res.getName();
        try {
            this.sendREQ(this.res.getName(), this.createFB_Request("FBuT", this.fbType.getName()));
            this.sendREQ(this.res.getName(), this.createFB_Request("Server", "SERVER_" + (numDO + 1) + "_" + (numDI + 1)));
            this.sendREQ(this.res.getName(), this.createFB_Request("MuX", "E_MUX_" + numEO));
            this.sendREQ(this.res.getName(), this.createFB_Request("DeMuX", "E_DEMUX_" + numEI));
            this.sendREQ(this.res.getName(), this.createConnection_Request("Server", "IND", "DeMuX", "EI"));
            this.sendREQ(this.res.getName(), this.createConnection_Request("MuX", "EO", "Server", "RSP"));
            this.sendREQ(this.res.getName(), this.createConnection_Request("START", "COLD", "Server", "INIT"));
            if (this.fbType.getInterfaceList() != null) {
                if (this.fbType.getInterfaceList().getEventInputs() != null) {
                    for (Event EI : this.fbType.getInterfaceList().getEventInputs()) {
                        this.sendREQ(this.res.getName(), this.createConnection_Request("DeMuX", "EO" + (FBTHelper.getEIID(this.fbType, EI.getName()) + 1), "FBuT", EI.getName()));
                    }
                }
                if (this.fbType.getInterfaceList().getEventOutputs() != null) {
                    for (Event EO : this.fbType.getInterfaceList().getEventOutputs()) {
                        this.sendREQ(this.res.getName(), this.createConnection_Request("FBuT", EO.getName(), "MuX", "EI" + (FBTHelper.getEOID(this.fbType, EO.getName()) + 1)));
                    }
                }
            }
            this.sendREQ(destination, this.writeFBParameter_Request("Server.ID", TestChannelID));
            this.sendREQ(destination, this.writeFBParameter_Request("Server.QI", "1"));
            this.sendREQ(this.res.getName(), this.createConnection_Request("Server", "RD_1", "DeMuX", "K"));
            this.sendREQ(this.res.getName(), this.createConnection_Request("MuX", "K", "Server", "SD_1"));
            if (this.fbType.getInterfaceList().getInputVars() != null) {
                for (VarDeclaration DI : this.fbType.getInterfaceList().getInputVars()) {
                    this.sendREQ(this.res.getName(), this.createConnection_Request("Server", "RD_" + (2 + FBTHelper.getDIID(this.fbType, DI.getName())), "FBuT", DI.getName()));
                }
            }
            if (this.fbType.getInterfaceList().getOutputVars() != null) {
                for (VarDeclaration DO : this.fbType.getInterfaceList().getOutputVars()) {
                    this.sendREQ(this.res.getName(), this.createConnection_Request("FBuT", DO.getName(), "Server", "SD_" + (2 + FBTHelper.getDOID(this.fbType, DO.getName()))));
                }
            }
            ++this.deploymentResponseCounter;
            this.executor.startResource(this.res);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
            Error = true;
        }
        try {
            this.executor.getDevMgmComHandler().disconnect();
        }
        catch (DisconnectException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        if (this.deploymentError) {
            this.cleanRes();
            return false;
        }
        return !Error;
    }

    private String createFB_Request(String fbName, String fbTypeName) {
        return MessageFormat.format(Messages.DeploymentExecutor_CreateFBInstance, this.REQID++, fbName, fbTypeName);
    }

    private String createConnection_Request(String SrcFBName, String SrcIfElemName, String DstFBName, String DstIfElemName) {
        return MessageFormat.format(Messages.DeploymentExecutor_CreateConnection, this.REQID++, String.valueOf(SrcFBName) + "." + SrcIfElemName, String.valueOf(DstFBName) + "." + DstIfElemName);
    }

    private String writeFBParameter_Request(String Dst, String value) {
        return MessageFormat.format(Messages.DeploymentExecutor_WriteParameter, this.REQID++, value, Dst);
    }

    private void sendREQ(String destination, String request) throws IOException {
        ++this.deploymentResponseCounter;
        this.executor.getDevMgmComHandler().sendREQ(destination, request);
    }
}

