/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;

public class PresentationReconcilerRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ui.genericeditor.presentationReconcilers";
    private Map<IConfigurationElement, PresentationReconcilerExtension> extensions = new HashMap<IConfigurationElement, PresentationReconcilerExtension>();
    private boolean outOfSync = true;

    public PresentationReconcilerRegistry() {
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                PresentationReconcilerRegistry.this.outOfSync = true;
            }
        }, EXTENSION_POINT_ID);
    }

    public List<IPresentationReconciler> getPresentationReconcilers(ISourceViewer sourceViewer, Set<IContentType> contentTypes) {
        if (this.outOfSync) {
            this.sync();
        }
        ArrayList<IPresentationReconciler> res = new ArrayList<IPresentationReconciler>();
        for (PresentationReconcilerExtension ext : this.extensions.values()) {
            if (!contentTypes.contains(ext.targetContentType)) continue;
            res.add(ext);
        }
        return res;
    }

    private void sync() {
        HashSet<IConfigurationElement> toRemoveExtensions = new HashSet<IConfigurationElement>(this.extensions.keySet());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            toRemoveExtensions.remove(extension);
            if (!this.extensions.containsKey(extension)) {
                try {
                    this.extensions.put(extension, new PresentationReconcilerExtension(extension));
                }
                catch (Exception ex) {
                    GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
                }
            }
            ++n2;
        }
        for (IConfigurationElement toRemove : toRemoveExtensions) {
            this.extensions.remove(toRemove);
        }
        this.outOfSync = false;
    }

    private static class PresentationReconcilerExtension
    implements IPresentationReconciler {
        private static final String CLASS_ATTRIBUTE = "class";
        private static final String CONTENT_TYPE_ATTRIBUTE = "contentType";
        private IConfigurationElement extension;
        private IContentType targetContentType;
        private IPresentationReconciler delegate;

        private PresentationReconcilerExtension(IConfigurationElement element) throws Exception {
            this.extension = element;
            this.targetContentType = Platform.getContentTypeManager().getContentType(element.getAttribute(CONTENT_TYPE_ATTRIBUTE));
        }

        private IPresentationReconciler getDelegate() {
            if (this.delegate == null) {
                try {
                    this.delegate = (IPresentationReconciler)this.extension.createExecutableExtension(CLASS_ATTRIBUTE);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return this.delegate;
        }

        public void install(ITextViewer viewer) {
            this.getDelegate().install(viewer);
        }

        public void uninstall() {
            this.getDelegate().uninstall();
        }

        public IPresentationDamager getDamager(String contentType) {
            return this.getDelegate().getDamager(contentType);
        }

        public IPresentationRepairer getRepairer(String contentType) {
            return this.getDelegate().getRepairer(contentType);
        }
    }
}

