/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.commands.CommandUtil;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.editparts.FBEditPart;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractCreateFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IEditorInput;

public class NewSubAppCommand
extends AbstractCreateFBNetworkElementCommand {
    private IEditorInput input = null;
    private List<?> selection;
    private final HashMap<IInterfaceElement, IInterfaceElement> connectionModifiers = new HashMap();
    private final List<List<?>> modifyConnnection = new ArrayList();
    private final List<FBNetworkElement> contents = new ArrayList<FBNetworkElement>();
    CompoundCommand unmappingCmds = new CompoundCommand();
    MapToCommand mappSubappCmd = null;
    boolean createConnection;

    public NewSubAppCommand(FBNetwork fbNetwork, List<?> selection, int x, int y) {
        super(fbNetwork, x, y);
        this.selection = selection;
        this.element = LibraryElementFactory.eINSTANCE.createSubApp();
        this.element.setInterface(this.getTypeInterfaceList());
    }

    public void execute() {
        this.getSubApp().setSubAppNetwork(LibraryElementFactory.eINSTANCE.createFBNetwork());
        super.execute();
        this.buildUpElementList();
        this.unmappingCmds.execute();
        this.addElementsToSubapp();
        if (this.mappSubappCmd != null) {
            this.mappSubappCmd.execute();
        }
        this.openClosedEditor();
    }

    public void redo() {
        super.redo();
        this.unmappingCmds.redo();
        this.addElementsToSubapp();
        if (this.mappSubappCmd != null) {
            this.mappSubappCmd.redo();
        }
        this.openClosedEditor();
    }

    public void undo() {
        if (this.mappSubappCmd != null) {
            this.mappSubappCmd.undo();
        }
        super.undo();
        for (FBNetworkElement el : this.contents) {
            this.fbNetwork.getNetworkElements().add((Object)el);
            this.createConnection(el, false);
        }
        this.unmappingCmds.undo();
        this.element.setInterface(this.getTypeInterfaceList());
        this.connectionModifiers.clear();
        this.modifyConnnection.clear();
        this.closeOpenedSubApp();
    }

    private void buildUpElementList() {
        Resource res = null;
        int resCount = 0;
        for (Object ne : this.selection) {
            if (!(ne instanceof FBEditPart) && !(ne instanceof SubAppForFBNetworkEditPart)) continue;
            FBNetworkElement element = ((AbstractFBNElementEditPart)((Object)ne)).getModel();
            this.contents.add(element);
            if (element.isMapped()) {
                this.unmappingCmds.add((Command)new UnmapCommand(element));
                if (resCount == 0) {
                    resCount = 1;
                    res = element.getResource();
                    continue;
                }
                if (res == element.getResource()) continue;
                resCount = -1;
                continue;
            }
            resCount = -1;
        }
        if (1 == resCount && res != null) {
            this.mappSubappCmd = new MapToCommand((FBNetworkElement)this.getSubApp(), res);
        }
    }

    private void addElementsToSubapp() {
        for (FBNetworkElement el : this.contents) {
            this.getSubApp().getSubAppNetwork().getNetworkElements().add((Object)el);
            this.createConnection(el, true);
        }
    }

    private void moveConnection(Connection con, boolean isRedo) {
        int index;
        if (con instanceof EventConnection) {
            if (isRedo) {
                index = this.fbNetwork.getEventConnections().indexOf((Object)con);
                if (index > -1) {
                    this.getSubApp().getSubAppNetwork().addConnection((Connection)this.fbNetwork.getEventConnections().get(index));
                }
            } else {
                index = this.getSubApp().getSubAppNetwork().getEventConnections().indexOf((Object)con);
                if (index > -1) {
                    this.fbNetwork.addConnection((Connection)this.getSubApp().getSubAppNetwork().getEventConnections().get(index));
                }
            }
        }
        if (con instanceof DataConnection) {
            if (isRedo) {
                index = this.fbNetwork.getDataConnections().indexOf((Object)con);
                if (index > -1) {
                    this.getSubApp().getSubAppNetwork().addConnection((Connection)this.fbNetwork.getDataConnections().get(index));
                }
            } else {
                index = this.getSubApp().getSubAppNetwork().getDataConnections().indexOf((Object)con);
                if (index > -1) {
                    this.fbNetwork.addConnection((Connection)this.getSubApp().getSubAppNetwork().getDataConnections().get(index));
                }
            }
        }
        if (con instanceof AdapterConnection) {
            if (isRedo) {
                index = this.fbNetwork.getAdapterConnections().indexOf((Object)con);
                if (index > -1) {
                    this.getSubApp().getSubAppNetwork().addConnection((Connection)this.fbNetwork.getAdapterConnections().get(index));
                }
            } else {
                index = this.getSubApp().getSubAppNetwork().getAdapterConnections().indexOf((Object)con);
                if (index > -1) {
                    this.fbNetwork.addConnection((Connection)this.getSubApp().getSubAppNetwork().getAdapterConnections().get(index));
                }
            }
        }
    }

    private void createConnection(FBNetworkElement ne, boolean isRedo) {
        for (IInterfaceElement ie : ne.getInterface().getAllInterfaceElements()) {
            IInterfaceElement newie;
            if (ie.isIsInput()) {
                for (Connection con : ie.getInputConnections()) {
                    if (this.isContained(con.getSourceElement())) {
                        this.moveConnection(con, isRedo);
                        continue;
                    }
                    if (!isRedo) continue;
                    newie = this.addInterfaceElement(con.getDestination());
                    this.connectionModifiers.put(newie, con.getDestination());
                    this.modifyConnnection.add(this.markConnectionForModification(con, false, newie));
                    if (!this.createConnection) continue;
                    this.modifyConnnection.add(this.markConnectionForModification((Connection)EcoreUtil.copy((EObject)con), newie, con.getDestination()));
                }
                continue;
            }
            for (Connection con : ie.getOutputConnections()) {
                if (this.isContained(con.getDestinationElement())) {
                    this.moveConnection(con, isRedo);
                    continue;
                }
                if (!isRedo) continue;
                newie = this.addInterfaceElement(con.getSource());
                this.connectionModifiers.put(newie, con.getSource());
                this.modifyConnnection.add(this.markConnectionForModification(con, true, newie));
                if (!this.createConnection) continue;
                this.modifyConnnection.add(this.markConnectionForModification((Connection)EcoreUtil.copy((EObject)con), con.getSource(), newie));
            }
        }
        for (List<?> list : this.modifyConnnection) {
            if (isRedo) {
                if (list.get(1) instanceof Boolean) {
                    if (((Boolean)list.get(1)).booleanValue()) {
                        ((Connection)list.get(0)).setSource((IInterfaceElement)list.get(2));
                    } else {
                        ((Connection)list.get(0)).setDestination((IInterfaceElement)list.get(2));
                    }
                } else {
                    ((Connection)list.get(0)).setSource((IInterfaceElement)list.get(1));
                    ((Connection)list.get(0)).setDestination((IInterfaceElement)list.get(2));
                }
                if (!this.isSubappInternalConnection((Connection)list.get(0))) continue;
                this.getSubApp().getSubAppNetwork().addConnection((Connection)list.get(0));
                continue;
            }
            if (list.get(1) instanceof Boolean) {
                if (((Boolean)list.get(1)).booleanValue()) {
                    ((Connection)list.get(0)).setSource(this.connectionModifiers.get(list.get(2)));
                    continue;
                }
                ((Connection)list.get(0)).setDestination(this.connectionModifiers.get(list.get(2)));
                continue;
            }
            ((IInterfaceElement)list.get(1)).getOutputConnections().remove(list.get(0));
            ((IInterfaceElement)list.get(2)).getInputConnections().remove(list.get(0));
        }
    }

    private ArrayList<?> markConnectionForModification(Connection connection, Object modifySource, IInterfaceElement iie) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(connection);
        list.add(modifySource);
        list.add(iie);
        return list;
    }

    private boolean isSubappInternalConnection(Connection con) {
        return !(!con.getSourceElement().equals(this.element) && !this.getSubApp().getSubAppNetwork().getNetworkElements().contains((Object)con.getSourceElement()) || !con.getDestinationElement().equals(this.element) && !this.getSubApp().getSubAppNetwork().getNetworkElements().contains((Object)con.getDestinationElement()));
    }

    private boolean isContained(FBNetworkElement e) {
        for (Object ne : this.selection) {
            if (!(ne instanceof AbstractFBNElementEditPart) || !((EditPart)ne).getModel().equals(e)) continue;
            return true;
        }
        return false;
    }

    private IInterfaceElement addInterfaceElement(IInterfaceElement ie) {
        IInterfaceElement newie = (IInterfaceElement)EcoreUtil.copy((EObject)ie);
        newie.setName(String.valueOf(ie.getFBNetworkElement().getName()) + "_" + ie.getName());
        if (this.getSubApp().getInterfaceElement(newie.getName()) == null) {
            this.createConnection = true;
            if (ie instanceof Event) {
                ((Event)newie).getWith().clear();
                if (ie.isIsInput()) {
                    this.getSubApp().getInterface().getEventInputs().add((Object)((Event)newie));
                } else {
                    this.getSubApp().getInterface().getEventOutputs().add((Object)((Event)newie));
                }
                return newie;
            }
            if (ie instanceof AdapterDeclaration) {
                if (ie.isIsInput()) {
                    this.getSubApp().getInterface().getSockets().add((Object)((AdapterDeclaration)newie));
                } else {
                    this.getSubApp().getInterface().getPlugs().add((Object)((AdapterDeclaration)newie));
                }
                return newie;
            }
            if (ie instanceof VarDeclaration) {
                if (ie.isIsInput()) {
                    this.getSubApp().getInterface().getInputVars().add((Object)((VarDeclaration)newie));
                } else {
                    this.getSubApp().getInterface().getOutputVars().add((Object)((VarDeclaration)newie));
                }
                return newie;
            }
        } else {
            this.createConnection = false;
            return this.getSubApp().getInterfaceElement(newie.getName());
        }
        return newie;
    }

    protected InterfaceList getTypeInterfaceList() {
        return LibraryElementFactory.eINSTANCE.createInterfaceList();
    }

    protected String getInitalInstanceName() {
        return "SubApp";
    }

    private void closeOpenedSubApp() {
        this.input = CommandUtil.closeOpenedSubApp(this.getSubApp().getSubAppNetwork());
    }

    private SubApp getSubApp() {
        return (SubApp)this.element;
    }

    private void openClosedEditor() {
        if (this.input != null) {
            CommandUtil.openSubAppEditor(this.input);
        }
    }
}

