/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.gef.properties.TypeInfoSection;
import org.eclipse.fordiac.ide.gef.provider.CompilerContentProvider;
import org.eclipse.fordiac.ide.gef.provider.CompilerLabelProvider;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCompilerInfoClassdefCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCompilerInfoHeaderCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCompilerLanguageCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCompilerProductCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCompilerVendorCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCompilerVersionCommand;
import org.eclipse.fordiac.ide.model.commands.create.AddNewCompilerCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteCompilerCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Compiler;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.Language;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class CompilableTypeInfoSection
extends TypeInfoSection {
    private static final String LANGUAGE_OTHER = "Other";
    private static final String LANGUAGE_C = "C";
    private static final String LANGUAGE_CPP = "Cpp";
    private static final String LANGUAGE_JAVA = "Java";
    private TableViewer compilerViewer;
    private Group compilerInfoGroup;
    private Text headerText;
    private Text classdefText;
    private Button compilerInfoNew;
    private Button compilerInfoDelete;
    private static final String COMPILER_VERSION = "compiler_version";
    private static final String COMPILER_LANGUAGE = "language";
    private static final String COMPILER_VENDOR = "vendor";
    private static final String COMPILER_PRODUCT = "product";
    private static final String[] VALUE_SET = new String[]{"Java", "Cpp", "C", "Other"};

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createCompilerInfoGroup(this.rightComposite);
    }

    private void createCompilerInfoGroup(Composite parent) {
        this.compilerInfoGroup = this.getWidgetFactory().createGroup(parent, "Compiler Info");
        this.compilerInfoGroup.setLayout((Layout)new GridLayout(1, false));
        this.compilerInfoGroup.setLayoutData((Object)new GridData(4, 0, false, false));
        Composite composite = this.getWidgetFactory().createComposite((Composite)this.compilerInfoGroup, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, false, false));
        this.getWidgetFactory().createCLabel(composite, "Header:");
        this.headerText = this.createGroupText(composite, true);
        this.headerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompilableTypeInfoSection.this.executeCommand((Command)new ChangeCompilerInfoHeaderCommand((FBType)CompilableTypeInfoSection.this.type, CompilableTypeInfoSection.this.headerText.getText()));
            }
        });
        this.getWidgetFactory().createCLabel(composite, "Classdef:");
        this.classdefText = this.createGroupText(composite, true);
        this.classdefText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompilableTypeInfoSection.this.executeCommand((Command)new ChangeCompilerInfoClassdefCommand((FBType)CompilableTypeInfoSection.this.type, CompilableTypeInfoSection.this.classdefText.getText()));
            }
        });
        Composite compositeBottom = this.getWidgetFactory().createComposite((Composite)this.compilerInfoGroup);
        compositeBottom.setLayout((Layout)new GridLayout(2, false));
        compositeBottom.setLayoutData((Object)new GridData(4, 0, true, false));
        this.compilerViewer = new TableViewer(compositeBottom, 68352);
        GridData gridDataVersionViewer = new GridData(1808);
        gridDataVersionViewer.heightHint = 80;
        gridDataVersionViewer.widthHint = 400;
        this.compilerViewer.getControl().setLayoutData((Object)gridDataVersionViewer);
        Table table = this.compilerViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(this.compilerViewer.getTable(), 16384);
        column1.setText("Language");
        TableColumn column2 = new TableColumn(this.compilerViewer.getTable(), 16384);
        column2.setText("Vendor");
        TableColumn column3 = new TableColumn(this.compilerViewer.getTable(), 16384);
        column3.setText("Product");
        TableColumn column4 = new TableColumn(this.compilerViewer.getTable(), 16384);
        column4.setText("Version");
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, 80));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, 100));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, 100));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, 80));
        table.setLayout((Layout)layout);
        this.compilerViewer.setContentProvider((IContentProvider)new CompilerContentProvider());
        this.compilerViewer.setLabelProvider((IBaseLabelProvider)new CompilerLabelProvider());
        this.compilerViewer.setCellEditors(new CellEditor[]{new ComboBoxCellEditor((Composite)table, VALUE_SET), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.compilerViewer.setColumnProperties(new String[]{COMPILER_LANGUAGE, COMPILER_VENDOR, COMPILER_PRODUCT, COMPILER_VERSION});
        Composite buttonComp = new Composite(compositeBottom, 0);
        buttonComp.setLayout((Layout)new FillLayout(512));
        this.compilerInfoNew = this.getWidgetFactory().createButton(buttonComp, "New", 8);
        this.compilerInfoNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.compilerInfoNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CompilableTypeInfoSection.this.executeCommand((Command)new AddNewCompilerCommand((FBType)CompilableTypeInfoSection.this.type));
                CompilableTypeInfoSection.this.compilerViewer.refresh();
            }
        });
        this.compilerInfoDelete = this.getWidgetFactory().createButton(buttonComp, "Delete", 8);
        this.compilerInfoDelete.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.compilerInfoDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CompilableTypeInfoSection.this.executeCommand((Command)new DeleteCompilerCommand(((FBType)CompilableTypeInfoSection.this.type).getCompilerInfo(), (Compiler)((IStructuredSelection)CompilableTypeInfoSection.this.compilerViewer.getSelection()).getFirstElement()));
                CompilableTypeInfoSection.this.compilerViewer.refresh();
            }
        });
        this.compilerViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                if (CompilableTypeInfoSection.COMPILER_LANGUAGE.equals(property)) {
                    String language = ((Compiler)element).getLanguage().getName();
                    if (language.equals(CompilableTypeInfoSection.LANGUAGE_JAVA)) {
                        return 0;
                    }
                    if (language.equals(CompilableTypeInfoSection.LANGUAGE_CPP)) {
                        return 1;
                    }
                    if (language.equals(CompilableTypeInfoSection.LANGUAGE_C)) {
                        return 2;
                    }
                    return 3;
                }
                if (CompilableTypeInfoSection.COMPILER_PRODUCT.equals(property)) {
                    return ((Compiler)element).getProduct();
                }
                if (CompilableTypeInfoSection.COMPILER_VENDOR.equals(property)) {
                    return ((Compiler)element).getVendor();
                }
                return ((Compiler)element).getVersion();
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                Compiler data = (Compiler)tableItem.getData();
                Object cmd = null;
                if (CompilableTypeInfoSection.COMPILER_LANGUAGE.equals(property)) {
                    switch ((Integer)value) {
                        case 0: {
                            cmd = new ChangeCompilerLanguageCommand(data, Language.get((String)CompilableTypeInfoSection.LANGUAGE_JAVA));
                            break;
                        }
                        case 1: {
                            cmd = new ChangeCompilerLanguageCommand(data, Language.get((String)CompilableTypeInfoSection.LANGUAGE_CPP));
                            break;
                        }
                        case 2: {
                            cmd = new ChangeCompilerLanguageCommand(data, Language.get((String)CompilableTypeInfoSection.LANGUAGE_C));
                            break;
                        }
                        case 3: {
                            cmd = new ChangeCompilerLanguageCommand(data, Language.get((String)CompilableTypeInfoSection.LANGUAGE_OTHER));
                        }
                    }
                } else {
                    cmd = CompilableTypeInfoSection.COMPILER_PRODUCT.equals(property) ? new ChangeCompilerProductCommand(data, value.toString()) : (CompilableTypeInfoSection.COMPILER_VENDOR.equals(property) ? new ChangeCompilerVendorCommand(data, value.toString()) : new ChangeCompilerVersionCommand(data, value.toString()));
                }
                if (cmd != null) {
                    CompilableTypeInfoSection.this.executeCommand((Command)cmd);
                    CompilableTypeInfoSection.this.compilerViewer.refresh((Object)data);
                }
            }
        });
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.commandStack = this.getCommandStack(part, null);
        if (this.commandStack == null) {
            this.headerText.setEnabled(false);
            this.classdefText.setEnabled(false);
            this.compilerInfoNew.setEnabled(false);
            this.compilerInfoDelete.setEnabled(false);
            this.compilerViewer.setCellModifier(null);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null && this.type instanceof FBType && ((FBType)this.type).getCompilerInfo() != null) {
            this.headerText.setText(((FBType)this.type).getCompilerInfo().getHeader() != null ? ((FBType)this.type).getCompilerInfo().getHeader() : "");
            this.classdefText.setText(((FBType)this.type).getCompilerInfo().getClassdef() != null ? ((FBType)this.type).getCompilerInfo().getClassdef() : "");
            this.compilerViewer.setInput(this.type);
        }
        this.commandStack = commandStackBuffer;
    }
}

