/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_WSTRING;

public class IEC_STRING
extends IEC_WSTRING {
    public IEC_STRING() {
        this.value = "";
    }

    public IEC_STRING(String initial) {
        this.value = new String(initial.getBytes());
    }

    public IEC_STRING(DataInputStream in) {
        super(in);
    }

    @Override
    public void decodeValueFrom(DataInputStream in) {
        StringBuilder result = new StringBuilder();
        try {
            int size = in.readShort();
            int i = 0;
            while (i < size) {
                result.append((char)in.readUnsignedByte());
                ++i;
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        this.value = result.toString();
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{80};
        return retval;
    }

    @Override
    public byte[] encodeValue() {
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        DataOutputStream outputString = new DataOutputStream(myOut);
        try {
            outputString.writeShort(this.value.length());
            outputString.write(this.value.getBytes());
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return myOut.toByteArray();
    }

    @Override
    public boolean setValue(String value) {
        try {
            this.value = new String(value.getBytes("UTF-8"));
            return true;
        }
        catch (UnsupportedEncodingException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return false;
        }
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_STRING)source).getValue();
            retval = true;
        }
        return retval;
    }
}

